/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.engine.plugin.dml.model.sql;

import com.baomidou.mybatisplus.core.enums.SqlLike;
import com.baomidou.mybatisplus.core.toolkit.sql.SqlUtils;
import com.jxdinfo.hussar.platform.core.utils.convert.HussarConverter;
import com.jxdinfo.hussar.support.engine.api.enums.OperatorType;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.sql.ValueEntity;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SetEntity
extends ValueEntity {
    private OperatorType operatorType;
    private String setSql;

    public void setOperatorType(OperatorType operatorType) {
        if (OperatorType.IN.equals((Object)operatorType) || OperatorType.NOT_IN.equals((Object)operatorType)) {
            this.setEnableCollection(true);
        }
        this.operatorType = operatorType;
    }

    public OperatorType getOperatorType() {
        return this.operatorType;
    }

    @Override
    public void processingParam() {
        this.operatorSql();
    }

    private void operatorSql() {
        String sql;
        if (this.operatorType == null) {
            return;
        }
        Object val = this.getVal();
        switch (this.operatorType) {
            case IN: 
            case NOT_IN: {
                HashMap map;
                if (this.isNoll()) {
                    return;
                }
                if (val instanceof Map) {
                    map = (HashMap)val;
                } else {
                    Class<?> name = null;
                    try {
                        name = Class.forName(this.getColumnEntity().getColJavaType());
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                    map = new HashMap();
                    List inValues = (List)val;
                    for (int i = 0; i < inValues.size(); ++i) {
                        String colAlias = "v" + i;
                        map.put(colAlias, name != null ? HussarConverter.convert(name, inValues.get(i)) : inValues.get(i));
                    }
                    this.setParamColumnAlias(this.getParamColumnAlias() + this.operatorType.getValue());
                    this.setVal(map);
                }
                StringBuilder valueSql = new StringBuilder();
                valueSql.append("(");
                int i = 0;
                for (String colAlias : map.keySet()) {
                    if (i != 0) {
                        valueSql.append(",");
                    }
                    valueSql.append("#{").append(this.getValueAlias()).append(".").append(colAlias).append("}");
                    ++i;
                }
                valueSql.append(")");
                sql = valueSql.toString();
                break;
            }
            case LIKE: 
            case LEFT_LIKE: 
            case RIGHT_LIKE: {
                if (this.isNoll()) {
                    return;
                }
                this.getColumnEntity().setColJavaType(String.class.getName());
                SqlLike sqlLike = this.operatorType == OperatorType.LIKE ? SqlLike.DEFAULT : (this.operatorType == OperatorType.LEFT_LIKE ? SqlLike.RIGHT : SqlLike.LEFT);
                this.setVal(SqlUtils.concatLike((Object)this.getVal(), (SqlLike)sqlLike));
                this.setParamColumnAlias(this.getParamColumnAlias() + this.operatorType.getValue());
                sql = this.sql();
                break;
            }
            case IS_NULL: {
                sql = "";
                break;
            }
            default: {
                sql = this.sql();
            }
        }
        this.setSql = String.format(" %s %s %s ", this.getColumnEntity().getColNameEnableEscape(), this.operatorType.getKeyword().getSqlSegment(), sql);
    }

    public String getSetSql() {
        return this.setSql;
    }
}

