/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.engine.plugin.dml.model.sql;

import com.baomidou.mybatisplus.core.enums.SqlKeyword;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.engine.api.enums.JoinTypeEnum;
import com.jxdinfo.hussar.support.engine.core.enums.EngineExceptionEnum;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.TableEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.sql.OnCondition;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.util.List;
import java.util.stream.Collectors;

public class JoinEntity {
    private JoinTypeEnum joinType;
    private boolean oneToN;
    private List<OnCondition> onConditionList;

    public JoinTypeEnum getJoinType() {
        return this.joinType;
    }

    public void setJoinType(JoinTypeEnum joinType) {
        this.joinType = joinType;
    }

    public List<OnCondition> getOnConditionList() {
        return this.onConditionList;
    }

    public void setOnConditionList(List<OnCondition> onConditionList) {
        this.onConditionList = onConditionList;
    }

    public String getJoinSql(boolean msPage) {
        if (msPage && this.oneToN) {
            return "";
        }
        return this.getJoinSql();
    }

    public String getJoinSql() {
        HussarException.throwBy((boolean)HussarUtils.isEmpty(this.onConditionList), (Integer)EngineExceptionEnum.ON_FAIL.getExceptionCode(), (String)EngineExceptionEnum.ON_FAIL.getMessage());
        String onStr = this.onConditionList.size() == 1 ? this.getFirstOnCondition().getOnSql() : this.onConditionList.stream().map(OnCondition::getOnSql).collect(Collectors.joining(SqlKeyword.AND.getSqlSegment()));
        return String.format(" %s %s ON %s ", this.joinType.value, this.getRightTable().getTableNameAndAlias(), onStr);
    }

    private OnCondition getFirstOnCondition() {
        return this.onConditionList.get(0);
    }

    public String getFirstJoinSql() {
        return this.getLeftTable().getTableNameAndAlias() + this.getJoinSql();
    }

    public String getFirstJoinSql(boolean msPage) {
        return this.getLeftTable().getTableNameAndAlias() + this.getJoinSql(msPage);
    }

    public TableEntity getLeftTable() {
        return this.getFirstOnCondition().getLeftColumn().getTableEntity();
    }

    public TableEntity getRightTable() {
        return this.getFirstOnCondition().getRightColumn().getTableEntity();
    }

    public void setOneToN(boolean oneToN) {
        this.oneToN = oneToN;
    }
}

