/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.engine.plugin.dml.model.dml;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.engine.api.dto.ModelTableMappingDTO;
import com.jxdinfo.hussar.support.engine.api.enums.ParameterType;
import com.jxdinfo.hussar.support.engine.core.enums.EngineExceptionEnum;
import com.jxdinfo.hussar.support.engine.core.enums.PurposeEnum;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.ColumnEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.dml.DmlEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.sql.SetEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.sql.WhereEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.util.DmlEntityUtil;
import com.jxdinfo.hussar.support.engine.plugin.dml.util.DmlSqlUtil;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.jdbc.SQL;

public class UpdateEntity
implements DmlEntity {
    private List<SetEntity> setEntityList;
    private List<WhereEntity> whereEntityList;
    private String setSql;
    private String whereSql;
    private ModelTableMappingDTO relationship;
    private Map<String, Object> param;

    @Override
    public UpdateEntity builder() {
        this.setEntityList = new ArrayList<SetEntity>();
        this.whereEntityList = new ArrayList<WhereEntity>();
        return this;
    }

    @Override
    public UpdateEntity init(Map<String, Object> param) {
        this.param = param;
        for (WhereEntity whereEntity : this.whereEntityList) {
            whereEntity.initVal(param);
        }
        for (SetEntity setEntity : this.setEntityList) {
            ColumnEntity columnEntity = setEntity.getColumnEntity();
            if (HussarUtils.isNotBlank((CharSequence)columnEntity.getPurpose())) {
                DmlEntityUtil.value(param, columnEntity.getColAlias(), columnEntity.getPurpose(), ParameterType.set);
            }
            setEntity.initVal(param);
        }
        this.initSql();
        return this;
    }

    private void initSql() {
        this.whereSql = "";
        String whereSqlStr = DmlSqlUtil.getWhereSql(DmlEntityUtil.getWhereTree(this.whereEntityList));
        if (HussarUtils.isNotEmpty((Object)whereSqlStr)) {
            this.whereSql = whereSqlStr;
        }
        ArrayList<String> set = new ArrayList<String>();
        for (SetEntity setEntity : this.setEntityList) {
            ColumnEntity columnEntity = setEntity.getColumnEntity();
            if (columnEntity != null) {
                String purposeStr = columnEntity.getPurpose();
                PurposeEnum purpose = PurposeEnum.getByValue((String)purposeStr);
                if (setEntity.isNoll() && purpose != null && (purpose == PurposeEnum.CREATE_TIME || purpose == PurposeEnum.CREATE_USER || purpose == PurposeEnum.DATA_HOLDER || purpose == PurposeEnum.DATA_ORGAN)) continue;
            }
            set.add(setEntity.getSetSql());
        }
        this.setSql = HussarUtils.join(set);
    }

    public String getTableName() {
        return this.entity().getTableName();
    }

    public String getKeyProperty() {
        return this.entity().getKeyProperty();
    }

    public String getWhereSql() {
        return this.whereSql;
    }

    public String getSetSql() {
        return this.setSql;
    }

    public String getSqlComment() {
        return "";
    }

    public ModelTableMappingDTO getRelationship() {
        return this.relationship;
    }

    public void setRelationship(ModelTableMappingDTO relationship) {
        this.relationship = relationship;
    }

    public Map<String, Object> getParam() {
        return this.param;
    }

    private ColumnEntity entity() {
        this.isNotEmptySet();
        return this.setEntityList.get(0).getColumnEntity();
    }

    public List<SetEntity> getSetEntityList() {
        return this.setEntityList;
    }

    public void setSetEntityList(List<SetEntity> setEntityList) {
        this.setEntityList = setEntityList;
    }

    public List<WhereEntity> getWhereEntityList() {
        return this.whereEntityList;
    }

    public void setWhereEntityList(List<WhereEntity> whereEntityList) {
        this.whereEntityList = whereEntityList;
    }

    private void isNotEmptySet() {
        HussarException.throwBy((boolean)HussarUtils.isEmpty(this.setEntityList), (Integer)EngineExceptionEnum.SETS_FAIL.getExceptionCode(), (String)EngineExceptionEnum.SETS_FAIL.getMessage());
    }

    @Override
    public String getSql() {
        SQL sql = (SQL)((SQL)new SQL().UPDATE(this.getTableName())).SET(this.getSetSql());
        if (HussarUtils.isNotEmpty((Object)this.whereSql)) {
            sql.WHERE(this.whereSql);
        }
        return sql.toString() + this.getSqlComment();
    }

    @Override
    public String getPoolName() {
        return this.entity().getPoolName();
    }
}

