/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.engine.plugin.dml.intercepts;

import com.baomidou.mybatisplus.core.toolkit.PluginUtils;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.engine.api.dto.ModelTableMappingDTO;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.dml.SelectEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.dml.SelectExpressionEntity;
import com.jxdinfo.hussar.support.engine.plugin.model.application.IModelResultMapService;
import java.sql.Statement;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.ibatis.executor.parameter.ParameterHandler;
import org.apache.ibatis.executor.resultset.ResultSetHandler;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.apache.ibatis.session.Configuration;
import org.springframework.context.annotation.Lazy;

@Intercepts(value={@Signature(type=ResultSetHandler.class, method="handleResultSets", args={Statement.class})})
public class EngineResultIntercept
implements Interceptor {
    @Resource
    @Lazy
    private IModelResultMapService modelResultMapService;

    public Object intercept(Invocation invocation) throws Throwable {
        ResultSetHandler target = (ResultSetHandler)invocation.getTarget();
        this.initResultSetHandler(target);
        Object object = invocation.proceed();
        this.handleColumnTranslate(object);
        return object;
    }

    private void initResultSetHandler(ResultSetHandler target) {
        MetaObject rh = SystemMetaObject.forObject((Object)(target = (ResultSetHandler)PluginUtils.realTarget((Object)target)));
        ParameterHandler parameterHandler = (ParameterHandler)rh.getValue("parameterHandler");
        if (HussarUtils.isEmpty((Object)parameterHandler.getParameterObject())) {
            return;
        }
        SelectEntity pm = EngineResultIntercept.findParameter(parameterHandler.getParameterObject(), SelectEntity.class);
        if (pm != null && HussarUtils.isNotEmpty((Object)pm.getResultMapId())) {
            this.updateMappedStatement(rh, pm.getResultMapId(), pm.getModel());
        } else {
            SelectExpressionEntity entity = EngineResultIntercept.findParameter(parameterHandler.getParameterObject(), SelectExpressionEntity.class);
            if (entity != null && HussarUtils.isNotEmpty((Object)entity.getResultMapId())) {
                this.updateMappedStatement(rh, entity.getResultMapId(), entity.getModel());
            }
        }
    }

    private void updateMappedStatement(MetaObject rh, String resultMapId, ModelTableMappingDTO model) {
        MappedStatement ms = (MappedStatement)rh.getValue("mappedStatement");
        if (this.isNotPageCountSelect(ms)) {
            ResultMap resultMap;
            Configuration configuration = ms.getConfiguration();
            configuration.setCallSettersOnNulls(true);
            if (!configuration.hasResultMap(resultMapId)) {
                this.modelResultMapService.createResultMap(model);
            }
            if ((resultMap = configuration.getResultMap(resultMapId)) == null) {
                return;
            }
            MappedStatement.Builder builder = new MappedStatement.Builder(configuration, ms.getId(), ms.getSqlSource(), ms.getSqlCommandType());
            builder.resultMaps(Collections.singletonList(resultMap));
            rh.setValue("mappedStatement", (Object)builder.build());
        }
    }

    private boolean isNotPageCountSelect(MappedStatement ms) {
        return !((ResultMap)ms.getResultMaps().get(0)).getId().equals("mybatis-plus");
    }

    private static <T> T findParameter(Object parameterObject, Class<T> clazz) {
        if (parameterObject != null) {
            if (parameterObject instanceof Map) {
                for (Object entry : ((Map)parameterObject).values()) {
                    if (entry == null || !clazz.isAssignableFrom(entry.getClass())) continue;
                    return (T)entry;
                }
            } else if (clazz.isAssignableFrom(parameterObject.getClass())) {
                return (T)parameterObject;
            }
        }
        return null;
    }

    private void handleColumnTranslate(Object result) {
    }
}

