/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.engine.plugin.dml.support.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.jxdinfo.hussar.datasource.manager.api.entity.MetadataColumn;
import com.jxdinfo.hussar.datasource.manager.api.model.MetadataColumnDto;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.convert.HussarConverter;
import com.jxdinfo.hussar.support.engine.api.dto.ModelColumnDto;
import com.jxdinfo.hussar.support.engine.api.dto.ModelTableMappingDTO;
import com.jxdinfo.hussar.support.engine.api.dto.NodeBusinessVo;
import com.jxdinfo.hussar.support.engine.api.entity.BpmPm;
import com.jxdinfo.hussar.support.engine.api.entity.ModelColumnsRules;
import com.jxdinfo.hussar.support.engine.api.enums.MatchTypeEnum;
import com.jxdinfo.hussar.support.engine.api.enums.ModelRelation;
import com.jxdinfo.hussar.support.engine.api.model.RelationshipOnDto;
import com.jxdinfo.hussar.support.engine.api.service.BpmPmService;
import com.jxdinfo.hussar.support.engine.api.service.UnderlyingService;
import com.jxdinfo.hussar.support.engine.core.annotations.EngineMethod;
import com.jxdinfo.hussar.support.engine.core.annotations.EngineService;
import com.jxdinfo.hussar.support.engine.core.enums.ColumnRuleType;
import com.jxdinfo.hussar.support.engine.core.enums.DataServiceType;
import com.jxdinfo.hussar.support.engine.core.enums.EngineExceptionEnum;
import com.jxdinfo.hussar.support.engine.core.enums.PurposeEnum;
import com.jxdinfo.hussar.support.engine.core.model.EngineResult;
import com.jxdinfo.hussar.support.engine.core.vo.PageVo;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.ColumnEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.dml.DeleteEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.dml.DmlEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.dml.InsertEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.dml.SelectEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.dml.SelectExpressionEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.dml.UpdateEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.sql.WhereEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.support.service.MsTableService;
import com.jxdinfo.hussar.support.engine.plugin.dml.support.service.SingleTableService;
import com.jxdinfo.hussar.support.engine.plugin.dml.util.DmlEntityUtil;
import com.jxdinfo.hussar.support.engine.plugin.model.util.ModelResultMapUtil;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@EngineService(value="com.jxdinfo.hussar.support.engine.plugin.dml.service.impl.engineMsTable", type=DataServiceType.PERMANENT, des="\u591a\u8868\u56fa\u5316service")
public class MsTableServiceImpl
implements MsTableService,
UnderlyingService {
    private static Logger LOGGER = LoggerFactory.getLogger(MsTableServiceImpl.class);
    private final SingleTableService singleTableService;
    private final BpmPmService bpmPmService;
    private static final String MASTER = "master";
    private static final String CHILD = "child";
    private static final String INCREMENTAL_KEY = "_t_";

    @Autowired
    public MsTableServiceImpl(SingleTableService singleTableService, BpmPmService bpmPmService) {
        this.singleTableService = singleTableService;
        this.bpmPmService = bpmPmService;
    }

    @Override
    @EngineMethod(des="\u591a\u8868\u4fdd\u5b58\u6216\u4fee\u6539", paramDes={"\u66f4\u65b0\u5bf9\u8c61\u96c6\u5408"}, returnDes="\u591a\u8868\u8fd4\u56de\u503c")
    @DSTransactional
    public ApiResponse saveOrUpdate(Map<String, Object> updateEntity) {
        if (HussarUtils.isEmpty(updateEntity)) {
            throw new HussarException(EngineExceptionEnum.UPDATE_ENTITY_EMPTY.getExceptionCode(), EngineExceptionEnum.UPDATE_ENTITY_EMPTY.getMessage());
        }
        ApiResponse result = ApiResponse.success();
        if (updateEntity.containsKey(MASTER)) {
            List dmlEntityList;
            ModelTableMappingDTO model;
            DmlEntity entity;
            DmlEntity dmlEntity = (DmlEntity)updateEntity.get(MASTER);
            if (dmlEntity instanceof UpdateEntity) {
                entity = (UpdateEntity)dmlEntity;
                model = ((UpdateEntity)entity).getModel();
            } else {
                entity = (InsertEntity)dmlEntity;
                model = ((InsertEntity)entity).getModel();
            }
            if (updateEntity.containsKey(CHILD) && HussarUtils.isNotEmpty((Object)updateEntity.get(CHILD)) && !(result = this.checkSlaveRule(model, dmlEntityList = (List)updateEntity.get(CHILD))).isSuccess()) {
                return result;
            }
            if (dmlEntity instanceof UpdateEntity) {
                entity = (UpdateEntity)dmlEntity;
                result = this.singleTableService.saveOrUpdate((UpdateEntity)entity);
            } else {
                entity = (InsertEntity)dmlEntity;
                result = this.singleTableService.save((InsertEntity)entity);
            }
            if (result.isSuccess() && updateEntity.containsKey(CHILD) && HussarUtils.isNotEmpty((Object)updateEntity.get(CHILD))) {
                dmlEntityList = (List)updateEntity.get(CHILD);
                for (DmlEntity dmlItem : dmlEntityList) {
                    if (!(dmlItem instanceof DeleteEntity)) continue;
                    this.singleTableService.remove((DeleteEntity)dmlItem);
                }
                for (DmlEntity dmlItem : dmlEntityList) {
                    if (!(dmlItem instanceof InsertEntity)) continue;
                    this.singleTableService.save((InsertEntity)dmlItem);
                }
            }
        }
        return result;
    }

    private ApiResponse checkSlaveRule(ModelTableMappingDTO model, List<DmlEntity> dmlEntityList) {
        HashSet<String> columnCommentSet = new HashSet<String>();
        for (ModelTableMappingDTO slaveTable : model.getSlaveTables()) {
            ModelColumnsRules modelColumnsRules;
            ModelColumnDto columnDto;
            ArrayList<ModelColumnsRules> rules;
            List<Object> list = rules = HussarUtils.isEmpty((Object)slaveTable.getRules()) ? new ArrayList<ModelColumnsRules>() : slaveTable.getRules().stream().filter(r -> ColumnRuleType.UNIQUE.getValue().equals(r.getRuleType())).collect(Collectors.toList());
            if (HussarUtils.isEmpty(rules)) continue;
            ArrayList<Map<String, Object>> params = new ArrayList<Map<String, Object>>();
            for (DmlEntity entity : dmlEntityList) {
                if (!(entity instanceof InsertEntity)) continue;
                InsertEntity insertEntity = (InsertEntity)entity;
                ModelTableMappingDTO slaveModel = insertEntity.getModel();
                if (!slaveTable.getRelatedId().equals(slaveModel.getRelatedId())) continue;
                Map<String, Object> param = insertEntity.getParam();
                params.add(param);
            }
            if (params.isEmpty()) continue;
            DmlEntityUtil.DmlServiceEntity dmlServiceEntity = new DmlEntityUtil.DmlServiceEntity(slaveTable, ((RelationshipOnDto)slaveTable.getColumnOns().get(0)).getRightColumn());
            Iterator iterator = rules.iterator();
            while (iterator.hasNext() && (columnDto = slaveTable.getColumnById((modelColumnsRules = (ModelColumnsRules)iterator.next()).getModelColumnId())) != null) {
                List list2 = params.stream().map(p -> p.get(columnDto.getColumnAlias())).filter(HussarUtils::isNotEmpty).map(HussarUtils::toStr).collect(Collectors.toList());
                if (list2.size() == new HashSet(list2).size()) continue;
                columnCommentSet.add(String.format("'%s'", columnDto.getColumnComment()));
            }
            for (Map map : params) {
                this.checkUnique(slaveTable, dmlServiceEntity, map, rules, columnCommentSet);
            }
        }
        if (!columnCommentSet.isEmpty()) {
            return ApiResponse.fail((String)String.format("%s\u91cd\u590d\u8f93\u5165\uff01", HussarUtils.join(columnCommentSet, (String)"\uff0c")));
        }
        return ApiResponse.success();
    }

    private void checkUnique(ModelTableMappingDTO slaveTable, DmlEntityUtil.DmlServiceEntity dmlServiceEntity, Map<String, Object> param, List<ModelColumnsRules> rules, Set<String> columnCommentSet) {
        HashMap<Long, Object> columnValue = new HashMap<Long, Object>();
        Map<Long, Long> columnIdMap = slaveTable.getColumns().stream().collect(Collectors.toMap(ModelColumnDto::getModelColumnId, MetadataColumn::getColumnId));
        for (ModelColumnsRules rule : rules) {
            Long columnId = columnIdMap.get(rule.getModelColumnId());
            if (!HussarUtils.isNotEmpty((Object)columnId)) continue;
            columnValue.put(columnId, param.get(rule.getColumnAlias()));
        }
        SelectEntity selectEntity = dmlServiceEntity.selectByColumns(columnValue, MatchTypeEnum.OR);
        if (selectEntity != null && HussarUtils.isNotEmpty((Object)selectEntity.getWhereSql())) {
            MetadataColumnDto fkColumn = dmlServiceEntity.getFkColumn();
            selectEntity.appendWhere(String.format("%s <> #{et.param.%s,javaType=%s,jdbcType=%s}", fkColumn.getColumnName(), fkColumn.getColumnAlias(), fkColumn.getJavaType(), fkColumn.getJdbcType()), true);
            selectEntity.getParam().put(fkColumn.getColumnAlias(), param.get(fkColumn.getColumnAlias()));
            List list = this.selectList(selectEntity).getData();
            if (HussarUtils.isNotEmpty((Object)list)) {
                this.getFailMsg(columnValue, dmlServiceEntity.getColumnDtoMap(), list, columnCommentSet);
            }
        }
    }

    private void getFailMsg(Map<Long, Object> columnValue, Map<Long, MetadataColumnDto> columnMap, List<Object> list, Set<String> columnCommentSet) {
        block0: for (Map.Entry<Long, Object> entry : columnValue.entrySet()) {
            MetadataColumnDto columnDto = columnMap.get(entry.getKey());
            Object value = entry.getValue();
            if (HussarUtils.isEmpty((Object)columnDto) || HussarUtils.isEmpty((Object)value)) continue;
            String comment = String.format("'%s'", columnDto.getColumnComment());
            String columnAlias = columnDto.getColumnAlias();
            for (Object engineResult : list) {
                Object resultValue = ((Map)engineResult).get(columnAlias);
                if (!HussarUtils.equals((Object)HussarUtils.toStr((Object)value), (Object)HussarUtils.toStr(resultValue))) continue;
                columnCommentSet.add(comment);
                continue block0;
            }
        }
    }

    @Override
    @EngineMethod(des="\u591a\u8868\u5220\u9664", paramAlias={"entity"}, paramDes={"\u5220\u9664\u5bf9\u8c61"}, returnDes="\u591a\u8868\u8fd4\u56de\u503c")
    @DSTransactional
    public boolean remove(DeleteEntity entity) {
        if (HussarUtils.isEmpty((Object)entity)) {
            throw new HussarException(EngineExceptionEnum.DELETE_ENTITY_EMPTY.getExceptionCode(), EngineExceptionEnum.DELETE_ENTITY_EMPTY.getMessage());
        }
        boolean result = this.singleTableService.remove(entity);
        if (result) {
            try {
                this.removeSlaveTable(entity.getRelationship(), entity.getWhereEntityList());
            }
            catch (Exception e) {
                throw new HussarException("\u5220\u9664\u5931\u8d25");
            }
        }
        return result;
    }

    @Override
    @EngineMethod(des="\u591a\u8868\u903b\u8f91\u5220\u9664", paramDes={"\u5220\u9664\u5bf9\u8c61"}, returnDes="\u591a\u8868\u8fd4\u56de\u503c")
    @DSTransactional
    public boolean flagRemove(UpdateEntity entity) {
        boolean result;
        if (HussarUtils.isEmpty((Object)entity)) {
            throw new HussarException(EngineExceptionEnum.DELETE_ENTITY_EMPTY.getExceptionCode(), EngineExceptionEnum.DELETE_ENTITY_EMPTY.getMessage());
        }
        if (HussarUtils.isEmpty(entity.getSetEntityList())) {
            DeleteEntity deleteEntity = new DeleteEntity().builder();
            deleteEntity.setWhereEntityList(entity.getWhereEntityList());
            deleteEntity.init((Map)entity.getParam());
            result = this.singleTableService.remove(deleteEntity);
        } else {
            result = this.singleTableService.flagRemove(entity);
        }
        if (result) {
            try {
                this.flagRemoveSlaveTable(entity.getModel(), entity.getWhereEntityList());
            }
            catch (Exception e) {
                throw new HussarException("\u5220\u9664\u5931\u8d25");
            }
        }
        return result;
    }

    private void flagRemoveSlaveTable(ModelTableMappingDTO model, List<WhereEntity> whereEntityList) {
        HussarException.throwBy((HussarUtils.isEmpty((Object)model) || HussarUtils.isEmpty((Object)model.getSlaveTables()) ? 1 : 0) != 0, (String)"\u83b7\u53d6\u5173\u8054\u5173\u7cfb\u5f02\u5e38");
        for (ModelTableMappingDTO joinDto : model.getSlaveTables()) {
            boolean flagRemove = false;
            DeleteEntity deleteEntity = this.getDeleteByOn(joinDto.getColumnOns(), whereEntityList);
            for (ModelColumnDto column : joinDto.getColumns()) {
                if (!HussarUtils.isNotEmpty((Object)column.getPurpose()) || !PurposeEnum.DEL_FLAG.getValue().equals(column.getPurpose())) continue;
                UpdateEntity updateEntity = DmlEntityUtil.getFlagRemoveByDel(column, deleteEntity);
                this.singleTableService.flagRemove(updateEntity);
                flagRemove = true;
            }
            if (flagRemove) continue;
            this.singleTableService.remove(deleteEntity);
        }
    }

    private void removeSlaveTable(ModelTableMappingDTO model, List<WhereEntity> whereEntityList) {
        HussarException.throwBy((HussarUtils.isEmpty((Object)model) || HussarUtils.isEmpty((Object)model.getSlaveTables()) ? 1 : 0) != 0, (String)"\u83b7\u53d6\u5173\u8054\u5173\u7cfb\u5f02\u5e38");
        for (ModelTableMappingDTO joinDto : model.getSlaveTables()) {
            DeleteEntity deleteEntity = this.getDeleteByOn(joinDto.getColumnOns(), whereEntityList);
            this.singleTableService.remove(deleteEntity);
        }
    }

    private DeleteEntity getDeleteByOn(List<RelationshipOnDto> onDtoList, List<WhereEntity> masterTableWhere) {
        return DmlEntityUtil.getWhereByOn(masterTableWhere, onDtoList);
    }

    @Override
    @EngineMethod(des="\u591a\u8868\u67e5\u8be2", paramDes={"\u67e5\u8be2\u5bf9\u8c61"}, returnDes="\u591a\u8868\u8fd4\u56de\u503c")
    public PageVo selectList(SelectEntity entity) {
        HussarException.throwByNull((Object)entity, (Integer)EngineExceptionEnum.SELECT_ENTITY_EMPTY.getExceptionCode(), (String)EngineExceptionEnum.SELECT_ENTITY_EMPTY.getMessage());
        return this.singleTableService.selectList(entity);
    }

    @Override
    @EngineMethod(des="\u591a\u8868\u5206\u9875\u67e5\u8be2", paramDes={"\u5206\u9875\u5bf9\u8c61", "\u67e5\u8be2\u5bf9\u8c61"}, returnDes="\u5206\u9875vo")
    public PageVo selectPage(IPage<EngineResult> page, SelectEntity entity) {
        HussarException.throwByNull((Object)entity, (Integer)EngineExceptionEnum.SELECT_ENTITY_EMPTY.getExceptionCode(), (String)EngineExceptionEnum.SELECT_ENTITY_EMPTY.getMessage());
        entity.setMsPage(true);
        return this.singleTableService.selectPage(page, entity);
    }

    @Override
    @EngineMethod(des="\u591a\u8868\u67e5\u8be2\u5355\u6761", paramDes={"\u67e5\u8be2\u5bf9\u8c61"}, returnDes="\u591a\u8868\u8fd4\u56de\u503c")
    public EngineResult selectOne(SelectEntity entity) {
        HussarException.throwByNull((Object)entity, (Integer)EngineExceptionEnum.SELECT_ENTITY_EMPTY.getExceptionCode(), (String)EngineExceptionEnum.SELECT_ENTITY_EMPTY.getMessage());
        return this.singleTableService.selectOne(entity);
    }

    @Override
    @EngineMethod(des="\u591a\u8868\u8868\u5355\u6821\u9a8c", paramDes={"\u67e5\u8be2\u5bf9\u8c61"}, returnDes="\u591a\u8868\u8fd4\u56de\u503c")
    public ApiResponse formCheck(SelectEntity entity) {
        HussarException.throwByNull((Object)entity, (Integer)EngineExceptionEnum.SELECT_ENTITY_EMPTY.getExceptionCode(), (String)EngineExceptionEnum.SELECT_ENTITY_EMPTY.getMessage());
        return this.singleTableService.formCheck(entity);
    }

    private String getAliasByColumnId(SelectEntity entity, Long columnId) {
        if (entity == null || columnId == null) {
            return null;
        }
        List<ColumnEntity> selectColumnsList = entity.getSelectColumnsList();
        if (HussarUtils.isEmpty(selectColumnsList)) {
            return null;
        }
        Optional<ColumnEntity> columnOpt = selectColumnsList.stream().filter(x -> columnId.equals(x.getColumnId())).findFirst();
        return columnOpt.map(ColumnEntity::getColAlias).orElse(null);
    }

    @Override
    @EngineMethod(des="\u591a\u8868\u5de5\u4f5c\u6d41\u67e5\u8be2", paramDes={"\u67e5\u8be2\u5bf9\u8c61", "node\u5bf9\u8c61"}, returnDes="\u591a\u8868\u8fd4\u56de\u503c")
    public EngineResult bpmSelect(SelectEntity entity, NodeBusinessVo businessVo) {
        EngineResult engineResult = this.selectOne(entity);
        Long nodeId = businessVo.getNodeId();
        List bpmPmList = this.bpmPmService.list((Wrapper)Wrappers.lambdaQuery(BpmPm.class).eq(BpmPm::getNodeId, (Object)nodeId));
        Long slaveTableId = null;
        for (BpmPm bpmPm : bpmPmList) {
            if (!HussarUtils.equals((Object)"slaveTableId", (Object)bpmPm.getBpmPmKey())) continue;
            slaveTableId = HussarConverter.toLong((Object)bpmPm.getBpmPmValue());
        }
        if (HussarUtils.isEmpty((Object)engineResult) || HussarUtils.isEmpty(slaveTableId)) {
            return engineResult;
        }
        Map param = (Map)engineResult;
        JSONArray jsonArray = new JSONArray();
        List slaveTables = entity.getModel().getSlaveTables();
        HussarException.throwByNull((Object)slaveTables, (String)EngineExceptionEnum.RELATION_SHIP_ERROR.getMessage());
        for (ModelTableMappingDTO joinDto : slaveTables) {
            Long rightTableId = joinDto.getTableId();
            if (!HussarUtils.equals((Object)rightTableId, (Object)slaveTableId)) continue;
            String slaveBusinessIdKey = null;
            for (ColumnEntity columnEntity : entity.getSelectColumnsList()) {
                if (!rightTableId.equals(columnEntity.getTableId()) || !PurposeEnum.PRIMARY.getValue().equals(columnEntity.getPurpose())) continue;
                slaveBusinessIdKey = columnEntity.getColAlias();
            }
            if (joinDto.getRelation() == ModelRelation.ONE_N || joinDto.getRelation() == ModelRelation.N_N) {
                if (!HussarUtils.isNotEmpty(slaveBusinessIdKey)) continue;
                List resultMulti = (List)param.get(joinDto.getParamName());
                for (Map salve : resultMulti) {
                    this.addBpmVariable(jsonArray, slaveBusinessIdKey, salve);
                }
                continue;
            }
            if (!HussarUtils.isNotEmpty(slaveBusinessIdKey)) continue;
            HashMap<String, Object> slave = new HashMap<String, Object>();
            BeanUtil.copy((Object)param, slave);
            this.addBpmVariable(jsonArray, slaveBusinessIdKey, slave);
        }
        param.put("call_activity_info", jsonArray);
        return engineResult;
    }

    @Override
    @EngineMethod(des="\u591a\u8868\u5206\u9875\u67e5\u8be2\uff08\u542b\u4e00\u5bf9\u591a\uff09", paramDes={"\u5206\u9875\u5bf9\u8c61", "\u67e5\u8be2\u5bf9\u8c61"}, returnDes="\u5206\u9875vo")
    public PageVo selectPage2(IPage<EngineResult> page, SelectEntity entity) {
        PageVo pageVo = this.selectPage(page, entity);
        if (pageVo.getCount() != 0L) {
            entity.setMsPage(false);
            entity.setSqlFirst("SELECT * FROM(");
            String keyAlias = ModelResultMapUtil.getResultMappingColumn((String)entity.getModel().getTableName(), (String)entity.getKeyProperty());
            entity.setSqlComment(String.format(") t WHERE t.%s IN (%s)", keyAlias, this.getIds(pageVo.getData(), entity.getKeyProperty())));
            return new PageVo(this.selectList(entity).getData(), pageVo.getCount());
        }
        return pageVo;
    }

    private String getIds(List<?> data, String keyProperty) {
        List<?> result = data;
        List ids = result.stream().map(d -> d.get(keyProperty)).collect(Collectors.toList());
        return HussarUtils.join(ids);
    }

    @Override
    @EngineMethod(des="\u591a\u8868\u4fdd\u5b58\u6216\u4fee\u6539\uff08\u589e\u91cf\uff09", paramDes={"\u66f4\u65b0\u5bf9\u8c61\u96c6\u5408"}, returnDes="\u591a\u8868\u8fd4\u56de\u503c")
    @DSTransactional
    public ApiResponse incrementalSaveOrUpdate(UpdateEntity entity) {
        Map<String, Object> param = entity.getParam();
        HashMap<String, ModelTableMappingDTO> fixedModelCache = new HashMap<String, ModelTableMappingDTO>();
        if (HussarUtils.isNotEmpty((Object)param.get("saveAndUpdate"))) {
            Map saveOrUpdateValue = (Map)param.get("saveAndUpdate");
            for (Map.Entry entry : saveOrUpdateValue.entrySet()) {
                this.incrementalUpdate((List)entry.getValue(), this.fixedModel(fixedModelCache, entity.getModel(), (String)entry.getKey()));
            }
        }
        if (HussarUtils.isNotEmpty((Object)param.get("del"))) {
            Map delValue = (Map)param.get("del");
            for (Map.Entry entry : delValue.entrySet()) {
                this.incrementalDel((List)entry.getValue(), this.fixedModel(fixedModelCache, entity.getModel(), (String)entry.getKey()));
            }
        }
        return ApiResponse.success();
    }

    private ModelTableMappingDTO fixedModel(Map<String, ModelTableMappingDTO> fixedModelCache, ModelTableMappingDTO model, String key) {
        if (!fixedModelCache.isEmpty()) {
            return fixedModelCache.get(key);
        }
        this.getSlaveModel(fixedModelCache, model);
        return fixedModelCache.get(key);
    }

    private void getSlaveModel(Map<String, ModelTableMappingDTO> fixedModelCache, ModelTableMappingDTO model) {
        fixedModelCache.put(this.getTableNameKey(model.getTableName()), model);
        if (HussarUtils.isNotEmpty((Object)model.getSlaveTables())) {
            model.getSlaveTables().forEach(m -> this.getSlaveModel(fixedModelCache, (ModelTableMappingDTO)m));
        }
    }

    private String getTableNameKey(String tableName) {
        return INCREMENTAL_KEY + tableName;
    }

    private void incrementalUpdate(List<Map<String, Object>> value, ModelTableMappingDTO model) {
        if (model == null || HussarUtils.isEmpty(value)) {
            return;
        }
        DmlEntityUtil.DmlServiceEntity service = new DmlEntityUtil.DmlServiceEntity(model);
        for (Map<String, Object> map : value) {
            UpdateEntity updateById = service.updateById();
            this.singleTableService.saveOrUpdate((UpdateEntity)updateById.init((Map)map));
            if (HussarUtils.isEmpty((Object)model.getSlaveTables())) continue;
            for (ModelTableMappingDTO table : model.getSlaveTables()) {
                if (!this.checkTableKey(table.getTableName(), map)) continue;
                List slaveValue = (List)map.get(this.getTableNameKey(table.getTableName()));
                Object businessKey = map.get(updateById.getKeyProperty());
                String columnAlias = ((RelationshipOnDto)table.getColumnOns().get(0)).getRightColumn().getColumnAlias();
                slaveValue.forEach(s -> s.put(columnAlias, businessKey));
                this.incrementalUpdate(slaveValue, table);
            }
        }
    }

    private void incrementalDel(List<Map<String, Object>> value, ModelTableMappingDTO model) {
        if (model == null || HussarUtils.isEmpty(value)) {
            return;
        }
        DmlEntityUtil.DmlServiceEntity service = new DmlEntityUtil.DmlServiceEntity(model);
        String columnAlias = service.getPkColumn().getColumnAlias();
        List<Object> ids = value.stream().map(v -> v.get(columnAlias)).collect(Collectors.toList());
        if (HussarUtils.isNotEmpty((Object)model.getSlaveTables())) {
            for (ModelTableMappingDTO table : model.getSlaveTables()) {
                DmlEntityUtil.DmlServiceEntity slaveService = new DmlEntityUtil.DmlServiceEntity(table, ((RelationshipOnDto)table.getColumnOns().get(0)).getRightColumn());
                if (HussarUtils.isEmpty((Object)table.getSlaveTables())) {
                    if (slaveService.hasDelFlag()) {
                        this.singleTableService.flagRemove(slaveService.flagRemoveFkIds(ids));
                        continue;
                    }
                    this.singleTableService.remove(slaveService.removeByFkIds(ids));
                    continue;
                }
                SelectEntity entity = slaveService.selectByFkIds(ids);
                PageVo pageVo = this.singleTableService.selectList(entity);
                List slaveValue = pageVo.getData();
                this.incrementalDel(slaveValue, table);
            }
        }
        if (service.hasDelFlag()) {
            this.singleTableService.flagRemove(service.flagRemoveFkIds(ids));
        } else {
            this.singleTableService.remove(service.removeByIds(ids));
        }
    }

    private boolean checkTableKey(String tableName, Map<String, Object> map) {
        return HussarUtils.isNotEmpty((Object)map.get(this.getTableNameKey(tableName)));
    }

    @Override
    @EngineMethod(des="\u591a\u8868\u67e5\u8be2obj", paramDes={"\u67e5\u8be2\u5bf9\u8c61"}, returnDes="\u591a\u8868\u8fd4\u56de\u503c")
    public Object selectObj(SelectExpressionEntity entity) {
        return this.singleTableService.selectObj(entity);
    }

    private void addBpmVariable(JSONArray jsonArray, String slaveBusinessIdKey, Map<String, Object> salve) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("businessId", salve.get(slaveBusinessIdKey));
        jsonObject.put("variable", salve);
        jsonArray.add((Object)jsonObject);
    }
}

