/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.engine.plugin.dml.model;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.ColumnEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.ConstantColumnEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.EngineEntity;
import java.util.List;

public class ExpressionColumnEntity
implements EngineEntity {
    private String functionName;
    private List<EngineEntity> parameters;
    private boolean distinct;
    private String colAlias;
    private String colJavaType;

    public ExpressionColumnEntity(String functionName, List<EngineEntity> parameters, boolean distinct, String colAlias, String colJavaType) {
        this.functionName = functionName;
        this.parameters = parameters;
        this.distinct = distinct;
        this.colAlias = colAlias;
        this.colJavaType = colJavaType;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public void setFunctionName(String functionName) {
        this.functionName = functionName;
    }

    public List<EngineEntity> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<EngineEntity> parameters) {
        this.parameters = parameters;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public void setDistinct(boolean distinct) {
        this.distinct = distinct;
    }

    public String getColAlias() {
        return this.colAlias;
    }

    public void setColAlias(String colAlias) {
        this.colAlias = colAlias;
    }

    public String getColJavaType() {
        return this.colJavaType;
    }

    public void setColJavaType(String colJavaType) {
        this.colJavaType = colJavaType;
    }

    public String getColumnSql() {
        StringBuilder sql = new StringBuilder();
        sql.append(this.functionName).append("(");
        if (this.distinct) {
            sql.append("DISTINCT ");
        }
        if (HussarUtils.isNotEmpty(this.parameters)) {
            for (EngineEntity parameter : this.parameters) {
                sql.append(this.getParameterSql(parameter)).append(",").append(" ");
            }
            sql.delete(sql.length() - 2, sql.length());
        }
        sql.append(")");
        return sql.toString();
    }

    public String getSql() {
        return this.getColumnSql() + " " + this.colAlias;
    }

    private String getParameterSql(EngineEntity parameter) {
        if (parameter instanceof ColumnEntity) {
            return ((ColumnEntity)parameter).getColNameEnableEscape();
        }
        if (parameter instanceof ExpressionColumnEntity) {
            return ((ExpressionColumnEntity)parameter).getColumnSql();
        }
        return ((ConstantColumnEntity)parameter).getSql();
    }
}

