/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.engine.plugin.dml.util;

import com.jxdinfo.hussar.datasource.manager.api.model.MetadataColumnDto;
import com.jxdinfo.hussar.datasource.manager.api.service.HussarMetadataService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import com.jxdinfo.hussar.support.engine.api.model.RelationshipDto;
import com.jxdinfo.hussar.support.engine.api.model.RelationshipJoinDto;
import com.jxdinfo.hussar.support.engine.api.service.RelationshipService;
import com.jxdinfo.hussar.support.engine.core.model.EngineResultEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.ColumnEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.dml.SelectEntity;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.ibatis.mapping.ResultFlag;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.mapping.ResultMapping;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.type.JdbcType;

public class DmlResultMapUtil {
    private static final Map<String, Integer> tableShortName = new HashMap<String, Integer>();
    private static Integer integer = 0;
    private static final HussarMetadataService metadataService = (HussarMetadataService)SpringContextUtil.getBean(HussarMetadataService.class);
    private static final RelationshipService relationshipService = (RelationshipService)SpringContextUtil.getBean(RelationshipService.class);
    private static final String SINGLE_TABLE_TYPE = "table";
    private static final String MS_TABLE_TYPE = "ms";

    public static String getTableShortName(String tableName) {
        Integer number = tableShortName.computeIfAbsent(tableName, k -> {
            integer = integer + 1;
            return integer;
        });
        return (char)(number / 10 + 97) + String.valueOf(number % 10);
    }

    private DmlResultMapUtil() {
    }

    public static ResultMap addResultMap(String resultMapId, Configuration configuration, SelectEntity pm) throws ClassNotFoundException {
        HussarException.throwBy((!resultMapId.contains(".") ? 1 : 0) != 0, (String)"ResultMapId\u5f02\u5e38");
        Map<Long, String> aliasMap = pm == null ? null : pm.getSelectColumnsList().stream().collect(Collectors.toMap(ColumnEntity::getColumnId, ColumnEntity::getColAlias, (k1, k2) -> k1));
        String tableType = resultMapId.split("\\.")[0];
        Long tableId = Long.parseLong(resultMapId.split("\\.")[1]);
        ArrayList<ResultMapping> resultMappings = new ArrayList<ResultMapping>();
        if (MS_TABLE_TYPE.equals(tableType)) {
            RelationshipDto msTable = relationshipService.getRelationshipById(tableId);
            HashSet<Long> tableIds = new HashSet<Long>();
            for (RelationshipJoinDto joinDto : msTable.getJoinDtoList()) {
                Long leftTableId = joinDto.getLeftTableId();
                Long rightTableId = joinDto.getRightTableId();
                if (!tableIds.contains(leftTableId)) {
                    DmlResultMapUtil.getSingleTableResultMappings(configuration, leftTableId, aliasMap, resultMappings, false);
                    tableIds.add(leftTableId);
                }
                if (HussarUtils.isNotBlank((CharSequence)joinDto.getParamName())) {
                    String slaveId = String.format("%s.%s.%s", SINGLE_TABLE_TYPE, rightTableId, joinDto.getParamName());
                    resultMappings.add(new ResultMapping.Builder(configuration, joinDto.getParamName(), null, List.class).nestedResultMapId(slaveId).build());
                    DmlResultMapUtil.addResultMap(slaveId, configuration, pm);
                    continue;
                }
                if (tableIds.contains(rightTableId)) continue;
                DmlResultMapUtil.getSingleTableResultMappings(configuration, rightTableId, aliasMap, resultMappings, true);
                tableIds.add(rightTableId);
            }
            tableIds.clear();
        } else if (SINGLE_TABLE_TYPE.equals(tableType)) {
            DmlResultMapUtil.getSingleTableResultMappings(configuration, tableId, aliasMap, resultMappings, true);
        }
        ResultMap resultMap = new ResultMap.Builder(configuration, resultMapId, EngineResultEntity.class, resultMappings).build();
        metadataService.addResultMap(configuration, resultMap);
        return resultMap;
    }

    private static void getSingleTableResultMappings(Configuration configuration, Long tableId, Map<Long, String> aliasMap, List<ResultMapping> resultMappings, boolean isSlaveTable) throws ClassNotFoundException {
        for (MetadataColumnDto columnDto : metadataService.listColumnDtoByTableId(tableId)) {
            String columnAlias;
            String string = columnAlias = aliasMap == null ? columnDto.getColumnAlias() : aliasMap.get(columnDto.getColumnId());
            if (HussarUtils.isEmpty((Object)columnAlias)) continue;
            ArrayList<ResultFlag> flags = new ArrayList<ResultFlag>();
            if (!isSlaveTable && HussarUtils.isNotBlank((CharSequence)columnDto.getPrimarys())) {
                flags.add(ResultFlag.ID);
            }
            resultMappings.add(new ResultMapping.Builder(configuration, columnAlias, DmlResultMapUtil.getResultMappingColumn(columnDto.getTableName(), columnAlias), columnDto.javaType()).flags(flags).jdbcType(JdbcType.valueOf((String)columnDto.getJdbcType())).build());
        }
    }

    public static String getResultMappingColumn(String tableAlias, String columnAlias) {
        return String.format("%s%s", DmlResultMapUtil.getTableShortName(tableAlias.toLowerCase()), columnAlias);
    }
}

