/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.engine.plugin.dml.model.dml;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.engine.api.dto.ModelTableMappingDTO;
import com.jxdinfo.hussar.support.engine.core.enums.EngineExceptionEnum;
import com.jxdinfo.hussar.support.engine.core.enums.PurposeEnum;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.ColumnEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.EngineEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.ExpressionColumnEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.dml.DmlEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.sql.JoinEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.sql.OrderByEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.sql.WhereEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.util.DmlEntityUtil;
import com.jxdinfo.hussar.support.engine.plugin.dml.util.DmlSqlUtil;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.ibatis.jdbc.SQL;

public class SelectExpressionEntity
implements DmlEntity {
    private String resultMapId;
    private List<EngineEntity> selectColumnsList;
    private List<WhereEntity> whereEntityList;
    private List<JoinEntity> joinEntityList;
    private List<OrderByEntity> orderByEntityList;
    private ModelTableMappingDTO model;
    private String columnSql;
    private String whereSql;
    private String orderBySql;
    private Map<String, Object> param;
    private boolean msPage;

    @Override
    public SelectExpressionEntity builder() {
        this.selectColumnsList = new ArrayList<EngineEntity>();
        this.joinEntityList = new ArrayList<JoinEntity>();
        this.whereEntityList = new ArrayList<WhereEntity>();
        this.orderByEntityList = new ArrayList<OrderByEntity>();
        return this;
    }

    @Override
    public DmlEntity init(Map<String, Object> param) {
        this.param = param;
        for (EngineEntity selectColumn : this.selectColumnsList) {
            if (!this.isColumnEntity(selectColumn)) continue;
            ColumnEntity columnEntity = (ColumnEntity)selectColumn;
            if (!HussarUtils.isEmpty(this.joinEntityList) && !this.model.getTableName().equals(columnEntity.getTableName()) || !PurposeEnum.DEL_FLAG.getValue().equals(columnEntity.getPurpose())) continue;
            DmlSqlUtil.addDelFlagWhere(columnEntity, param, this.whereEntityList);
            break;
        }
        DmlSqlUtil.globalQuery(param, this.whereEntityList, this.model);
        if (HussarUtils.isNotEmpty(this.whereEntityList)) {
            for (WhereEntity whereEntity : this.whereEntityList) {
                whereEntity.initVal(param);
            }
        }
        DmlSqlUtil.globalOrder(param, this.orderByEntityList, this.model);
        this.initSql();
        return this;
    }

    private void initSql() {
        String whereSqlStr;
        this.whereSql = "";
        this.orderBySql = "";
        Object columnFields = this.param.get("columnFields");
        boolean tableAlias = HussarUtils.isNotEmpty(this.joinEntityList);
        if (HussarUtils.isNotEmpty((Object)columnFields)) {
            this.columnSql = DmlSqlUtil.totalsQuery((Map)columnFields, this.model);
            this.resultMapId = "engine_map";
        } else {
            this.columnSql = this.selectColumnsList.stream().map(c -> this.isColumnEntity((EngineEntity)c) ? ((ColumnEntity)c).getColumnSql(tableAlias) : ((ExpressionColumnEntity)c).getSql()).collect(Collectors.joining(","));
        }
        if (HussarUtils.isNotEmpty(this.whereEntityList) && HussarUtils.isNotEmpty((Object)(whereSqlStr = DmlSqlUtil.getWhereSql(DmlEntityUtil.getWhereTree(this.whereEntityList), tableAlias)))) {
            this.whereSql = whereSqlStr;
        }
        if (HussarUtils.isNotEmpty(this.orderByEntityList)) {
            this.orderBySql = this.orderByEntityList.stream().map(e -> e.getOrderSql(tableAlias)).collect(Collectors.joining(","));
        }
    }

    private String getColumnSql() {
        return this.columnSql;
    }

    private boolean isColumnEntity(EngineEntity c) {
        return c instanceof ColumnEntity;
    }

    private ColumnEntity entity() {
        this.isNotEmptySelect();
        EngineEntity entity = this.selectColumnsList.get(0);
        if (this.isColumnEntity(entity)) {
            return (ColumnEntity)entity;
        }
        return DmlSqlUtil.getColumnEntityByExpression((ExpressionColumnEntity)entity);
    }

    private void isNotEmptySelect() {
        HussarException.throwBy((boolean)HussarUtils.isEmpty(this.selectColumnsList), (Integer)EngineExceptionEnum.SELECT_COLUMNS_FAIL.getExceptionCode(), (String)EngineExceptionEnum.SELECT_COLUMNS_FAIL.getMessage());
    }

    public String getTableName() {
        if (HussarUtils.isNotEmpty(this.joinEntityList)) {
            JoinEntity firstJoinEntity = this.joinEntityList.get(0);
            if (this.joinEntityList.size() == 1) {
                return firstJoinEntity.getFirstJoinSql(this.msPage);
            }
            return firstJoinEntity.getLeftTable().getTableNameAndAlias() + this.joinEntityList.stream().map(j -> j.getJoinSql(this.msPage)).collect(Collectors.joining("\n"));
        }
        return this.entity().getTableEntity().getTableNameAndAlias();
    }

    public String getSqlFirst() {
        return "";
    }

    public void setJoinEntityList(List<JoinEntity> joinEntityList) {
        this.joinEntityList = joinEntityList;
    }

    public String getSqlComment() {
        return "";
    }

    public String getKeyProperty() {
        return this.entity().getKeyProperty();
    }

    public String getResultMapId() {
        return this.resultMapId;
    }

    public void setResultMapId(String resultMapId) {
        this.resultMapId = resultMapId;
    }

    public Map<String, Object> getParam() {
        return this.param;
    }

    @Override
    public String getSql() {
        SQL sql = (SQL)((SQL)new SQL().SELECT(this.getColumnSql())).FROM(this.getTableName());
        if (HussarUtils.isNotEmpty((Object)this.whereSql)) {
            sql.WHERE(this.whereSql);
        }
        if (HussarUtils.isNotEmpty((Object)this.orderBySql)) {
            sql.ORDER_BY(this.orderBySql);
        }
        return this.getSqlFirst() + sql.toString() + this.getSqlComment();
    }

    @Override
    public String getPoolName() {
        return this.entity().getPoolName();
    }

    public List<EngineEntity> getSelectColumnsList() {
        return this.selectColumnsList;
    }

    public void setSelectColumnsList(List<EngineEntity> selectColumnsList) {
        this.selectColumnsList = selectColumnsList;
    }

    public List<WhereEntity> getWhereEntityList() {
        return this.whereEntityList;
    }

    public void setWhereEntityList(List<WhereEntity> whereEntityList) {
        this.whereEntityList = whereEntityList;
    }

    public List<OrderByEntity> getOrderByEntityList() {
        return this.orderByEntityList;
    }

    public void setOrderByEntityList(List<OrderByEntity> orderByEntityList) {
        this.orderByEntityList = orderByEntityList;
    }

    public ModelTableMappingDTO getModel() {
        return this.model;
    }

    public void setModel(ModelTableMappingDTO model) {
        this.model = model;
    }

    public void setMsPage(boolean msPage) {
        this.msPage = msPage && HussarUtils.isNotEmpty(this.joinEntityList);
    }
}

