/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.engine.plugin.dml.util;

import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.platform.core.utils.date.DateUtil;
import com.jxdinfo.hussar.platform.core.utils.date.format.DatePattern;
import com.jxdinfo.hussar.platform.core.utils.regex.RegexUtil;
import com.jxdinfo.hussar.support.engine.api.enums.DateEnum;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class EngineDateUtil {
    public static String getDatePattern(String dateStr) {
        if (RegexUtil.isMatch((Pattern)DatePattern.REGEX_NORM, (CharSequence)dateStr)) {
            int colonCount = StringUtil.count((CharSequence)dateStr, (char)':');
            switch (colonCount) {
                case 0: {
                    return "yyyy-MM-dd";
                }
                case 1: {
                    return "yyyy-MM-dd HH:mm";
                }
                case 2: {
                    return "yyyy-MM-dd HH:mm:ss";
                }
            }
        }
        return null;
    }

    public static List<LocalDateTime> getStartEnd(String dateStr) {
        ArrayList<LocalDateTime> results = new ArrayList<LocalDateTime>();
        if (RegexUtil.isMatch((Pattern)DatePattern.REGEX_NORM, (CharSequence)dateStr)) {
            int colonCount = StringUtil.count((CharSequence)dateStr, (char)':');
            switch (colonCount) {
                case 0: {
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                    try {
                        Date date = sdf.parse(dateStr);
                        results.add(EngineDateUtil.formatDate((Date)DateUtil.beginOfDay((Date)date), true));
                        results.add(EngineDateUtil.formatDate((Date)DateUtil.endOfDay((Date)date), true));
                    }
                    catch (ParseException e) {
                        return null;
                    }
                    return results;
                }
                case 1: {
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
                    try {
                        Date date = sdf.parse(dateStr);
                        results.add(EngineDateUtil.formatDate((Date)DateUtil.beginOfMinute((Date)date), true));
                        results.add(EngineDateUtil.formatDate((Date)DateUtil.endOfMinute((Date)date), true));
                    }
                    catch (ParseException e) {
                        return null;
                    }
                    return results;
                }
            }
            return null;
        }
        return null;
    }

    public static Map<String, LocalDateTime> timeBetween(DateEnum type, boolean isDateTime) {
        LocalDateTime start = null;
        LocalDateTime end = null;
        switch (type) {
            case TODAY: {
                start = EngineDateUtil.formatDate((Date)DateUtil.beginOfDay((Date)new Date()), isDateTime);
                end = EngineDateUtil.formatDate((Date)DateUtil.endOfDay((Date)new Date()), isDateTime);
                break;
            }
            case YESTERDAY: {
                start = EngineDateUtil.formatDate((Date)DateUtil.beginOfDay((Date)DateUtil.yesterday()), isDateTime);
                end = EngineDateUtil.formatDate((Date)DateUtil.endOfDay((Date)DateUtil.yesterday()), isDateTime);
                break;
            }
            case TOMORROW: {
                start = EngineDateUtil.formatDate((Date)DateUtil.beginOfDay((Date)DateUtil.tomorrow()), isDateTime);
                end = EngineDateUtil.formatDate((Date)DateUtil.endOfDay((Date)DateUtil.tomorrow()), isDateTime);
                break;
            }
            case THIS_WEEK: {
                start = EngineDateUtil.formatDate((Date)DateUtil.beginOfWeek((Date)new Date(), (boolean)true), isDateTime);
                end = EngineDateUtil.formatDate((Date)DateUtil.endOfWeek((Date)new Date(), (boolean)true), isDateTime);
                break;
            }
            case LAST_WEEK: {
                start = EngineDateUtil.formatDate((Date)DateUtil.beginOfWeek((Date)DateUtil.lastWeek(), (boolean)true), isDateTime);
                end = EngineDateUtil.formatDate((Date)DateUtil.endOfWeek((Date)DateUtil.lastWeek(), (boolean)true), isDateTime);
                break;
            }
            case NEXT_WEEK: {
                start = EngineDateUtil.formatDate((Date)DateUtil.beginOfWeek((Date)DateUtil.nextWeek(), (boolean)true), isDateTime);
                end = EngineDateUtil.formatDate((Date)DateUtil.endOfWeek((Date)DateUtil.nextWeek(), (boolean)true), isDateTime);
                break;
            }
            case THIS_MONTH: {
                start = EngineDateUtil.formatDate((Date)DateUtil.beginOfMonth((Date)new Date()), isDateTime);
                end = EngineDateUtil.formatDate((Date)DateUtil.endOfMonth((Date)new Date()), isDateTime);
                break;
            }
            case LAST_MONTH: {
                start = EngineDateUtil.formatDate((Date)DateUtil.beginOfMonth((Date)DateUtil.lastMonth()), isDateTime);
                end = EngineDateUtil.formatDate((Date)DateUtil.endOfMonth((Date)DateUtil.lastMonth()), isDateTime);
                break;
            }
            case NEXT_MONTH: {
                start = EngineDateUtil.formatDate((Date)DateUtil.beginOfMonth((Date)DateUtil.nextMonth()), isDateTime);
                end = EngineDateUtil.formatDate((Date)DateUtil.endOfMonth((Date)DateUtil.nextMonth()), isDateTime);
                break;
            }
            case THIS_QUARTER: {
                start = EngineDateUtil.formatDate((Date)DateUtil.beginOfQuarter((Date)new Date()), isDateTime);
                end = EngineDateUtil.formatDate((Date)DateUtil.endOfQuarter((Date)new Date()), isDateTime);
                break;
            }
            case LAST_QUARTER: {
                start = EngineDateUtil.formatDate((Date)DateUtil.beginOfQuarter((Date)EngineDateUtil.getLastQuarter(new Date())), isDateTime);
                end = EngineDateUtil.formatDate((Date)DateUtil.endOfQuarter((Date)EngineDateUtil.getLastQuarter(new Date())), isDateTime);
                break;
            }
            case NEXT_QUARTER: {
                start = EngineDateUtil.formatDate((Date)DateUtil.beginOfQuarter((Date)EngineDateUtil.getNextQuarter(new Date())), isDateTime);
                end = EngineDateUtil.formatDate((Date)DateUtil.endOfQuarter((Date)EngineDateUtil.getNextQuarter(new Date())), isDateTime);
                break;
            }
            case THIS_YEAR: {
                start = EngineDateUtil.formatDate((Date)DateUtil.beginOfYear((Date)new Date()), isDateTime);
                end = EngineDateUtil.formatDate((Date)DateUtil.endOfYear((Date)new Date()), isDateTime);
                break;
            }
            case LAST_YEAR: {
                start = EngineDateUtil.formatDate((Date)DateUtil.beginOfYear((Date)EngineDateUtil.getLastYear()), isDateTime);
                end = EngineDateUtil.formatDate((Date)DateUtil.endOfYear((Date)EngineDateUtil.getLastYear()), isDateTime);
                break;
            }
            case NEXT_YEAR: {
                start = EngineDateUtil.formatDate((Date)DateUtil.beginOfYear((Date)EngineDateUtil.getNextYear()), isDateTime);
                end = EngineDateUtil.formatDate((Date)DateUtil.endOfYear((Date)EngineDateUtil.getNextYear()), isDateTime);
                break;
            }
        }
        if (start == null || end == null) {
            return null;
        }
        HashMap<String, LocalDateTime> map = new HashMap<String, LocalDateTime>();
        map.put("v0", start);
        map.put("v1", end);
        return map;
    }

    private static LocalDateTime formatDate(Date date, boolean isDateTime) {
        Instant instant = date.toInstant();
        return LocalDateTime.ofInstant(instant, ZoneId.systemDefault());
    }

    public static Date getLastQuarter(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(2, -3);
        return calendar.getTime();
    }

    public static Date getNextQuarter(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(2, 3);
        return calendar.getTime();
    }

    public static Date getNextYear() {
        Calendar ca = Calendar.getInstance();
        ca.setTime(new Date());
        ca.add(1, 1);
        return ca.getTime();
    }

    public static Date getLastYear() {
        Calendar ca = Calendar.getInstance();
        ca.setTime(new Date());
        ca.add(1, -1);
        return ca.getTime();
    }
}

