/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.engine.plugin.dml.support.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.extension.toolkit.SqlHelper;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.engine.api.service.UnderlyingService;
import com.jxdinfo.hussar.support.engine.core.annotations.EngineMethod;
import com.jxdinfo.hussar.support.engine.core.annotations.EngineService;
import com.jxdinfo.hussar.support.engine.core.enums.DataServiceType;
import com.jxdinfo.hussar.support.engine.core.enums.PurposeEnum;
import com.jxdinfo.hussar.support.engine.core.model.EngineResult;
import com.jxdinfo.hussar.support.engine.core.vo.PageVo;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.dml.DeleteEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.dml.InsertEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.dml.SelectCustomEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.dml.SelectEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.dml.SelectExpressionEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.dml.UpdateEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.sql.SetEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.sql.ValueEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.support.service.DmlService;
import com.jxdinfo.hussar.support.engine.plugin.dml.support.service.SingleTableService;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;

@EngineService(value="com.jxdinfo.hussar.support.engine.plugin.dml.service.impl.engineSingleTable", type=DataServiceType.PERMANENT, des="\u5355\u8868\u56fa\u5316service")
public class SingleTableServiceImpl
implements SingleTableService,
UnderlyingService {
    private static final String INSERT_AND_UPDATE = "insertAndUpdate";
    private static final String EDT_DEL = "del";
    @Autowired
    private DmlService dmlService;

    @Override
    @EngineMethod(des="\u5355\u8868\u65b0\u589e", paramDes={"\u65b0\u589e\u5bf9\u8c61"}, returnDes="\u5355\u8868\u8fd4\u56de\u503c")
    public Object save(InsertEntity entity) {
        try {
            this.dmlService.insert(entity, entity.getPoolName());
            return entity.getParam().get(entity.getKeyProperty());
        }
        catch (Exception e) {
            throw new HussarException("\u4fdd\u5b58\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    @EngineMethod(des="\u5355\u8868\u66f4\u65b0", paramDes={"\u66f4\u65b0\u5bf9\u8c61"}, returnDes="\u5355\u8868\u8fd4\u56de\u503c")
    public Object update(UpdateEntity entity) {
        try {
            this.dmlService.update(entity, entity.getPoolName());
            return entity.getParam().get(entity.getKeyProperty());
        }
        catch (Exception e) {
            throw new HussarException("\u4fdd\u5b58\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    @EngineMethod(des="\u5355\u8868\u65b0\u589e\u6216\u4fee\u6539", paramDes={"\u66f4\u65b0\u5bf9\u8c61"}, returnDes="\u5355\u8868\u8fd4\u56de\u503c")
    public Object saveOrUpdate(UpdateEntity entity) {
        try {
            String keyProperty = entity.getKeyProperty();
            Object id = entity.getParam().get(keyProperty);
            if (HussarUtils.isNotEmpty((Object)id) && SqlHelper.retBool((Integer)this.dmlService.update(entity, entity.getPoolName()))) {
                return id;
            }
            InsertEntity insert = this.getInsertByUpdate(entity);
            this.dmlService.insert((InsertEntity)insert.init((Map)entity.getParam()), entity.getPoolName());
            return insert.getParam().get(keyProperty);
        }
        catch (Exception e) {
            throw new HussarException("\u4fdd\u5b58\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    @EngineMethod(des="\u5355\u8868\u6279\u91cf\u65b0\u589e\u6216\u4fee\u6539", paramDes={"\u66f4\u65b0\u5bf9\u8c61\u96c6\u5408"}, returnDes="\u5355\u8868\u8fd4\u56de\u503c")
    public boolean saveOrUpdateBatch(List<UpdateEntity> entityList) {
        try {
            if (HussarUtils.isEmpty(entityList)) {
                return true;
            }
            ArrayList<Boolean> existList = new ArrayList<Boolean>(entityList.size());
            InsertEntity insert = this.getDataTest(entityList, existList, entityList.get(0));
            return this.executeBatch(entityList, insert, existList);
        }
        catch (Exception e) {
            throw new HussarException("\u4fdd\u5b58\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    @EngineMethod(des="\u5355\u8868\u53ef\u7f16\u8f91\u8868\u683c\u6279\u91cf\u65b0\u589e\u6216\u4fee\u6539", paramDes={"\u66f4\u65b0\u5bf9\u8c61\u96c6\u5408"}, returnDes="\u5355\u8868\u8fd4\u56de\u503c")
    public boolean editSaveOrUpdateBatch(Map<String, Object> dmlEntityMap) {
        try {
            if (HussarUtils.isNotEmpty(dmlEntityMap)) {
                List delList;
                List list = (List)dmlEntityMap.get(INSERT_AND_UPDATE);
                if (HussarUtils.isNotEmpty((Object)list)) {
                    this.saveOrUpdateBatch(list);
                }
                if (HussarUtils.isNotEmpty((Object)(delList = (List)dmlEntityMap.get(EDT_DEL)))) {
                    for (DeleteEntity dmlEntity : delList) {
                        this.remove(dmlEntity);
                    }
                }
            }
            return true;
        }
        catch (Exception e) {
            throw new HussarException("\u4fdd\u5b58\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    @EngineMethod(des="\u5355\u8868\u6279\u91cf\u4fdd\u5b58\uff08\u62a5\u9519\u7ee7\u7eed\u6267\u884c\uff09", paramDes={"\u65b0\u589e\u5bf9\u8c61\u96c6\u5408"}, returnDes="\u6210\u529f\u5e8f\u5217\u53f7")
    public List<Integer> saveBatchMore(List<InsertEntity> entity) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        if (HussarUtils.isEmpty(entity)) {
            return result;
        }
        for (int i = 0; i < entity.size(); ++i) {
            try {
                InsertEntity insertEntity = entity.get(i);
                this.dmlService.insert(insertEntity, insertEntity.getPoolName());
                result.add(i);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    private InsertEntity getDataTest(List<UpdateEntity> entityList, List<Boolean> existList, UpdateEntity updateEntity) {
        InsertEntity insert = this.getInsertByUpdate(updateEntity);
        String keyProperty = updateEntity.getKeyProperty();
        SelectEntity select = this.getSelectByUpdate(updateEntity);
        for (UpdateEntity entity : entityList) {
            boolean exist = false;
            Map<String, Object> param = entity.getParam();
            if (HussarUtils.isNotEmpty((Object)keyProperty) && HussarUtils.isNotEmpty((Object)param.get(keyProperty))) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put(keyProperty, param.get(keyProperty));
                exist = CollectionUtils.isNotEmpty((Collection)this.selectList((SelectEntity)select.init(map)).getData());
            }
            existList.add(exist);
        }
        return insert;
    }

    private boolean executeBatch(List<UpdateEntity> entityList, InsertEntity insert, List<Boolean> existList) {
        return this.dmlService.saveOrUpdateBatch(entityList, insert, existList, insert.getPoolName());
    }

    private InsertEntity getInsertByUpdate(UpdateEntity entity) {
        InsertEntity insertEntity = new InsertEntity();
        insertEntity.setValueEntityList(BeanUtil.copy(entity.getSetEntityList(), ValueEntity.class));
        return insertEntity;
    }

    private SelectEntity getSelectByUpdate(UpdateEntity entity) {
        SelectEntity selectEntity = new SelectEntity();
        selectEntity.setSelectColumnsList(entity.getSetEntityList().stream().map(ValueEntity::getColumnEntity).collect(Collectors.toList()));
        selectEntity.setWhereEntityList(entity.getWhereEntityList());
        return selectEntity;
    }

    @Override
    @EngineMethod(des="\u5355\u8868\u5220\u9664", paramDes={"\u5220\u9664\u5bf9\u8c61"}, returnDes="\u5355\u8868\u8fd4\u56de\u503c")
    public boolean remove(DeleteEntity entity) {
        try {
            return SqlHelper.retBool((Integer)this.dmlService.delete(entity, entity.getPoolName()));
        }
        catch (Exception e) {
            throw new HussarException("\u5220\u9664\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    @EngineMethod(des="\u5355\u8868\u903b\u8f91\u5220\u9664", paramDes={"\u5220\u9664\u5bf9\u8c61"}, returnDes="\u5355\u8868\u8fd4\u56de\u503c")
    public boolean flagRemove(UpdateEntity entity) {
        try {
            if (HussarUtils.isEmpty(entity.getSetEntityList())) {
                DeleteEntity deleteEntity = new DeleteEntity().builder();
                deleteEntity.setWhereEntityList(entity.getWhereEntityList());
                deleteEntity.init((Map)entity.getParam());
                return this.remove(deleteEntity);
            }
            for (SetEntity setEntity : entity.getSetEntityList()) {
                if (!PurposeEnum.DEL_FLAG.getValue().equals(setEntity.getColumnEntity().getPurpose())) continue;
                setEntity.setVal("1");
                entity.getParam().put(setEntity.getParamColumnAlias(), setEntity.getVal());
            }
            return SqlHelper.retBool((Integer)this.dmlService.update(entity, entity.getPoolName()));
        }
        catch (Exception e) {
            throw new HussarException("\u5220\u9664\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    @EngineMethod(des="\u5355\u8868\u67e5\u8be2\u96c6\u5408", paramDes={"\u67e5\u8be2\u5bf9\u8c61"}, returnDes="\u5355\u8868\u8fd4\u56de\u503c")
    public PageVo selectList(SelectEntity entity) {
        try {
            List<EngineResult> list = this.dmlService.selectList(entity, entity.getPoolName());
            return new PageVo(list, Long.valueOf(HussarUtils.toLong((Object)list.size())));
        }
        catch (Exception e) {
            throw new HussarException("\u67e5\u8be2\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    @EngineMethod(des="\u5355\u8868\u67e5\u8be2\u5206\u9875", paramDes={"\u5206\u9875\u5bf9\u8c61", "\u67e5\u8be2\u5bf9\u8c61"}, returnDes="\u5355\u8868\u8fd4\u56de\u503c")
    public PageVo selectPage(IPage<EngineResult> page, SelectEntity entity) {
        try {
            this.dmlService.selectPage(page, entity, entity.getPoolName());
            return new PageVo(page.getRecords(), Long.valueOf(page.getTotal()));
        }
        catch (Exception e) {
            throw new HussarException("\u67e5\u8be2\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    @EngineMethod(des="\u81ea\u5b9a\u4e49sql\u67e5\u8be2", paramDes={"\u67e5\u8be2\u5bf9\u8c61"}, returnDes="\u5355\u8868\u8fd4\u56de\u503c")
    public PageVo selectCustom(SelectCustomEntity entity) {
        try {
            List<EngineResult> list = this.dmlService.selectCustom(entity, entity.getPoolName());
            return new PageVo(list, Long.valueOf(HussarUtils.toLong((Object)list.size())));
        }
        catch (Exception e) {
            throw new HussarException("\u67e5\u8be2\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    @EngineMethod(des="\u81ea\u5b9a\u4e49sql\u67e5\u8be2\u5206\u9875", paramDes={"\u67e5\u8be2\u5bf9\u8c61"}, returnDes="\u5355\u8868\u8fd4\u56de\u503c")
    public PageVo selectCustomPage(IPage<EngineResult> page, SelectCustomEntity entity) {
        try {
            this.dmlService.selectCustomPage(page, entity, entity.getPoolName());
            return new PageVo(page.getRecords(), Long.valueOf(page.getTotal()));
        }
        catch (Exception e) {
            throw new HussarException("\u67e5\u8be2\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    @EngineMethod(des="\u5355\u8868\u67e5\u8be2one", paramDes={"\u67e5\u8be2\u5bf9\u8c61"}, returnDes="\u5355\u8868\u8fd4\u56de\u503c")
    public EngineResult selectOne(SelectEntity entity) {
        try {
            return this.dmlService.selectOne(entity, entity.getPoolName());
        }
        catch (Exception e) {
            throw new HussarException("\u67e5\u8be2\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    @EngineMethod(des="\u5355\u8868\u67e5\u8be2obj", paramDes={"\u67e5\u8be2\u5bf9\u8c61"}, returnDes="\u5355\u8868\u8fd4\u56de\u503c")
    public Object selectObj(SelectExpressionEntity entity) {
        try {
            entity.setMsPage(true);
            Object result = this.dmlService.selectObj(entity, entity.getPoolName());
            return new PageVo(result);
        }
        catch (Exception e) {
            throw new HussarException("\u67e5\u8be2\u5931\u8d25", (Throwable)e);
        }
    }
}

