/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.engine.plugin.dml.support.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.ExceptionUtils;
import com.baomidou.mybatisplus.extension.toolkit.SqlHelper;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.support.engine.api.model.NodeBusiness;
import com.jxdinfo.hussar.support.engine.core.model.EngineResult;
import com.jxdinfo.hussar.support.engine.core.model.EngineResultEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.dao.DmlMapper;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.dml.DeleteEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.dml.InsertEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.dml.SelectCustomEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.dml.SelectEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.dml.SelectExpressionEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.dml.UpdateEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.support.service.DmlService;
import com.jxdinfo.hussar.support.engine.plugin.dml.util.DmlSqlParseUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;
import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.stereotype.Service;

@Service
public class DmlServiceImpl
implements DmlService {
    private Log log = LogFactory.getLog(DmlServiceImpl.class);
    @Resource
    SqlSessionFactory sqlSessionFactory;
    @Resource
    DmlMapper dmlMapper;

    @Override
    @HussarDs(value="#connName")
    public boolean insert(InsertEntity entity, String connName) {
        return this.dmlMapper.insert(entity);
    }

    @Override
    @HussarDs(value="#connName")
    public int delete(DeleteEntity entity, String connName) {
        return this.dmlMapper.delete(entity);
    }

    @Override
    @HussarDs(value="#connName")
    public int update(UpdateEntity entity, String connName) {
        return this.dmlMapper.update(entity);
    }

    @Override
    @HussarDs(value="#connName")
    public EngineResult selectOne(SelectEntity entity, String connName) {
        List<EngineResult> ts = this.dmlMapper.selectList(entity);
        if (CollectionUtils.isNotEmpty(ts)) {
            if (ts.size() != 1) {
                throw ExceptionUtils.mpe((String)"One record is expected, but the query result is multiple records", (Object[])new Object[0]);
            }
            return ts.get(0);
        }
        return new EngineResultEntity();
    }

    @Override
    @HussarDs(value="#connName")
    public List<EngineResult> selectList(SelectEntity entity, String connName) {
        return this.dmlMapper.selectList(entity);
    }

    @Override
    @HussarDs(value="#connName")
    public List<EngineResult> selectCustom(SelectCustomEntity entity, String connName) {
        return this.dmlMapper.selectCustom(entity, this.parseParams(entity, entity.getParam()));
    }

    @Override
    @HussarDs(value="#connName")
    public IPage<EngineResult> selectCustomPage(IPage<EngineResult> page, SelectCustomEntity entity, String connName) {
        return this.dmlMapper.selectCustomPage(page, entity, this.parseParams(entity, entity.getParam()));
    }

    @Override
    @HussarDs(value="#connName")
    public Object selectObj(SelectExpressionEntity entity, String connName) {
        return this.dmlMapper.selectObj(entity);
    }

    @Override
    @HussarDs(value="#connName")
    public List<Object> selectObjs(SelectEntity entity, String connName) {
        return this.dmlMapper.selectObjs(entity);
    }

    @Override
    @HussarDs(value="#connName")
    public IPage<EngineResult> selectPage(IPage<EngineResult> page, SelectEntity entity, String connName) {
        return this.dmlMapper.selectPage(page, entity);
    }

    @Override
    @HussarDs(value="#connName")
    public boolean saveOrUpdateBatch(List<UpdateEntity> entityList, InsertEntity insert, List<Boolean> existList, String connName) {
        return SqlHelper.executeBatch(NodeBusiness.class, (Log)this.log, entityList, (int)1000, (sqlSession, et) -> {
            if (Boolean.FALSE.equals(existList.remove(0))) {
                insert.init((Map)et.getParam());
                sqlSession.insert(this.getSqlStatement("insert"), this.getStatementParams(insert));
            } else {
                sqlSession.update(this.getSqlStatement("update"), this.getStatementParams(et));
            }
        });
    }

    private String getSqlStatement(String methodName) {
        return DmlMapper.class.getName() + "." + methodName;
    }

    private Object getStatementParams(Object entity) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("et", entity);
        return params;
    }

    private Map<String, Object> parseParams(SelectCustomEntity entity, Map<String, Object> params) {
        Map customSqlParams = (Map)params.get("customSqlParams");
        if (HussarUtils.isEmpty(params)) {
            params = new HashMap<String, Object>();
        } else if (HussarUtils.isNotEmpty((Object)customSqlParams)) {
            params.putAll(customSqlParams);
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("params", customSqlParams);
        Map<String, Object> result = DmlSqlParseUtil.parseSql(entity.getCustomSql(), param, this.sqlSessionFactory.getConfiguration());
        params.putAll((Map)result.get("param"));
        entity.setCustomSql(result.get("sql").toString());
        return params;
    }
}

