/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.engine.plugin.dml.model.sql;

import com.baomidou.mybatisplus.core.enums.SqlLike;
import com.baomidou.mybatisplus.core.toolkit.sql.SqlUtils;
import com.jxdinfo.hussar.platform.core.utils.convert.HussarConverter;
import com.jxdinfo.hussar.support.engine.api.enums.OperatorType;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.sql.ValueEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.util.DmlSqlUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SetEntity
extends ValueEntity {
    private OperatorType operatorType;
    private String setSql;

    public void setOperatorType(OperatorType operatorType) {
        this.setEnableCollection(operatorType != null && operatorType.isEnableCollection());
        this.operatorType = operatorType;
    }

    public OperatorType getOperatorType() {
        return this.operatorType;
    }

    @Override
    public void processingParam() {
        this.operatorSql();
    }

    private void operatorSql() {
        String sql;
        if (this.operatorType == null) {
            return;
        }
        Object val = this.getVal();
        switch (this.operatorType) {
            case IN: 
            case NOT_IN: {
                if (this.isNoll()) {
                    return;
                }
                Map<String, Object> map = this.getEnableCollectionValue(val);
                StringBuilder valueSql = new StringBuilder();
                valueSql.append("(");
                int i = 0;
                for (String colAlias : map.keySet()) {
                    if (i != 0) {
                        valueSql.append(",");
                    }
                    valueSql.append("#{").append(this.getValueAlias()).append(".").append(colAlias).append("}");
                    ++i;
                }
                valueSql.append(")");
                sql = valueSql.toString();
                break;
            }
            case LIKE: 
            case NOT_LIKE: 
            case LEFT_LIKE: 
            case RIGHT_LIKE: 
            case NOT_RIGHT_LIKE: 
            case NOT_LEFT_LIKE: {
                if (this.isNoll()) {
                    return;
                }
                this.getColumnEntity().setColJavaType(String.class.getName());
                this.setVal(DmlSqlUtil.concatLike(this.getVal(), this.operatorType));
                this.setParamColumnAlias(this.getParamColumnAlias() + this.operatorType.getValue());
                sql = this.sql();
                break;
            }
            case MULTI_LIKE: {
                if (this.isNoll()) {
                    return;
                }
                Map<String, Object> map = this.getEnableCollectionValue(val);
                for (Map.Entry<String, Object> entry : map.entrySet()) {
                    entry.setValue(SqlUtils.concatLike((Object)("," + entry.getValue() + ","), (SqlLike)SqlLike.DEFAULT));
                }
                StringBuilder valueSql = new StringBuilder();
                valueSql.append("(");
                String colName = String.format("CONCAT(',', CONCAT(%s, ','))", this.getColumnEntity().getTableAliasAndColName());
                int i = 0;
                for (String colAlias : map.keySet()) {
                    if (i != 0) {
                        valueSql.append(" OR ");
                    }
                    valueSql.append(" ").append(colName).append(" ").append(this.operatorType.getKeyword().getSqlSegment()).append(" ");
                    valueSql.append("#{").append(this.getValueAlias()).append(".").append(colAlias).append("}");
                    ++i;
                }
                valueSql.append(")");
                this.setSql = valueSql.toString();
                return;
            }
            case NOT_BETWEEN: 
            case BETWEEN: 
            case DATE_ENUM: {
                if (this.isNoll()) {
                    return;
                }
                sql = this.getBetweenSql();
                break;
            }
            case IS_NOT_NULL: 
            case IS_NULL: {
                sql = "";
                break;
            }
            default: {
                sql = this.sql();
            }
        }
        this.setSql = String.format(" %s %s %s ", this.getColumnEntity().getColNameEnableEscape(), this.operatorType.getKeyword().getSqlSegment(), sql);
    }

    private String getBetweenSql() {
        this.getEnableCollectionValue(this.getVal());
        StringBuilder valueSql = new StringBuilder();
        valueSql.append("#{").append(this.getValueAlias()).append(".").append("v0").append("}");
        valueSql.append(" AND ");
        valueSql.append("#{").append(this.getValueAlias()).append(".").append("v1").append("}");
        return valueSql.toString();
    }

    private Map<String, Object> getEnableCollectionValue(Object val) {
        HashMap map;
        if (val instanceof Map) {
            map = (HashMap)val;
        } else {
            Class<?> name = DmlSqlUtil.getColumnClass(this.getColumnEntity());
            map = new HashMap();
            List inValues = (List)val;
            for (int i = 0; i < inValues.size(); ++i) {
                String colAlias = "v" + i;
                map.put(colAlias, name != null && name != inValues.get(i).getClass() ? HussarConverter.convert(name, inValues.get(i)) : inValues.get(i));
            }
            this.setParamColumnAlias(this.getParamColumnAlias() + this.operatorType.getValue());
            this.setVal(map);
        }
        return map;
    }

    public String getSetSql() {
        return this.setSql;
    }
}

