/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.engine.plugin.dml.mss.support.service.impl;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.dynamic.datasource.toolkit.DynamicDataSourceContextHolder;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.jxdinfo.hussar.datasource.manager.api.model.MetadataColumnDto;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.engine.api.dto.ModelTableMappingDTO;
import com.jxdinfo.hussar.support.engine.api.dto.NodeBusinessVo;
import com.jxdinfo.hussar.support.engine.api.model.RelationshipOnDto;
import com.jxdinfo.hussar.support.engine.api.service.UnderlyingService;
import com.jxdinfo.hussar.support.engine.core.annotations.EngineMethod;
import com.jxdinfo.hussar.support.engine.core.annotations.EngineService;
import com.jxdinfo.hussar.support.engine.core.enums.DataServiceType;
import com.jxdinfo.hussar.support.engine.core.enums.EngineExceptionEnum;
import com.jxdinfo.hussar.support.engine.core.model.EngineResult;
import com.jxdinfo.hussar.support.engine.core.vo.PageVo;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.dml.DeleteEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.dml.DmlEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.dml.InsertEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.dml.SelectEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.dml.UpdateEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.sql.WhereEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.mss.support.constants.MssConstants;
import com.jxdinfo.hussar.support.engine.plugin.dml.mss.support.dto.ForeignValidator;
import com.jxdinfo.hussar.support.engine.plugin.dml.mss.support.service.MultiMsTableService;
import com.jxdinfo.hussar.support.engine.plugin.dml.support.service.MsTableService;
import com.jxdinfo.hussar.support.engine.plugin.dml.support.service.SingleTableService;
import com.jxdinfo.hussar.support.engine.plugin.dml.util.DmlEntityUtil;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EngineService(value="com.jxdinfo.hussar.support.engine.plugin.mss.service.impl.engineMssTable", type=DataServiceType.PERMANENT, des="\u4e3b\u5b50\u5b50\u56fa\u5316service")
public class MultiMsTableServiceImpl
implements MultiMsTableService,
UnderlyingService,
MssConstants {
    private static final Logger LOG = LoggerFactory.getLogger(MultiMsTableServiceImpl.class);
    private final SingleTableService singleTableService;
    private final MsTableService msTableService;

    public MultiMsTableServiceImpl(SingleTableService singleTableService, MsTableService msTableService) {
        this.singleTableService = singleTableService;
        this.msTableService = msTableService;
    }

    @Override
    @EngineMethod(des="\u5168\u91cf-\u591a\u8868\u6279\u91cf\u4fdd\u5b58\u6216\u4fee\u6539", paramDes={"\u66f4\u65b0\u5bf9\u8c61\u96c6\u5408"}, returnDes="\u591a\u8868\u8fd4\u56de\u503c")
    public Object msSaveBatch(List<DmlEntity> insertEntities) {
        return this.saveOrUpdate(insertEntities);
    }

    @Override
    @EngineMethod(des="\u5168\u91cf-\u591a\u8868\u4fdd\u5b58\u6216\u4fee\u6539", paramDes={"\u66f4\u65b0\u5bf9\u8c61\u96c6\u5408"}, returnDes="\u591a\u8868\u8fd4\u56de\u503c")
    @DSTransactional
    public Object saveOrUpdate(List<DmlEntity> entities) {
        if (HussarUtils.isEmpty(entities)) {
            return false;
        }
        this.foreignValidate(entities);
        try {
            boolean incremental;
            UpdateEntity masterEntity;
            DmlEntity dmlEntity = entities.get(0);
            Object id = null;
            if (dmlEntity instanceof UpdateEntity) {
                masterEntity = (UpdateEntity)dmlEntity;
                incremental = masterEntity.getParam().containsKey("jxdDataOperateType");
                id = masterEntity.getParam().get(masterEntity.getModel().getPrimaryColumn().getColumnName());
            } else if (dmlEntity instanceof InsertEntity) {
                masterEntity = (InsertEntity)dmlEntity;
                incremental = masterEntity.getParam().containsKey("jxdDataOperateType");
                id = masterEntity.getParam().get(masterEntity.getModel().getPrimaryColumn().getColumnName());
            } else {
                incremental = false;
            }
            List<DmlEntity> updateEntities = entities.stream().filter(x -> x instanceof UpdateEntity).collect(Collectors.toList());
            updateEntities.forEach(x -> {
                UpdateEntity updateEntity = (UpdateEntity)x;
                if (!incremental) {
                    this.removeSlaveTable(updateEntity.getModel(), ((WhereEntity)updateEntity.getWhereEntityList().get(0)).getVal());
                }
            });
            Object result = this.incrementalSaveOrUpdate(entities);
            if (result instanceof Boolean) {
                return id;
            }
            if (result instanceof ApiResponse) {
                return result;
            }
            return false;
        }
        catch (Exception e) {
            throw new HussarException("\u4fdd\u5b58\u5931\u8d25", (Throwable)e);
        }
    }

    private void foreignValidate(List<DmlEntity> entities) {
        if (HussarUtils.isEmpty(entities)) {
            return;
        }
        List validators = entities.stream().filter(x -> x instanceof ForeignValidator).collect(Collectors.toList());
        if (HussarUtils.isNotEmpty(validators)) {
            for (DmlEntity x2 : validators) {
                boolean test = ((ForeignValidator)x2).test(arg_0 -> ((SingleTableService)this.singleTableService).selectOne(arg_0));
                if (test) continue;
                LOG.error("\u5916\u952e\u53c2\u6570\u6821\u9a8c\u9519\u8bef\uff0c\u8868\uff1a{}\uff0c\u503c:{}", (Object)((ForeignValidator)x2).getSelect().getTableName(), (Object)((ForeignValidator)x2).getSelect().getParam());
                throw new HussarException("\u53c2\u6570\u6821\u9a8c\u9519\u8bef");
            }
        }
    }

    @Override
    @EngineMethod(des="\u589e\u91cf-\u591a\u8868\u4fdd\u5b58\u6216\u4fee\u6539\u6216\u5220\u9664", paramDes={"\u66f4\u65b0\u5bf9\u8c61\u96c6\u5408"}, returnDes="\u591a\u8868\u8fd4\u56de\u503c")
    @DSTransactional
    public Object incrementalSaveOrUpdate(List<DmlEntity> entities) {
        if (HussarUtils.isEmpty(entities)) {
            return false;
        }
        this.foreignValidate(entities);
        try {
            for (DmlEntity dmlEntity : entities) {
                ApiResponse apiResponse;
                if (dmlEntity instanceof InsertEntity) {
                    apiResponse = this.singleTableService.save((InsertEntity)dmlEntity);
                    if (apiResponse.isSuccess()) continue;
                    return apiResponse;
                }
                if (dmlEntity instanceof UpdateEntity) {
                    UpdateEntity update = (UpdateEntity)dmlEntity;
                    apiResponse = update.getParam().containsKey("jxdDataOperateType") ? this.singleTableService.update(update) : this.singleTableService.saveOrUpdate(update);
                    if (apiResponse.isSuccess()) continue;
                    return apiResponse;
                }
                if (!(dmlEntity instanceof DeleteEntity)) continue;
                this.remove((DeleteEntity)dmlEntity);
            }
            return true;
        }
        catch (Exception e) {
            throw new HussarException("\u4fdd\u5b58\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    @EngineMethod(des="\u5220\u9664", paramAlias={"entity"}, paramDes={"\u5220\u9664\u5bf9\u8c61"}, returnDes="\u591a\u8868\u8fd4\u56de\u503c")
    @DSTransactional
    public boolean remove(DeleteEntity entity) {
        try {
            if (HussarUtils.isEmpty((Object)entity)) {
                throw new HussarException(EngineExceptionEnum.DELETE_ENTITY_EMPTY.getExceptionCode(), EngineExceptionEnum.DELETE_ENTITY_EMPTY.getMessage());
            }
            boolean result = this.singleTableService.remove(entity);
            if (result) {
                this.removeSlaveTable(entity.getRelationship(), ((WhereEntity)entity.getWhereEntityList().get(0)).getVal());
            }
            return result;
        }
        catch (HussarException e) {
            throw new HussarException("\u5220\u9664\u5931\u8d25", (Throwable)e);
        }
    }

    private void removeSlaveTable(ModelTableMappingDTO model, Object ids) {
        if (HussarUtils.isEmpty((Object)ids)) {
            return;
        }
        for (ModelTableMappingDTO joinDto : model.getSlaveTables()) {
            DynamicDataSourceContextHolder.push((String)joinDto.getPollName());
            HashMap<String, List<Object>> params = new HashMap<String, List<Object>>();
            MetadataColumnDto fkColumn = ((RelationshipOnDto)joinDto.getColumnOns().get(0)).getRightColumn();
            params.put(fkColumn.getColumnAlias(), ids instanceof List || ids instanceof Map ? ids : Collections.singletonList(ids));
            DmlEntityUtil.DmlServiceEntity dmlService = new DmlEntityUtil.DmlServiceEntity(joinDto, fkColumn);
            if (HussarUtils.isNotEmpty((Object)joinDto.getSlaveTables())) {
                SelectEntity entity = dmlService.selectByFkIds();
                entity.init(params);
                PageVo pageVo = this.singleTableService.selectList(entity);
                if (HussarUtils.isNotEmpty((Object)pageVo.getData())) {
                    String keyProperty = entity.getKeyProperty();
                    List collect = pageVo.getData().stream().map(m -> ((Map)m).get(keyProperty)).collect(Collectors.toList());
                    this.removeSlaveTable(joinDto, collect);
                }
            }
            DeleteEntity deleteEntity = dmlService.removeByFkIds();
            deleteEntity.init(params);
            deleteEntity.setRelationship(joinDto);
            this.singleTableService.remove(deleteEntity);
        }
    }

    @Override
    @EngineMethod(des="\u903b\u8f91\u5220\u9664", paramAlias={"entity"}, paramDes={"\u5220\u9664\u5bf9\u8c61"}, returnDes="\u591a\u8868\u8fd4\u56de\u503c")
    public boolean flagRemove(UpdateEntity updateEntity) {
        return this.msTableService.flagRemove(updateEntity);
    }

    @Override
    @EngineMethod(des="\u591a\u8868\u67e5\u8be2", paramAlias={"entity"}, paramDes={"\u67e5\u8be2\u5bf9\u8c61"}, returnDes="\u591a\u8868\u8fd4\u56de\u503c")
    public PageVo selectList(SelectEntity entity) {
        return this.msTableService.selectList(entity);
    }

    @Override
    @EngineMethod(des="\u591a\u8868\u5206\u9875\u67e5\u8be2", paramDes={"\u5206\u9875\u5bf9\u8c61", "\u67e5\u8be2\u5bf9\u8c61"}, returnDes="\u5206\u9875vo")
    public PageVo selectPage(IPage<EngineResult> page, SelectEntity entity) {
        return this.msTableService.selectPage(page, entity);
    }

    @Override
    @EngineMethod(des="\u591a\u8868\u67e5\u8be2\u5355\u6761", paramDes={"\u67e5\u8be2\u5bf9\u8c61"}, returnDes="\u591a\u8868\u8fd4\u56de\u503c")
    public EngineResult selectOne(SelectEntity entity) {
        return this.msTableService.selectOne(entity);
    }

    @Override
    @EngineMethod(des="\u591a\u8868\u5de5\u4f5c\u6d41\u67e5\u8be2", paramDes={"\u67e5\u8be2\u5bf9\u8c61", "node\u5bf9\u8c61"}, returnDes="\u591a\u8868\u8fd4\u56de\u503c")
    public EngineResult bpmSelect(SelectEntity entity, NodeBusinessVo businessVo) {
        return this.msTableService.bpmSelect(entity, businessVo);
    }
}

