/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.engine.plugin.dml.mss.support.service.solidorg;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.jxdinfo.hussar.datasource.manager.api.entity.MetadataColumn;
import com.jxdinfo.hussar.datasource.manager.api.model.MetadataColumnDto;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.engine.api.dto.ModelColumnDto;
import com.jxdinfo.hussar.support.engine.api.dto.ModelTableMappingDTO;
import com.jxdinfo.hussar.support.engine.api.dto.NodeBusinessVo;
import com.jxdinfo.hussar.support.engine.api.model.GhDataInOutDto;
import com.jxdinfo.hussar.support.engine.api.model.RelationshipOnDto;
import com.jxdinfo.hussar.support.engine.api.service.DataserviceService;
import com.jxdinfo.hussar.support.engine.api.support.solidorg.service.impl.DbAndBpmGainDataGhService;
import com.jxdinfo.hussar.support.engine.core.annotations.SolidService;
import com.jxdinfo.hussar.support.engine.core.enums.NodeTypeEnum;
import com.jxdinfo.hussar.support.engine.core.enums.PurposeEnum;
import com.jxdinfo.hussar.support.engine.core.util.EngineUtil;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.dml.DeleteEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.dml.DmlEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.dml.InsertEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.dml.SelectEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.dml.UpdateEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.mss.support.constants.MssConstants;
import com.jxdinfo.hussar.support.engine.plugin.dml.mss.support.dto.ForeignValidator;
import com.jxdinfo.hussar.support.engine.plugin.dml.mss.util.TreeSearch;
import com.jxdinfo.hussar.support.engine.plugin.dml.support.service.solidorg.MsTableGainDataGhServiceImpl;
import com.jxdinfo.hussar.support.engine.plugin.dml.util.DmlEntityUtil;
import com.jxdinfo.hussar.support.engine.plugin.model.application.IEnginePluginModelApp;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SolidService(value="com.jxdinfo.hussar.support.engine.plugin.dml.mss.support.service.solidorg.MultiMsTableGainDataGhServiceImpl", type=NodeTypeEnum.MULTI_MASTER, des="\u4e3b\u5b50\u8868\u5e95\u5c42\u8c03\u7528\u4ee5\u53ca\u62fc\u88c5\u53c2\u6570\u56fa\u5316\u903b\u8f91")
public class MultiMsTableGainDataGhServiceImpl
extends DbAndBpmGainDataGhService
implements MssConstants {
    private static final Logger LOG = LoggerFactory.getLogger(MultiMsTableGainDataGhServiceImpl.class);
    @Resource
    private IEnginePluginModelApp modelApp;
    @Resource
    private MsTableGainDataGhServiceImpl msTableGainDataGhService;

    public MultiMsTableGainDataGhServiceImpl(DataserviceService dataserviceService) {
        super(dataserviceService);
    }

    public Object[] getParam(String methodName, List<GhDataInOutDto> inList, Object ... arg) {
        Map param = (Map)arg[0];
        NodeBusinessVo businessVo = (NodeBusinessVo)arg[1];
        ModelTableMappingDTO model = this.modelApp.getModelTableMapping(businessVo.getModelId());
        if ("saveOrUpdate".equals(methodName)) {
            List<DmlEntity> dmlEntities = this.getDmlEntitiesToSave(model, param);
            return new Object[]{dmlEntities};
        }
        if ("incrementalSaveOrUpdate".equals(methodName)) {
            List<DmlEntity> dmlEntities = this.getDmlEntitiesToIncrementalSave(model, param);
            return new Object[]{dmlEntities};
        }
        if ("msSaveBatch".equals(methodName)) {
            Object value = param.get("importList");
            List<Map<String, Object>> paramList = value instanceof List ? (List<Map<String, Object>>)value : this.getMapByStr(HussarUtils.toStr(value));
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put(model.getParamName(), paramList);
            List<DmlEntity> dmlEntities = this.getDmlEntitiesToSave(model, map);
            return new Object[]{dmlEntities};
        }
        return this.msTableGainDataGhService.getParam(methodName, inList, arg);
    }

    private List<DmlEntity> getDmlEntitiesToSave(ModelTableMappingDTO model, Map<String, Object> param) {
        ArrayList<DmlEntity> results = new ArrayList<DmlEntity>();
        List<NodeInfo> nodeInfos = this.fixPosition(model, param);
        nodeInfos.forEach(node -> this.getDmlEntitiesToSave((List<DmlEntity>)results, (NodeInfo)node, null, model));
        return results;
    }

    private List<DmlEntity> getDmlEntitiesToIncrementalSave(ModelTableMappingDTO model, Map<String, Object> param) {
        Object del;
        ArrayList<DmlEntity> results = new ArrayList<DmlEntity>();
        Object saveAndUpdate = param.get("saveAndUpdate");
        if (saveAndUpdate instanceof Map) {
            results.addAll(this.getDmlEntitiesToSave(model, (Map)saveAndUpdate));
        }
        if ((del = param.get("del")) instanceof Map) {
            results.addAll(this.getDmlEntitiesToDelete(model, (Map)del));
        }
        return results;
    }

    private List<NodeInfo> fixPosition(ModelTableMappingDTO model, Map<String, Object> param) {
        if (param.keySet().stream().anyMatch(x -> !x.startsWith(""))) {
            LOG.error("\u53c2\u6570\u7684\u5916\u5c42\u5e94\u8be5\u662f_t_\u5f00\u5934\u7684\u8868\u540d");
            throw new HussarException("\u53c2\u6570\u9519\u8bef!");
        }
        ArrayList<NodeInfo> result = new ArrayList<NodeInfo>();
        param.forEach((tableName, obj) -> {
            ModelTableMappingDTO node = TreeSearch.bfs(model, ModelTableMappingDTO::getSlaveTables, x -> tableName.equals("" + x.getParamName()));
            if (obj instanceof List) {
                List list = (List)obj;
                list.forEach(item -> result.add(new NodeInfo(node, (Map)item)));
            }
        });
        return result;
    }

    private List<DmlEntity> getDmlEntitiesToDelete(ModelTableMappingDTO model, Map<String, Object> param) {
        ArrayList<DmlEntity> results = new ArrayList<DmlEntity>();
        List<NodeInfo> nodeInfos = this.fixPosition(model, param);
        nodeInfos.forEach(node -> this.getDmlEntitiesToDelete((List<DmlEntity>)results, (NodeInfo)node));
        return results;
    }

    private void getDmlEntitiesToDelete(List<DmlEntity> results, NodeInfo currentNode) {
        if (HussarUtils.isEmpty(currentNode.getParam()) || currentNode.getModel() == null) {
            return;
        }
        Map<String, ModelColumnDto> alias2Column = currentNode.getModel().getColumns().stream().collect(Collectors.toMap(MetadataColumn::getColumnAlias, x -> x));
        currentNode.getParam().forEach((k, v) -> {
            if (alias2Column.containsKey(k)) {
                DmlEntityUtil.DmlServiceEntity dmlServiceEntity = new DmlEntityUtil.DmlServiceEntity(currentNode.getModel());
                DeleteEntity dmlEntity = dmlServiceEntity.removeIn((MetadataColumnDto)alias2Column.get(k), currentNode.getModel());
                HashMap<String, List<String>> param = new HashMap<String, List<String>>(1);
                param.put((String)k, Arrays.asList(String.valueOf(v).split(",")));
                dmlEntity.init(param);
                results.add((DmlEntity)dmlEntity);
            }
        });
    }

    private void getDmlEntitiesToSave(List<DmlEntity> results, NodeInfo currentNode, NodeInfo parentNode, ModelTableMappingDTO model) {
        if (HussarUtils.isEmpty(currentNode.getParam()) || currentNode.getModel() == null) {
            return;
        }
        List columns = currentNode.getModel().getColumns();
        Map<String, ModelColumnDto> alias2Column = columns.stream().collect(Collectors.toMap(MetadataColumn::getColumnAlias, x -> x));
        boolean hasCurrentNodeParam = currentNode.getParam().keySet().stream().anyMatch(alias2Column::containsKey);
        if (hasCurrentNodeParam) {
            String dmlEntityType = this.getDmlEntityType(currentNode, columns);
            Map<String, Object> specialParam = this.getSpecialParam(currentNode, parentNode, results, model);
            currentNode.getParam().putAll(specialParam);
            DmlEntity dmlEntity = this.getDmlEntityByModelAndParam(currentNode, dmlEntityType);
            results.add(dmlEntity);
        }
        List<NodeInfo> nextNodes = currentNode.nextNodes();
        nextNodes.forEach(node -> this.getDmlEntitiesToSave(results, (NodeInfo)node, currentNode, model));
    }

    private DmlEntity getDmlEntityByModelAndParam(NodeInfo currentNode, String dmlEntityType) {
        InsertEntity dmlEntity;
        DmlEntityUtil.DmlServiceEntity dmlServiceEntity = new DmlEntityUtil.DmlServiceEntity(currentNode.getModel());
        if (dmlEntityType.equals(InsertEntity.class.getName())) {
            InsertEntity insert = dmlServiceEntity.insert();
            insert.setCheckUnique(false);
            dmlEntity = insert;
        } else {
            UpdateEntity updateEntity = dmlServiceEntity.updateById();
            updateEntity.setCheckUnique(false);
            dmlEntity = updateEntity;
            ((UpdateEntity)dmlEntity).setModel(currentNode.getModel());
        }
        dmlEntity.init(currentNode.getParam());
        return dmlEntity;
    }

    private String getDmlEntityType(NodeInfo currentNode, List<ModelColumnDto> columns) {
        Optional<ModelColumnDto> primaryOp = columns.stream().filter(x -> PurposeEnum.PRIMARY.getValue().equals(x.getPurpose())).findFirst();
        String dmlEntityType = UpdateEntity.class.getName();
        if (primaryOp.isPresent() && currentNode.getParam().get(primaryOp.get().getColumnAlias()) == null) {
            dmlEntityType = InsertEntity.class.getName();
        }
        return dmlEntityType;
    }

    private Map<String, Object> getSpecialParam(NodeInfo currentNode, NodeInfo parentNode, List<DmlEntity> results, ModelTableMappingDTO model) {
        List columnOns;
        HashMap<String, Object> specialParams = new HashMap<String, Object>();
        List columns = currentNode.getModel().getColumns();
        Map<Long, String> columnId2Alias = this.getColumnAliasMap(columns);
        boolean isInsert = false;
        Optional<ModelColumnDto> primaryOp = columns.stream().filter(x -> PurposeEnum.PRIMARY.getValue().equals(x.getPurpose())).findFirst();
        if (primaryOp.isPresent()) {
            ModelColumnDto primary = primaryOp.get();
            if (currentNode.getParam().get(primary.getColumnAlias()) == null || !String.valueOf(currentNode.getParam().get(primary.getColumnAlias())).matches("\\d+")) {
                isInsert = true;
                specialParams.put(primary.getColumnAlias(), EngineUtil.getId());
            }
        }
        if (HussarUtils.isNotEmpty((Object)(columnOns = currentNode.getModel().getColumnOns()))) {
            ForeignValidator foreignValidator;
            HashMap parentColumnId2Alias = parentNode != null && parentNode.getModel() != null ? this.getColumnAliasMap(parentNode.getModel().getColumns()) : new HashMap();
            HashMap<Long, Object> parentColumnId2Value = new HashMap<Long, Object>();
            boolean needValidate = false;
            for (RelationshipOnDto on : columnOns) {
                boolean parentContainsForeign;
                if (columnId2Alias.get(on.getRightColumnId()) == null) continue;
                Object foreignValue = currentNode.getParam().get(columnId2Alias.get(on.getRightColumnId()));
                parentColumnId2Value.put(on.getLeftColumnId(), foreignValue);
                boolean bl = parentContainsForeign = parentNode != null && parentColumnId2Alias.containsKey(on.getLeftColumnId()) && parentNode.getParam().containsKey(parentColumnId2Alias.get(on.getLeftColumnId()));
                if (foreignValue == null) {
                    if (parentContainsForeign) {
                        specialParams.put(columnId2Alias.get(on.getRightColumnId()), parentNode.getParam().get(parentColumnId2Alias.get(on.getLeftColumnId())));
                        continue;
                    }
                    if (!isInsert) continue;
                    LOG.error("\u5916\u952e\u6ca1\u6709\u83b7\u53d6\u5230\u5bf9\u5e94\u7684\u503c\uff0c\u4f1a\u4ea7\u751f\u810f\u6570\u636e\uff01");
                    throw new HussarException("\u53c2\u6570\u9519\u8bef!");
                }
                if (parentContainsForeign && !parentNode.getParam().get(parentColumnId2Alias.get(on.getLeftColumnId())).equals(foreignValue)) {
                    LOG.error("\u5916\u952e\u7684\u503c\u548c\u7236\u8282\u70b9\u5bf9\u5e94\u7684\u503c\u4e0d\u76f8\u7b49\uff0c\u4f1a\u4ea7\u751f\u810f\u6570\u636e\uff01");
                    throw new HussarException("\u53c2\u6570\u9519\u8bef!");
                }
                if (parentContainsForeign) continue;
                needValidate = true;
            }
            if (needValidate && (foreignValidator = this.getForeignValidator(currentNode, parentColumnId2Value, model)) != null) {
                results.add(foreignValidator);
            }
        }
        return specialParams;
    }

    private ForeignValidator getForeignValidator(NodeInfo currentNode, Map<Long, Object> parentColumnId2Value, ModelTableMappingDTO model) {
        ModelTableMappingDTO parentModel = TreeSearch.bfsFindParent(model, ModelTableMappingDTO::getSlaveTables, x -> currentNode.getParamName().equals(x.getParamName()));
        DmlEntityUtil.DmlServiceEntity dmlService = new DmlEntityUtil.DmlServiceEntity(parentModel);
        SelectEntity selectEntity = dmlService.selectByColumns(parentColumnId2Value);
        if (selectEntity != null) {
            ForeignValidator foreignValidator = new ForeignValidator();
            foreignValidator.setSelect(selectEntity);
            return foreignValidator;
        }
        return null;
    }

    private Map<Long, String> getColumnAliasMap(List<ModelColumnDto> modelColumnDtos) {
        return modelColumnDtos.stream().collect(Collectors.toMap(MetadataColumn::getColumnId, MetadataColumn::getColumnAlias));
    }

    private List<Map<String, Object>> getMapByStr(String str) {
        if (HussarUtils.isEmpty((Object)str)) {
            return new ArrayList<Map<String, Object>>();
        }
        return (List)JSONObject.parseObject((String)str, (TypeReference)new TypeReference<List<Map<String, Object>>>(){}, (Feature[])new Feature[0]);
    }

    static class NodeInfo {
        private ModelTableMappingDTO model;
        private Map<String, Object> param;

        public NodeInfo() {
        }

        public NodeInfo(ModelTableMappingDTO model, Map<String, Object> param) {
            this.model = model;
            this.param = param;
        }

        public List<NodeInfo> nextNodes() {
            ArrayList<NodeInfo> results = new ArrayList<NodeInfo>();
            List slaves = this.model.getSlaveTables();
            if (HussarUtils.isEmpty((Object)slaves)) {
                return results;
            }
            for (ModelTableMappingDTO slave : slaves) {
                Object obj = this.param.get("" + slave.getParamName());
                if (!(obj instanceof List)) continue;
                List list = (List)obj;
                list.forEach(item -> results.add(new NodeInfo(slave, (Map)item)));
            }
            return results;
        }

        public String getParamName() {
            return this.model.getParamName();
        }

        public Object getParamByColumnId(Long columnId) {
            Optional<ModelColumnDto> column = this.model.getColumns().stream().filter(x -> columnId.equals(x.getColumnId())).findFirst();
            return column.map(modelColumnDto -> this.param.get(modelColumnDto.getColumnAlias())).orElse(null);
        }

        private boolean paramHasNodeOfOneOne(ModelTableMappingDTO model) {
            List columns = model.getColumns();
            for (ModelColumnDto column : columns) {
                if (!this.param.containsKey(column.getColumnAlias())) continue;
                return true;
            }
            return false;
        }

        private boolean paramHasNodeOfOneN(ModelTableMappingDTO model) {
            return this.param.containsKey(model.getParamName()) && this.param.get(model.getParamName()) instanceof List;
        }

        public ModelTableMappingDTO getModel() {
            return this.model;
        }

        public void setModel(ModelTableMappingDTO model) {
            this.model = model;
        }

        public Map<String, Object> getParam() {
            return this.param;
        }

        public void setParam(Map<String, Object> param) {
            this.param = param;
        }
    }
}

