/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.engine.plugin.bpm.support.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.engine.api.dto.ModelColumnDto;
import com.jxdinfo.hussar.support.engine.api.dto.ModelTableMappingDTO;
import com.jxdinfo.hussar.support.engine.api.enums.NodeOperationEnum;
import com.jxdinfo.hussar.support.engine.api.factory.ApiActionFactory;
import com.jxdinfo.hussar.support.engine.api.model.NodeBusiness;
import com.jxdinfo.hussar.support.engine.api.service.NodeBusinessService;
import com.jxdinfo.hussar.support.engine.core.enums.NodeTypeEnum;
import com.jxdinfo.hussar.support.engine.core.enums.PurposeEnum;
import com.jxdinfo.hussar.support.engine.core.vo.PageVo;
import com.jxdinfo.hussar.support.engine.plugin.model.application.impl.EnginePluginModelApp;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.model.ProcessNode;
import com.jxdinfo.hussar.workflow.task.model.dto.CompleteTaskInfoDto;
import com.jxdinfo.hussar.workflow.task.model.dto.DeletedProcessInfoDto;
import com.jxdinfo.hussar.workflow.task.model.dto.DeletedTaskInfoDto;
import com.jxdinfo.hussar.workflow.task.model.dto.ProcessChangeDto;
import com.jxdinfo.hussar.workflow.task.model.dto.ProcessChangeListDto;
import com.jxdinfo.hussar.workflow.task.model.dto.ProcessInfoDto;
import com.jxdinfo.hussar.workflow.task.model.dto.ProcessNodeInfoDto;
import com.jxdinfo.hussar.workflow.task.model.dto.TaskInfoDto;
import com.jxdinfo.hussar.workflow.task.model.dto.UpdateTaskUserDto;
import com.jxdinfo.hussar.workflow.task.model.dto.WorkflowUserDto;
import com.jxdinfo.hussar.workflow.task.model.service.TaskModelService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="hussar_engine_bpm_recall")
public class TaskModelServiceImpl
implements TaskModelService {
    private static final Logger logger = LoggerFactory.getLogger(TaskModelServiceImpl.class);
    @Autowired
    private NodeBusinessService nodeBusinessService;
    @Autowired
    private EnginePluginModelApp enginePluginModelApp;
    private static final String TASK = "task";
    private static final String BUSINESS = "business";
    private static final Map<String, PurposeEnum> bpmField2PurposeBusiness = new HashMap<String, PurposeEnum>();
    private static final Map<String, PurposeEnum> bpmField2PurposeTask = new HashMap<String, PurposeEnum>();

    public boolean changeProcessInfo(ProcessInfoDto processInfoDto) {
        Resource resource = this.getMethod(processInfoDto.getProcessKey(), processInfoDto.getFormId(), BUSINESS);
        if (resource == null) {
            return false;
        }
        Map bpmMap = BeanUtil.beanToMap((Object)processInfoDto);
        Map<String, Object> modelMap = this.businessMap2ModelMap(bpmMap, resource.getModel());
        String businessIdCondition = this.getConditionAlias(resource.getUpdate(), resource.getModel().getColumnByPurpose(PurposeEnum.PRIMARY).getColumnId(), PurposeEnum.PRIMARY);
        modelMap.put(businessIdCondition, processInfoDto.getBusinessId());
        modelMap.put("tfModelId", resource.getModel().getTfModelId());
        modelMap.put("noSecurityLevelWhere", true);
        try {
            this.nodeBusinessService.invoke(resource.getUpdate().getNodeName(), modelMap, null);
            modelMap.remove("noSecurityLevelWhere");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return true;
    }

    private Map<String, Object> businessMap2ModelMap(Map<String, Object> bpmMap, ModelTableMappingDTO model) {
        HashMap<String, Object> modelMap = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : bpmMap.entrySet()) {
            ModelColumnDto column;
            String k = entry.getKey();
            if (bpmField2PurposeBusiness.containsKey(k) && (column = model.getColumnByPurpose(bpmField2PurposeBusiness.get(k))) != null) {
                modelMap.put(column.getColumnAlias(), entry.getValue());
                continue;
            }
            logger.warn("bpm recall error: not found the property: {} where bpm param transfer to model method param :", (Object)k);
        }
        return modelMap;
    }

    private Map<String, Object> taskMap2ModelMap(Map<String, Object> bpmMap, ModelTableMappingDTO model) {
        HashMap<String, Object> modelMap = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : bpmMap.entrySet()) {
            ModelColumnDto column;
            String k = entry.getKey();
            if (bpmField2PurposeTask.containsKey(k) && (column = model.getColumnByPurpose(bpmField2PurposeTask.get(k))) != null) {
                modelMap.put(column.getColumnAlias(), entry.getValue());
                continue;
            }
            logger.warn("bpm recall error: not found the property: {} where bpm param transfer to model method param :", (Object)k);
        }
        return modelMap;
    }

    public boolean deleteProcess(List<DeletedProcessInfoDto> deletedProcessInfoDtos) {
        if (HussarUtils.isEmpty(deletedProcessInfoDtos)) {
            return false;
        }
        Resource resource = this.getMethod(deletedProcessInfoDtos.get(0).getProcessKey(), deletedProcessInfoDtos.get(0).getFormId(), BUSINESS);
        if (HussarUtils.isEmpty((Object)resource)) {
            return false;
        }
        Map<String, Object> modelMap = this.businessMap2ModelMap(BeanUtil.beanToMap((Object)deletedProcessInfoDtos.get(0)), resource.getModel());
        modelMap.remove(resource.getModel().getColumnByPurpose(PurposeEnum.PRIMARY).getColumnAlias());
        List idList = deletedProcessInfoDtos.stream().map(DeletedProcessInfoDto::getBusinessId).collect(Collectors.toList());
        String businessIdCondition = this.getConditionAlias(resource.getUpdate(), resource.getModel().getColumnByPurpose(PurposeEnum.PRIMARY).getColumnId(), PurposeEnum.PRIMARY);
        modelMap.put(businessIdCondition, idList);
        modelMap.put("tfModelId", resource.getModel().getTfModelId());
        try {
            this.nodeBusinessService.invoke(resource.getUpdate().getNodeName(), modelMap, null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return true;
    }

    public boolean changeProcessNode(ProcessNodeInfoDto processNodeInfoDto) {
        if (processNodeInfoDto == null) {
            return false;
        }
        Resource resource = this.getMethod(processNodeInfoDto.getProcessKey(), processNodeInfoDto.getFormId(), BUSINESS);
        if (HussarUtils.isEmpty((Object)resource)) {
            return false;
        }
        HashMap<String, Object> modelMap = new HashMap<String, Object>();
        ModelTableMappingDTO model = resource.getModel();
        String[] processNodeInfoArr = this.analyzeProcessNode(processNodeInfoDto.getProcessNodeList());
        modelMap.put(model.getColumnByPurpose(PurposeEnum.PROCESS_NODE).getColumnAlias(), processNodeInfoArr[0]);
        ModelColumnDto processNodeKeyColumn = model.getColumnByPurpose(PurposeEnum.PROCESS_NODE_KEY);
        if (HussarUtils.isNotEmpty((Object)processNodeKeyColumn)) {
            modelMap.put(processNodeKeyColumn.getColumnAlias(), processNodeInfoArr[1]);
        }
        String businessIdCondition = this.getConditionAlias(resource.getUpdate(), resource.getModel().getColumnByPurpose(PurposeEnum.PRIMARY).getColumnId(), PurposeEnum.PRIMARY);
        modelMap.put(businessIdCondition, processNodeInfoDto.getBusinessId());
        modelMap.put("tfModelId", resource.getModel().getTfModelId());
        modelMap.put("noSecurityLevelWhere", true);
        try {
            this.nodeBusinessService.invoke(resource.getUpdate().getNodeName(), modelMap, null);
            modelMap.remove("noSecurityLevelWhere");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return true;
    }

    private String[] analyzeProcessNode(List<ProcessNode> nodeList) {
        String[] nodeInfoArr = new String[]{"", ""};
        if (HussarUtils.isEmpty(nodeList)) {
            return nodeInfoArr;
        }
        for (ProcessNode node : nodeList) {
            String nodeName = node.getTaskDefinitionName();
            String nodeKey = node.getTaskDefinitionKey();
            if (HussarUtils.isNotEmpty((Object)node.getChildrenList())) {
                nodeName = nodeName + "(";
                nodeKey = nodeKey + "(";
                for (ProcessNode childNode : node.getChildrenList()) {
                    nodeName = nodeName + childNode.getTaskDefinitionName() + "\u3001";
                    nodeKey = nodeKey + childNode.getTaskDefinitionKey() + "\u3001";
                }
                nodeName = nodeName.substring(0, nodeName.length() - 1) + ")";
                nodeKey = nodeKey.substring(0, nodeKey.length() - 1) + ")";
            }
            nodeInfoArr[0] = nodeInfoArr[0] + (HussarUtils.isBlank((CharSequence)nodeInfoArr[0]) ? nodeName : "-" + nodeName);
            nodeInfoArr[1] = nodeInfoArr[1] + (HussarUtils.isBlank((CharSequence)nodeInfoArr[1]) ? nodeKey : "-" + nodeKey);
        }
        return nodeInfoArr;
    }

    @Transactional
    public Integer addTaskInfo(TaskInfoDto taskInfoDto) {
        if (taskInfoDto == null) {
            return 0;
        }
        Resource resource = this.getMethod(taskInfoDto.getProcessKey(), taskInfoDto.getFormId(), TASK);
        if (HussarUtils.isEmpty((Object)resource)) {
            return 0;
        }
        if (taskInfoDto.getUsers() == null || taskInfoDto.getUsers().size() == 0) {
            Map bpmMap = BeanUtil.beanToMap((Object)taskInfoDto);
            Map<String, Object> modelMap = this.taskMap2ModelMap(bpmMap, resource.getModel());
            modelMap.put("tfModelId", resource.getModel().getTfModelId());
            try {
                this.nodeBusinessService.invoke(resource.getInsert().getNodeName(), modelMap, null);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return 1;
        }
        for (WorkflowUserDto user : taskInfoDto.getUsers()) {
            Map<String, Object> modelMap = this.taskMap2ModelMap(BeanUtil.beanToMap((Object)taskInfoDto), resource.getModel());
            modelMap.put("tfModelId", resource.getModel().getTfModelId());
            modelMap.put(resource.getModel().getColumnByPurpose(PurposeEnum.ASSIGNEE).getColumnAlias(), user.getUserId());
            modelMap.put(resource.getModel().getColumnByPurpose(PurposeEnum.TASK_DEFINITION_KEY).getColumnAlias(), taskInfoDto.getTaskDefinitionKey());
            modelMap.put(resource.getModel().getColumnByPurpose(PurposeEnum.TASK_DEFINITION_NAME).getColumnAlias(), taskInfoDto.getTaskDefinitionName());
            try {
                this.nodeBusinessService.invoke(resource.getInsert().getNodeName(), modelMap, null);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return taskInfoDto.getUsers().size();
    }

    public boolean completeTask(List<CompleteTaskInfoDto> completeTaskInfoDtos) {
        if (HussarUtils.isEmpty(completeTaskInfoDtos)) {
            return false;
        }
        Resource resource = this.getMethod(completeTaskInfoDtos.get(0).getProcessKey(), completeTaskInfoDtos.get(0).getFormId(), TASK);
        if (HussarUtils.isEmpty((Object)resource)) {
            return false;
        }
        HashMap<String, String> params = new HashMap<String, String>();
        ModelTableMappingDTO model = resource.getModel();
        ModelColumnDto tasIdCol = model.getColumnByPurpose(PurposeEnum.TASK_ID);
        String conditionAlias = this.getConditionAlias(resource.getSelectList(), tasIdCol.getColumnId(), PurposeEnum.TASK_ID);
        for (CompleteTaskInfoDto item : completeTaskInfoDtos) {
            params.put(conditionAlias, item.getTaskId());
            params.put("tfModelId", resource.getModel().getTfModelId());
            try {
                Object invoke = this.nodeBusinessService.invoke(resource.getSelectList().getNodeName(), params, null);
                PageVo page = (PageVo)invoke;
                if (HussarUtils.isEmpty((Object)page.getData())) {
                    logger.error("bpm recall for completeTask error: not found tasks for taskId: {}", (Object)item.getTaskId());
                    continue;
                }
                Map task = (Map)page.getData().get(0);
                this.nodeBusinessService.invoke(resource.getRemove().getNodeName(), params, null);
                task.put(model.getColumnByPurpose(PurposeEnum.END_TIME).getColumnAlias(), item.getEndTime());
                task.put(model.getColumnByPurpose(PurposeEnum.TASK_TYPE).getColumnAlias(), item.getTaskType());
                task.put(model.getColumnByPurpose(PurposeEnum.TASK_STATE).getColumnAlias(), item.getTaskState());
                task.put(model.getColumnByPurpose(PurposeEnum.ASSIGNEE).getColumnAlias(), item.getAssignee());
                task.put("tfModelId", resource.getModel().getTfModelId());
                this.nodeBusinessService.invoke(resource.getInsert().getNodeName(), task, null);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return true;
    }

    private String getConditionAlias(NodeBusiness selectOne, Long columnId, PurposeEnum purposeEnum) {
        JSONObject dto = JSON.parseObject((String)selectOne.getJsonParams());
        JSONArray whereList = dto.getJSONArray("whereList");
        for (int i = 0; i < whereList.size(); ++i) {
            JSONObject where = whereList.getJSONObject(i);
            if (!columnId.equals(where.getLong("columnId")) && !purposeEnum.name().equals(where.getString("purpose"))) continue;
            return where.getString("parameterAlias");
        }
        return null;
    }

    public Integer updateTaskUser(List<UpdateTaskUserDto> updateTaskUserDtos) {
        if (HussarUtils.isEmpty(updateTaskUserDtos)) {
            return 0;
        }
        Resource resource = this.getMethod(updateTaskUserDtos.get(0).getProcessKey(), updateTaskUserDtos.get(0).getFormId(), TASK);
        if (HussarUtils.isEmpty((Object)resource)) {
            return 0;
        }
        HashMap<String, String> params = new HashMap<String, String>();
        ModelTableMappingDTO model = resource.getModel();
        ModelColumnDto tasIdCol = model.getColumnByPurpose(PurposeEnum.TASK_ID);
        String taskIdConditionForSelectList = this.getConditionAlias(resource.getSelectList(), tasIdCol.getColumnId(), PurposeEnum.TASK_ID);
        String taskIdConditionForRemove = this.getConditionAlias(resource.getRemove(), tasIdCol.getColumnId(), PurposeEnum.TASK_ID);
        int article = 0;
        for (UpdateTaskUserDto updateTaskUserDto : updateTaskUserDtos) {
            if (updateTaskUserDto.getTaskId() == null || updateTaskUserDto.getTaskId().length() <= 0) continue;
            params.put(taskIdConditionForSelectList, updateTaskUserDto.getTaskId());
            params.put("tfModelId", resource.getModel().getTfModelId());
            try {
                Object invoke = this.nodeBusinessService.invoke(resource.getSelectList().getNodeName(), params, null);
                PageVo page = (PageVo)invoke;
                if (HussarUtils.isEmpty((Object)page.getData())) {
                    logger.error("bpm recall for updateTaskUser error: not found task data for taskId: {}", (Object)updateTaskUserDto.getTaskId());
                    continue;
                }
                HashMap<String, String> removeParams = new HashMap<String, String>();
                removeParams.put(taskIdConditionForRemove, updateTaskUserDto.getTaskId());
                removeParams.put("tfModelId", resource.getModel().getTfModelId());
                this.nodeBusinessService.invoke(resource.getRemove().getNodeName(), removeParams, null);
                Map task = (Map)page.getData().get(0);
                task.put(model.getColumnByPurpose(PurposeEnum.PRIMARY).getColumnAlias(), null);
                String assignAlias = model.getColumnByPurpose(PurposeEnum.ASSIGNEE).getColumnAlias();
                if (updateTaskUserDto.getUsers() == null || updateTaskUserDto.getUsers().size() == 0) {
                    task.put(assignAlias, null);
                    task.put("tfModelId", resource.getModel().getTfModelId());
                    this.nodeBusinessService.invoke(resource.getInsert().getNodeName(), task, null);
                    ++article;
                    continue;
                }
                ArrayList<Map> tasks = new ArrayList<Map>();
                for (WorkflowUserDto user : updateTaskUserDto.getUsers()) {
                    Map clone = (Map)HussarUtils.clone((Object)task);
                    clone.put(assignAlias, user.getUserId());
                    tasks.add(clone);
                }
                HashMap<String, String> batchParams = new HashMap<String, String>();
                batchParams.put("importList", JSON.toJSONString(tasks));
                batchParams.put("tfModelId", resource.getModel().getTfModelId());
                this.nodeBusinessService.invoke(resource.getSaveBatch().getNodeName(), batchParams, null);
                article += updateTaskUserDto.getUsers().size();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return article;
    }

    public boolean deleteTaskInfo(List<DeletedTaskInfoDto> deletedTaskInfoDtos) {
        if (HussarUtils.isEmpty(deletedTaskInfoDtos)) {
            return false;
        }
        Resource resource = this.getMethod(deletedTaskInfoDtos.get(0).getProcessKey(), deletedTaskInfoDtos.get(0).getFormId(), TASK);
        if (HussarUtils.isEmpty((Object)resource)) {
            return false;
        }
        NodeBusiness remove = resource.getRemove();
        HashMap<String, Object> params = new HashMap<String, Object>();
        for (DeletedTaskInfoDto deletedTaskInfoDto : deletedTaskInfoDtos) {
            ModelColumnDto columnByPurpose;
            if (deletedTaskInfoDto.getTaskIdList() != null && deletedTaskInfoDto.getTaskIdList().size() > 0) {
                columnByPurpose = resource.getModel().getColumnByPurpose(PurposeEnum.TASK_ID);
                String taskIdCondition = this.getConditionAlias(remove, columnByPurpose.getColumnId(), PurposeEnum.TASK_ID);
                params.put(taskIdCondition, deletedTaskInfoDto.getTaskIdList());
                continue;
            }
            columnByPurpose = resource.getModel().getColumnByPurpose(PurposeEnum.FOREIGN);
            String businessIdCondition = this.getConditionAlias(remove, columnByPurpose.getColumnId(), PurposeEnum.FOREIGN);
            params.put(businessIdCondition, deletedTaskInfoDto.getBusinessIdList());
        }
        params.put("tfModelId", resource.getModel().getTfModelId());
        try {
            this.nodeBusinessService.invoke(remove.getNodeName(), params, null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return true;
    }

    private Resource getMethod(String processKey, String formId, String type) {
        Map<String, Resource> methodsByProcessKey = this.getMethodsByProcessKeyOrFormId(processKey, formId);
        return methodsByProcessKey == null ? null : methodsByProcessKey.get(type);
    }

    private Map<String, Resource> getMethodsByProcessKeyOrFormId(String processKey, String formId) {
        Map<String, Resource> methodsMap = this.getMethodsByTfModelId(formId);
        if (HussarUtils.isNotEmpty(methodsMap)) {
            return methodsMap;
        }
        return this.getMethodsByProcessKey(processKey);
    }

    private Map<String, Resource> getMethodsByTfModelId(String tfModelId) {
        if (HussarUtils.isBlank((CharSequence)tfModelId)) {
            logger.error("workFlow recall error : tfModelId: is blank");
            return null;
        }
        String processTfModelId = "process_task_info_" + tfModelId;
        ModelTableMappingDTO task = this.enginePluginModelApp.getModelTableMapping(processTfModelId);
        if (task == null || HussarUtils.isEmpty((Object)task.getSlaveTables())) {
            logger.error("workFlow recall error : not found task or business table for tfModelId: {}", (Object)tfModelId);
            return null;
        }
        ModelTableMappingDTO business = (ModelTableMappingDTO)task.getSlaveTables().get(0);
        business.setTfModelId(tfModelId);
        Resource taskResource = new Resource(task);
        Resource businessResource = new Resource(business);
        HashMap<String, Resource> resourceMap = new HashMap<String, Resource>();
        resourceMap.put(TASK, taskResource);
        resourceMap.put(BUSINESS, businessResource);
        taskResource.appendInsert((NodeBusiness)ApiActionFactory.getDynamicApiAction((String)("POST." + NodeTypeEnum.SINGLE.getValue() + NodeOperationEnum.SAVE.getValue())));
        taskResource.appendSelectList((NodeBusiness)ApiActionFactory.getDynamicApiAction((String)("POST." + NodeTypeEnum.SINGLE.getValue() + NodeOperationEnum.SELECTLIST.getValue())));
        taskResource.appendRemove((NodeBusiness)ApiActionFactory.getDynamicApiAction((String)("POST." + NodeTypeEnum.SINGLE.getValue() + "delete")));
        taskResource.appendSaveBatch((NodeBusiness)ApiActionFactory.getDynamicApiAction((String)("POST." + NodeTypeEnum.SINGLE.getValue() + NodeOperationEnum.SAVEORUPDATEBATCH.getValue())));
        businessResource.appendUpdate((NodeBusiness)ApiActionFactory.getDynamicApiAction((String)("POST." + NodeTypeEnum.SINGLE.getValue() + NodeOperationEnum.UPDATE.getValue())));
        this.validateTaskResource(taskResource);
        this.validateBusinessResource(businessResource);
        return resourceMap;
    }

    private Map<String, Resource> getMethodsByProcessKey(String processKey) {
        if (HussarUtils.isBlank((CharSequence)processKey)) {
            logger.error("workFlow recall error : processKey: is blank");
            return null;
        }
        List nodeBusinessList = this.nodeBusinessService.list((Wrapper)Wrappers.lambdaQuery(NodeBusiness.class).eq(NodeBusiness::getBusinessCode, (Object)processKey));
        if (HussarUtils.isEmpty((Object)nodeBusinessList)) {
            return null;
        }
        Set modelIds = nodeBusinessList.stream().map(NodeBusiness::getModelId).collect(Collectors.toSet());
        ModelTableMappingDTO task = null;
        ModelTableMappingDTO business = null;
        for (Long modelId : modelIds) {
            ModelTableMappingDTO modelTableMapping = this.enginePluginModelApp.getModelTableMapping(modelId);
            if (!"0".equals(modelTableMapping.getParentPath())) continue;
            task = modelTableMapping;
            List slaveTables = modelTableMapping.getSlaveTables();
            if (!HussarUtils.isNotEmpty((Object)slaveTables)) continue;
            business = (ModelTableMappingDTO)slaveTables.get(0);
        }
        if (task == null || business == null) {
            logger.error("workFlow recall error : not found task or business table for processKey: {}", (Object)processKey);
            return null;
        }
        Resource taskResource = new Resource(task);
        Resource businessResource = new Resource(business);
        HashMap<String, Resource> resourceMap = new HashMap<String, Resource>();
        resourceMap.put(TASK, taskResource);
        resourceMap.put(BUSINESS, businessResource);
        for (NodeBusiness item : nodeBusinessList) {
            if (NodeOperationEnum.SAVEORUPDATE.getValue().equals(item.getActionName()) || NodeOperationEnum.UPDATE.getValue().equals(item.getActionName())) {
                if (item.getModelId().equals(task.getRelatedId())) {
                    taskResource.appendUpdate(item);
                } else if (item.getModelId().equals(business.getRelatedId())) {
                    businessResource.appendUpdate(item);
                }
            }
            if (NodeOperationEnum.SAVEORUPDATE.getValue().equals(item.getActionName()) || NodeOperationEnum.SAVE.getValue().equals(item.getActionName())) {
                if (item.getModelId().equals(task.getRelatedId())) {
                    taskResource.appendInsert(item);
                    continue;
                }
                if (!item.getModelId().equals(business.getRelatedId())) continue;
                businessResource.appendInsert(item);
                continue;
            }
            if (NodeOperationEnum.SELECTLIST.getValue().equals(item.getActionName())) {
                if (item.getModelId().equals(task.getRelatedId())) {
                    taskResource.appendSelectList(item);
                    continue;
                }
                if (!item.getModelId().equals(business.getRelatedId())) continue;
                businessResource.appendSelectList(item);
                continue;
            }
            if (NodeOperationEnum.REMOVE.getValue().equals(item.getActionName())) {
                if (item.getModelId().equals(task.getRelatedId())) {
                    taskResource.appendRemove(item);
                    continue;
                }
                if (!item.getModelId().equals(business.getRelatedId())) continue;
                businessResource.appendRemove(item);
                continue;
            }
            if (!NodeOperationEnum.SAVEORUPDATEBATCH.getValue().equals(item.getActionName())) continue;
            if (item.getModelId().equals(task.getRelatedId())) {
                taskResource.appendSaveBatch(item);
                continue;
            }
            if (!item.getModelId().equals(business.getRelatedId())) continue;
            businessResource.appendSaveBatch(item);
        }
        this.validateTaskResource(taskResource);
        this.validateBusinessResource(businessResource);
        return resourceMap;
    }

    private void validateTaskResource(Resource resource) {
        for (int i = 0; i < resource.getMethods().length; ++i) {
            if (resource.getMethods()[i] != null || i == 0) continue;
            throw new RuntimeException(" workFlow recall error : not found method for task table");
        }
    }

    private void validateBusinessResource(Resource resource) {
        if (resource.getUpdate() == null) {
            throw new RuntimeException(" workFlow recall error : not found update method for business table");
        }
    }

    public boolean processChange(ProcessChangeDto processChangeDto) {
        ProcessInfoDto processInfoDto = processChangeDto.getProcessInfoDto();
        Map<String, Resource> methodsByProcessKey = this.getMethodsByProcessKeyOrFormId(processInfoDto.getProcessKey(), processInfoDto.getFormId());
        if (HussarUtils.isEmpty(methodsByProcessKey)) {
            return false;
        }
        Resource businessResource = methodsByProcessKey.get(BUSINESS);
        if (businessResource == null) {
            return false;
        }
        Map bpmMap = BeanUtil.beanToMap((Object)processInfoDto);
        ModelTableMappingDTO model = businessResource.getModel();
        Map<String, Object> modelMap = this.businessMap2ModelMap(bpmMap, model);
        String[] processNodeInfoArr = this.analyzeProcessNode(processInfoDto.getProcessNodeList());
        modelMap.put(model.getColumnByPurpose(PurposeEnum.PROCESS_NODE).getColumnAlias(), processNodeInfoArr[0]);
        ModelColumnDto processNodeKeyColumn = model.getColumnByPurpose(PurposeEnum.PROCESS_NODE_KEY);
        if (HussarUtils.isNotEmpty((Object)processNodeKeyColumn)) {
            modelMap.put(processNodeKeyColumn.getColumnAlias(), processNodeInfoArr[1]);
        }
        String businessIdCondition = this.getConditionAlias(businessResource.getUpdate(), model.getColumnByPurpose(PurposeEnum.PRIMARY).getColumnId(), PurposeEnum.PRIMARY);
        modelMap.put(businessIdCondition, processInfoDto.getBusinessId());
        modelMap.put("tfModelId", model.getTfModelId());
        modelMap.put("noSecurityLevelWhere", true);
        try {
            this.nodeBusinessService.invoke(businessResource.getUpdate().getNodeName(), modelMap, null);
            modelMap.remove("noSecurityLevelWhere");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Resource taskResource = methodsByProcessKey.get(TASK);
        List updateTaskInfoDtoList = processChangeDto.getUpdateTaskInfoDto();
        processChangeDto.getRemoveTaskInfoDto().addAll(updateTaskInfoDtoList);
        this.deleteTaskInfoList(processChangeDto.getRemoveTaskInfoDto(), taskResource);
        processChangeDto.getTaskInfoDto().addAll(updateTaskInfoDtoList);
        this.addAndCompleteTaskInfo(processChangeDto.getTaskInfoDto(), taskResource);
        return true;
    }

    private Integer addAndCompleteTaskInfo(List<TaskInfoDto> taskInfoDtoList, Resource taskResource) {
        if (HussarUtils.isEmpty(taskInfoDtoList)) {
            return 0;
        }
        if (HussarUtils.isEmpty((Object)taskResource)) {
            return 0;
        }
        ArrayList<Map<String, Object>> tasks = new ArrayList<Map<String, Object>>();
        ModelTableMappingDTO model = taskResource.getModel();
        for (TaskInfoDto taskInfoDto : taskInfoDtoList) {
            Map bpmMap = BeanUtil.beanToMap((Object)taskInfoDto);
            Map<String, Object> modelMap = this.taskMap2ModelMap(bpmMap, model);
            modelMap.put(model.getColumnByPurpose(PurposeEnum.TASK_DEFINITION_KEY).getColumnAlias(), taskInfoDto.getTaskDefinitionKey());
            modelMap.put(model.getColumnByPurpose(PurposeEnum.TASK_DEFINITION_NAME).getColumnAlias(), taskInfoDto.getTaskDefinitionName());
            if (HussarUtils.isEmpty((Object)taskInfoDto.getEndTime())) {
                if (HussarUtils.isEmpty((Object)taskInfoDto.getUsers())) {
                    tasks.add(modelMap);
                    continue;
                }
                for (WorkflowUserDto user : taskInfoDto.getUsers()) {
                    HashMap<String, Object> newModelMap = new HashMap<String, Object>(modelMap);
                    newModelMap.put(model.getColumnByPurpose(PurposeEnum.ASSIGNEE).getColumnAlias(), user.getUserId());
                    tasks.add(newModelMap);
                }
                continue;
            }
            modelMap.put(model.getColumnByPurpose(PurposeEnum.END_TIME).getColumnAlias(), taskInfoDto.getEndTime());
            modelMap.put(model.getColumnByPurpose(PurposeEnum.TASK_TYPE).getColumnAlias(), taskInfoDto.getTaskType());
            modelMap.put(model.getColumnByPurpose(PurposeEnum.TASK_STATE).getColumnAlias(), taskInfoDto.getTaskState());
            modelMap.put(model.getColumnByPurpose(PurposeEnum.ASSIGNEE).getColumnAlias(), taskInfoDto.getAssignee());
            tasks.add(modelMap);
        }
        HashMap<String, String> batchParams = new HashMap<String, String>();
        batchParams.put("importList", JSON.toJSONString(tasks));
        batchParams.put("tfModelId", taskResource.getModel().getTfModelId());
        this.nodeBusinessService.invoke(taskResource.getSaveBatch().getNodeName(), batchParams, null);
        return tasks.size();
    }

    private void deleteTaskInfoList(List<TaskInfoDto> taskInfoDtoList, Resource taskResource) {
        if (HussarUtils.isEmpty(taskInfoDtoList)) {
            return;
        }
        NodeBusiness remove = taskResource.getRemove();
        HashMap<String, Object> params = new HashMap<String, Object>();
        ModelColumnDto columnByPurpose = taskResource.getModel().getColumnByPurpose(PurposeEnum.TASK_ID);
        String taskIdCondition = this.getConditionAlias(remove, columnByPurpose.getColumnId(), PurposeEnum.TASK_ID);
        params.put(taskIdCondition, taskInfoDtoList.stream().map(TaskInfoDto::getTaskId).collect(Collectors.toList()));
        params.put("tfModelId", taskResource.getModel().getTfModelId());
        try {
            this.nodeBusinessService.invoke(remove.getNodeName(), params, null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean processChangeList(ProcessChangeListDto processChangeListDto) {
        Map<String, Resource> methodsByProcessKey = this.getMethodsByProcessKeyOrFormId(processChangeListDto.getProcessKey(), processChangeListDto.getFormId());
        if (HussarUtils.isEmpty(methodsByProcessKey)) {
            return false;
        }
        Resource businessResource = methodsByProcessKey.get(BUSINESS);
        if (businessResource == null) {
            return false;
        }
        ModelTableMappingDTO model = businessResource.getModel();
        String businessIdCondition = this.getConditionAlias(businessResource.getUpdate(), model.getColumnByPurpose(PurposeEnum.PRIMARY).getColumnId(), PurposeEnum.PRIMARY);
        List processInfoDtoList = processChangeListDto.getProcessInfoDto();
        for (ProcessInfoDto processInfoDto : processInfoDtoList) {
            Map bpmMap = BeanUtil.beanToMap((Object)processInfoDto);
            Map<String, Object> modelMap = this.businessMap2ModelMap(bpmMap, model);
            String[] processNodeInfoArr = this.analyzeProcessNode(processInfoDto.getProcessNodeList());
            modelMap.put(model.getColumnByPurpose(PurposeEnum.PROCESS_NODE).getColumnAlias(), processNodeInfoArr[0]);
            ModelColumnDto processNodeKeyColumn = model.getColumnByPurpose(PurposeEnum.PROCESS_NODE_KEY);
            if (HussarUtils.isNotEmpty((Object)processNodeKeyColumn)) {
                modelMap.put(processNodeKeyColumn.getColumnAlias(), processNodeInfoArr[1]);
            }
            modelMap.put(businessIdCondition, processInfoDto.getBusinessId());
            modelMap.put("tfModelId", model.getTfModelId());
            modelMap.put("noSecurityLevelWhere", true);
            try {
                this.nodeBusinessService.invoke(businessResource.getUpdate().getNodeName(), modelMap, null);
                modelMap.remove("noSecurityLevelWhere");
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        Resource taskResource = methodsByProcessKey.get(TASK);
        this.addAndCompleteTaskInfo(processChangeListDto.getTaskInfoDto(), taskResource);
        return true;
    }

    static {
        bpmField2PurposeBusiness.put("businessId", PurposeEnum.PRIMARY);
        bpmField2PurposeBusiness.put("processKey", PurposeEnum.PROCESS_KEY);
        bpmField2PurposeBusiness.put("processState", PurposeEnum.PROCESS_STATE);
        bpmField2PurposeBusiness.put("processInstanceId", PurposeEnum.PROCESS_INST_ID);
        bpmField2PurposeBusiness.put("startTime", PurposeEnum.START_TIME);
        bpmField2PurposeBusiness.put("finishTime", PurposeEnum.FINISH_TIME);
        bpmField2PurposeTask.put("businessId", PurposeEnum.FOREIGN);
        bpmField2PurposeTask.put("processKey", PurposeEnum.PROCESS_KEY);
        bpmField2PurposeTask.put("processInstanceId", PurposeEnum.PROCESS_INST_ID);
        bpmField2PurposeTask.put("taskId", PurposeEnum.TASK_ID);
        bpmField2PurposeTask.put("taskDefinitionKey", PurposeEnum.TASK_DEFINITION_KEY);
        bpmField2PurposeTask.put("taskDefinitionName", PurposeEnum.TASK_DEFINITION_NAME);
        bpmField2PurposeTask.put("formKey", PurposeEnum.FORM_KEY);
        bpmField2PurposeTask.put("formDetailKey", PurposeEnum.FORM_DETAIL_KEY);
        bpmField2PurposeTask.put("startTime", PurposeEnum.START_TIME);
        bpmField2PurposeTask.put("createTime", PurposeEnum.TASK_CREATE_TIME);
        bpmField2PurposeTask.put("dueTime", PurposeEnum.DUE_TIME);
        bpmField2PurposeTask.put("taskState", PurposeEnum.TASK_STATE);
        bpmField2PurposeTask.put("taskType", PurposeEnum.TASK_TYPE);
    }

    private static class Resource {
        private ModelTableMappingDTO model;
        private NodeBusiness[] methods;

        public Resource(ModelTableMappingDTO model) {
            this.model = model;
            this.methods = new NodeBusiness[5];
        }

        public void appendUpdate(NodeBusiness method) {
            this.methods[0] = method;
        }

        public NodeBusiness getUpdate() {
            return this.methods[0];
        }

        public void appendInsert(NodeBusiness method) {
            this.methods[1] = method;
        }

        public NodeBusiness getInsert() {
            return this.methods[1];
        }

        public void appendSelectList(NodeBusiness method) {
            this.methods[2] = method;
        }

        public NodeBusiness getSelectList() {
            return this.methods[2];
        }

        public void appendRemove(NodeBusiness method) {
            this.methods[3] = method;
        }

        public NodeBusiness getRemove() {
            return this.methods[3];
        }

        public void appendSaveBatch(NodeBusiness method) {
            this.methods[4] = method;
        }

        public NodeBusiness getSaveBatch() {
            return this.methods[4];
        }

        public ModelTableMappingDTO getModel() {
            return this.model;
        }

        public void setModel(ModelTableMappingDTO model) {
            this.model = model;
        }

        public NodeBusiness[] getMethods() {
            return this.methods;
        }

        public void setMethods(NodeBusiness[] methods) {
            this.methods = methods;
        }
    }
}

