/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.engine.plugin.bpm.support.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.common.base.R;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.engine.api.dto.ModelColumnDto;
import com.jxdinfo.hussar.support.engine.api.service.UnderlyingService;
import com.jxdinfo.hussar.support.engine.core.annotations.EngineMethod;
import com.jxdinfo.hussar.support.engine.core.annotations.EngineService;
import com.jxdinfo.hussar.support.engine.core.enums.DataServiceType;
import com.jxdinfo.hussar.support.engine.core.enums.EngineExceptionEnum;
import com.jxdinfo.hussar.support.engine.core.enums.PurposeEnum;
import com.jxdinfo.hussar.support.engine.plugin.bpm.model.AddDelAssigneeDto;
import com.jxdinfo.hussar.support.engine.plugin.bpm.model.EndProcessDto;
import com.jxdinfo.hussar.support.engine.plugin.bpm.model.FormRecallDto;
import com.jxdinfo.hussar.support.engine.plugin.bpm.model.FormSaveStartDto;
import com.jxdinfo.hussar.support.engine.plugin.bpm.model.FormSubmitDto;
import com.jxdinfo.hussar.support.engine.plugin.bpm.model.FormSubmitRejectDto;
import com.jxdinfo.hussar.support.engine.plugin.bpm.model.FreeJumpDto;
import com.jxdinfo.hussar.support.engine.plugin.bpm.model.QueryNextAssigneeDto;
import com.jxdinfo.hussar.support.engine.plugin.bpm.model.RejectTaskDto;
import com.jxdinfo.hussar.support.engine.plugin.bpm.model.TaskEntrustDto;
import com.jxdinfo.hussar.support.engine.plugin.bpm.support.service.SingleBpmService;
import com.jxdinfo.hussar.support.engine.plugin.bpm.support.service.impl.BpmExecuteServiceImpl;
import com.jxdinfo.hussar.support.engine.plugin.bpm.support.service.impl.BpmExtendServiceImpl;
import com.jxdinfo.hussar.support.engine.plugin.bpm.util.BpmResultUtil;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.dml.DeleteEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.dml.DmlEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.dml.UpdateEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.support.service.SingleTableService;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.workflow.engine.bpm.processinst.dto.StartAndCompleteBatchDto;
import com.jxdinfo.hussar.workflow.engine.bpm.processinst.dto.StartAndCompleteDto;
import com.jxdinfo.hussar.workflow.engine.bpm.processinst.dto.StartProcessDto;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;

@EngineService(value="com.jxdinfo.hussar.support.engine.plugin.bpm.service.impl.singleBpm", type=DataServiceType.EXTENDED, des="\u5355\u8868\u5de5\u4f5c\u6d41\u56fa\u5316service")
public class SingleBpmServiceImpl
implements SingleBpmService,
UnderlyingService {
    private final BpmExecuteServiceImpl executeService;
    private final SingleTableService singleTableService;
    private final BpmExtendServiceImpl bpmExtendService;

    public SingleBpmServiceImpl(BpmExecuteServiceImpl executeService, SingleTableService singleTableService, BpmExtendServiceImpl bpmExtendService) {
        this.executeService = executeService;
        this.singleTableService = singleTableService;
        this.bpmExtendService = bpmExtendService;
    }

    @Override
    @EngineMethod(des="\u5355\u8868\u64a4\u56de\u6d41\u7a0b\u8868\u5355", paramDes={"\u66f4\u65b0\u5bf9\u8c61", "\u5355\u8868\u64a4\u56de\u6d41\u7a0b\u8868\u5355dto"}, returnDes="\u5de5\u4f5c\u6d41\u8fd4\u56de\u503c")
    public ApiResponse<Object> flowRecall(UpdateEntity entity, FormRecallDto recallDto) {
        ApiResponse<Object> withdrawState = this.executeService.withdrawState(recallDto.getTaskId());
        if (HussarUtils.isNotEmpty((Object)withdrawState.getData()) && Boolean.FALSE.equals(((JSONArray)withdrawState.getData()).get(0))) {
            return ApiResponse.fail((String)"\u5f53\u524d\u8282\u70b9\u4e0d\u80fd\u64a4\u56de");
        }
        ApiResponse result = this.saveForm(entity);
        if (!result.isSuccess()) {
            return result;
        }
        Object businessKey = result.getData();
        this.executeService.revokeTask(recallDto.getTaskId(), recallDto.getComment(), recallDto.getIsSubmit(), recallDto.getParamMap());
        return ApiResponse.success((Object)businessKey);
    }

    @Override
    @EngineMethod(des="\u5355\u8868\u6d41\u7a0b\u8868\u5355\u4fdd\u5b58", paramDes={"\u66f4\u65b0\u5bf9\u8c61", "\u5355\u8868\u8868\u5355\u4fdd\u5b58dto"}, returnDes="\u5de5\u4f5c\u6d41\u8fd4\u56de\u503c")
    public ApiResponse<Object> flowFormSaveStart(UpdateEntity entity, FormSaveStartDto formSaveStartDto) {
        ApiResponse result = this.saveForm(entity);
        if (!result.isSuccess()) {
            return result;
        }
        Object businessKey = result.getData();
        if (this.executeService.checkProcessInstByBusinessKey(String.valueOf(businessKey))) {
            StartProcessDto startProcessDto = this.executeService.getColumnRule((DmlEntity)entity);
            startProcessDto.setExternal(formSaveStartDto.isExternal());
            startProcessDto.setBusinessId(businessKey.toString());
            startProcessDto.setProcessKey(formSaveStartDto.getProcessDefinitionKey());
            this.executeService.startProcessInstanceByKey(startProcessDto);
        }
        return ApiResponse.success((Object)businessKey);
    }

    private ApiResponse saveForm(UpdateEntity entity) {
        HussarException.throwByNull((Object)entity, (Integer)EngineExceptionEnum.UPDATE_ENTITY_EMPTY.getExceptionCode(), (String)EngineExceptionEnum.UPDATE_ENTITY_EMPTY.getMessage());
        return this.singleTableService.saveOrUpdate(entity);
    }

    @Override
    @EngineMethod(des="\u5355\u8868\u5220\u9664\u6d41\u7a0b\u8868\u5355(\u4ec5\u5220\u9664\u672a\u542f\u52a8\u6d41\u7a0b\u548c\u8282\u70b9\u5904\u4e8e\u7b2c\u4e00\u8282\u70b9\u7684\u6d41\u7a0b)", paramAlias={"entity"}, paramDes={"\u4e3b\u952e"}, returnDes="\u5de5\u4f5c\u6d41\u8fd4\u56de\u503c")
    public ApiResponse<Object> flowFlagDeleteUnStart(UpdateEntity entity) {
        String businessId = HussarUtils.toStr(entity.getParam().get("id"), null);
        HussarException.throwByNull((Object)businessId, (Integer)EngineExceptionEnum.PRIMARY_KEY_EMPTY.getExceptionCode(), (String)EngineExceptionEnum.PRIMARY_KEY_EMPTY.getMessage());
        ApiResponse<Object> apiResponse = this.executeService.flowDeleteUnStart(businessId);
        if (apiResponse.isSuccess()) {
            this.flagRemove(entity);
            return ApiResponse.success((String)businessId);
        }
        return apiResponse;
    }

    @Override
    @EngineMethod(des="\u5355\u8868\u6d41\u7a0b\u8868\u5355\u5220\u9664", paramAlias={"entity"}, paramDes={"\u66f4\u65b0\u5bf9\u8c61"}, returnDes="\u5de5\u4f5c\u6d41\u8fd4\u56de\u503c")
    public ApiResponse<Object> flowFlagDelete(UpdateEntity entity) {
        this.flagRemove(entity);
        String businessId = HussarUtils.toStr(entity.getParam().get("id"), null);
        return this.executeService.deleteProcessInstanceByBusinessKey(businessId);
    }

    private boolean flagRemove(UpdateEntity entity) {
        HussarException.throwByNull((Object)entity, (Integer)EngineExceptionEnum.DELETE_ENTITY_EMPTY.getExceptionCode(), (String)EngineExceptionEnum.DELETE_ENTITY_EMPTY.getMessage());
        return this.singleTableService.flagRemove(entity);
    }

    @Override
    @EngineMethod(des="\u5355\u8868\u5220\u9664\u6d41\u7a0b\u8868\u5355(\u4ec5\u5220\u9664\u672a\u542f\u52a8\u6d41\u7a0b\u548c\u8282\u70b9\u5904\u4e8e\u7b2c\u4e00\u8282\u70b9\u7684\u6d41\u7a0b)", paramAlias={"entity"}, paramDes={"\u5220\u9664\u5bf9\u8c61"}, returnDes="\u5de5\u4f5c\u6d41\u8fd4\u56de\u503c")
    public ApiResponse<Object> flowDeleteUnStart(DeleteEntity deleteEntity) {
        String businessId = HussarUtils.toStr(deleteEntity.getParam().get("id"), null);
        HussarException.throwByNull((Object)businessId, (Integer)EngineExceptionEnum.PRIMARY_KEY_EMPTY.getExceptionCode(), (String)EngineExceptionEnum.PRIMARY_KEY_EMPTY.getMessage());
        ApiResponse<Object> apiResponse = this.executeService.flowDeleteUnStart(businessId);
        if (apiResponse.isSuccess()) {
            this.remove(deleteEntity);
            return ApiResponse.success((String)businessId);
        }
        return apiResponse;
    }

    @Override
    @EngineMethod(des="\u5355\u8868\u6d41\u7a0b\u8868\u5355\u5220\u9664", paramAlias={"entity"}, paramDes={"\u5220\u9664\u5bf9\u8c61"}, returnDes="\u5de5\u4f5c\u6d41\u8fd4\u56de\u503c")
    public ApiResponse<Object> flowDelete(DeleteEntity deleteEntity) {
        String businessId = HussarUtils.toStr(deleteEntity.getParam().get("id"), null);
        this.remove(deleteEntity);
        return this.executeService.deleteProcessInstanceByBusinessKey(businessId);
    }

    @Override
    @EngineMethod(des="\u5355\u8868\u6d41\u7a0b\u8868\u683c\u4fee\u6539", paramAlias={"updateRowId"}, paramDes={"\u4e1a\u52a1\u4e3b\u952e"}, returnDes="\u5de5\u4f5c\u6d41\u8fd4\u56de\u503c")
    public ApiResponse<JSONObject> flowTableUpdate(String updateRowId) {
        return this.executeService.validateEditAuthority(updateRowId);
    }

    @Override
    @EngineMethod(des="\u5355\u8868\u63d0\u4ea4\u6d41\u7a0b\u8868\u5355\uff08\u4f18\u5148\u63d0\u4ea4\u81f3\u9a73\u56de\u8282\u70b9\uff09", paramDes={"\u66f4\u65b0\u5bf9\u8c61", "\u5355\u8868\u63d0\u4ea4\uff08\u4f18\u5148\u63d0\u4ea4\u81f3\u9a73\u56de\u8282\u70b9\uff09dto"}, returnDes="\u5de5\u4f5c\u6d41\u8fd4\u56de\u503c")
    public ApiResponse<Object> flowSubmitReject(UpdateEntity entity, FormSubmitRejectDto arg) {
        ApiResponse result = this.saveForm(entity);
        if (!result.isSuccess()) {
            return result;
        }
        Object businessKey = result.getData();
        arg.setBusinessKey(businessKey);
        HashMap<String, List<String>> appointMap = new HashMap<String, List<String>>();
        HashMap<String, Object> variable = new HashMap<String, Object>();
        ModelColumnDto securityColumn = entity.getModel().getColumnByPurpose(PurposeEnum.SECURITY_LEVEL);
        if (HussarUtils.isNotEmpty((Object)securityColumn)) {
            variable.put("security_level", entity.getParam().get(securityColumn.getColumnName()));
        }
        StartProcessDto startProcessDto = this.executeService.getColumnRule((DmlEntity)entity);
        startProcessDto.setExternal(arg.getExternal());
        this.bpmExtendService.renderSubmitVariable(arg, businessKey.toString(), variable, appointMap, startProcessDto);
        if (HussarUtils.isEmpty((Object)arg.getTaskId())) {
            StartAndCompleteDto startAndCompleteDto = new StartAndCompleteDto(startProcessDto);
            startAndCompleteDto.setAppointAssignee(appointMap);
            startAndCompleteDto.setComment(arg.getComment());
            startAndCompleteDto.setParamMap(arg.getParamMap());
            this.executeService.startAndComplete(startAndCompleteDto);
        } else {
            this.executeService.completeLeapTask(arg.getTaskId(), arg.getComment(), appointMap, variable, arg.getExternal(), arg.getParamMap(), arg.getUserId());
        }
        return ApiResponse.success((Object)businessKey);
    }

    @Override
    @EngineMethod(des="\u5355\u8868\u9a73\u56de\u4e0a\u4e00\u8282\u70b9", paramDes={"\u66f4\u65b0\u5bf9\u8c61", "\u9a73\u56de\u4fe1\u606fdto"}, returnDes="\u5de5\u4f5c\u6d41\u8fd4\u56de\u503c")
    public ApiResponse<Object> prevNodeReject(UpdateEntity entity, RejectTaskDto arg) {
        ApiResponse result = this.saveForm(entity);
        if (!result.isSuccess()) {
            return result;
        }
        Object businessKey = result.getData();
        this.executeService.rejectTask(arg, "prev");
        return ApiResponse.success((Object)businessKey);
    }

    @Override
    @EngineMethod(des="\u5355\u8868\u63d0\u4ea4\u6d41\u7a0b\u8868\u5355", paramDes={"\u66f4\u65b0\u5bf9\u8c61", "\u5355\u8868\u63d0\u4ea4\u8868\u5355\u6570\u636edto"}, returnDes="\u5de5\u4f5c\u6d41\u8fd4\u56de\u503c")
    public ApiResponse<Object> flowSubmit(UpdateEntity entity, FormSubmitDto arg) {
        ApiResponse result = this.saveForm(entity);
        if (!result.isSuccess()) {
            return result;
        }
        Object businessKey = result.getData();
        HashMap<String, Object> variable = new HashMap<String, Object>();
        HashMap<String, List<String>> appointMap = new HashMap<String, List<String>>();
        ModelColumnDto securityColumn = entity.getModel().getColumnByPurpose(PurposeEnum.SECURITY_LEVEL);
        if (HussarUtils.isNotEmpty((Object)securityColumn)) {
            variable.put("security_level", entity.getParam().get(securityColumn.getColumnName()));
        }
        StartProcessDto startProcessDto = this.executeService.getColumnRule((DmlEntity)entity);
        startProcessDto.setExternal(arg.getExternal());
        this.bpmExtendService.renderSubmitVariable(arg, businessKey.toString(), variable, appointMap, startProcessDto);
        if (HussarUtils.isEmpty((Object)arg.getTaskId())) {
            StartAndCompleteDto startAndCompleteDto = new StartAndCompleteDto(startProcessDto);
            startAndCompleteDto.setAppointAssignee(appointMap);
            startAndCompleteDto.setComment(arg.getComment());
            startAndCompleteDto.setParamMap(arg.getParamMap());
            this.executeService.startAndComplete(startAndCompleteDto);
        } else {
            if (arg.getNodeParticipantSelect() != null) {
                variable.put("public_appoint_assignee", arg.getNodeParticipantSelect());
            }
            this.executeService.completeTask(arg.getTaskId(), arg.getComment(), appointMap, variable, arg.getExternal(), arg.getParamMap(), arg.getUserId());
        }
        return ApiResponse.success((Object)businessKey);
    }

    @Override
    @EngineMethod(des="\u5355\u8868\u6279\u91cf\u5220\u9664\u5de5\u4f5c\u6d41\u5b9e\u4f8b", paramAlias={"entity"}, paramDes={"\u5220\u9664\u5bf9\u8c61"}, returnDes="\u5de5\u4f5c\u6d41\u8fd4\u56de\u503c")
    public ApiResponse<Object> flowDeleteBatch(DeleteEntity deleteEntity) {
        String businessId = HussarUtils.toStr(deleteEntity.getParam().get("ids"), null);
        this.remove(deleteEntity);
        return this.executeService.deleteProcessInstanceByBusinessKeyList(businessId);
    }

    private boolean remove(DeleteEntity deleteEntity) {
        HussarException.throwByNull((Object)deleteEntity, (Integer)EngineExceptionEnum.DELETE_ENTITY_EMPTY.getExceptionCode(), (String)EngineExceptionEnum.DELETE_ENTITY_EMPTY.getMessage());
        return this.singleTableService.remove(deleteEntity);
    }

    @Override
    @EngineMethod(des="\u5355\u8868\u6279\u91cf\u5220\u9664\u5de5\u4f5c\u6d41\u5b9e\u4f8b", paramAlias={"entity"}, paramDes={"\u66f4\u65b0\u5bf9\u8c61"}, returnDes="\u5de5\u4f5c\u6d41\u8fd4\u56de\u503c")
    public ApiResponse<Object> flowFlagDeleteBatch(UpdateEntity entity) {
        String businessId = HussarUtils.toStr(entity.getParam().get("ids"), null);
        this.flagRemove(entity);
        return this.executeService.deleteProcessInstanceByBusinessKeyList(businessId);
    }

    @Override
    @EngineMethod(des="\u5355\u8868\u9a73\u56de\u4efb\u610f\u8282\u70b9", paramDes={"\u66f4\u65b0\u5bf9\u8c61", "\u9a73\u56de\u4fe1\u606fdto"}, returnDes="\u5de5\u4f5c\u6d41\u8fd4\u56de\u503c")
    public ApiResponse<Object> anyNodeReject(UpdateEntity entity, RejectTaskDto arg) {
        ApiResponse result = this.saveForm(entity);
        if (!result.isSuccess()) {
            return result;
        }
        Object businessKey = result.getData();
        this.executeService.rejectTask(arg, "any");
        return ApiResponse.success((Object)businessKey);
    }

    @Override
    @EngineMethod(des="\u5355\u8868\u4efb\u52a1\u8f6c\u529e", paramDes={"\u4efb\u52a1\u8f6c\u529edto"}, returnDes="\u5de5\u4f5c\u6d41\u8fd4\u56de\u503c")
    public ApiResponse<Object> taskEntrust(TaskEntrustDto arg) {
        return this.executeService.entrustTask(arg.getTaskId(), arg.getConsignorSelect(), arg.getComment(), arg.getParamMap());
    }

    @Override
    @EngineMethod(des="\u5355\u8868\u6d41\u7a0b\u7ec8\u6b62", paramDes={"\u5355\u8868\u6d41\u7a0b\u7ec8\u6b62dto"}, returnDes="\u5de5\u4f5c\u6d41\u8fd4\u56de\u503c")
    public ApiResponse<Object> endProcess(EndProcessDto arg) {
        return this.executeService.endProcess(arg.getTaskId(), arg.getComment());
    }

    @Override
    @EngineMethod(des="\u5355\u8868\u81ea\u7531\u9a73\u56de", paramDes={"\u66f4\u65b0\u5bf9\u8c61", "\u9a73\u56de\u4fe1\u606fdto"}, returnDes="\u5de5\u4f5c\u6d41\u8fd4\u56de\u503c")
    public ApiResponse<Object> freeReject(UpdateEntity entity, RejectTaskDto arg) {
        ApiResponse result = this.saveForm(entity);
        if (!result.isSuccess()) {
            return result;
        }
        Object businessKey = result.getData();
        this.executeService.rejectTask(arg, arg.getType());
        return ApiResponse.success((Object)businessKey);
    }

    @Override
    @EngineMethod(des="\u5355\u8868\u9a73\u56de\u81f3\u7b2c\u4e00\u8282\u70b9", paramDes={"\u66f4\u65b0\u5bf9\u8c61", "\u9a73\u56de\u4fe1\u606fdto"}, returnDes="\u5de5\u4f5c\u6d41\u8fd4\u56de\u503c")
    public ApiResponse<Object> initialNodeReject(UpdateEntity entity, RejectTaskDto arg) {
        ApiResponse result = this.saveForm(entity);
        if (!result.isSuccess()) {
            return result;
        }
        Object businessKey = result.getData();
        this.executeService.rejectTask(arg, "initial");
        return ApiResponse.success((Object)businessKey);
    }

    @Override
    @EngineMethod(des="\u5355\u8868\u83b7\u53d6\u4e0b\u4e00\u8282\u70b9\u53c2\u4e0e\u8005", paramDes={"\u83b7\u53d6\u4e0b\u4e00\u8282\u70b9\u53c2\u4e0e\u8005dto"}, returnDes="\u5de5\u4f5c\u6d41\u8fd4\u56de\u503c")
    public ApiResponse<Object> queryNextAssignee(QueryNextAssigneeDto arg) {
        return this.executeService.queryNextAssignee(arg.getProcessDefinitionKey(), arg.getTaskId(), arg.getNodeId());
    }

    @Override
    @EngineMethod(des="\u5355\u8868\u81ea\u7531\u8df3\u8f6c", paramDes={"\u5355\u8868\u81ea\u7531\u8df3\u8f6cDto"}, returnDes="\u5de5\u4f5c\u6d41\u8fd4\u56de\u503c")
    public ApiResponse<Object> freeJump(FreeJumpDto arg) {
        return this.executeService.freeJump(arg);
    }

    @Override
    @EngineMethod(des="\u5355\u8868\u52a0\u51cf\u7b7e", paramDes={"\u52a0\u51cf\u7b7eDto"}, returnDes="\u5de5\u4f5c\u6d41\u8fd4\u56de\u503c")
    public ApiResponse<Object> addOrDelAssignee(AddDelAssigneeDto arg) {
        return this.executeService.addOrDelAssignee(arg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @EngineMethod(des="\u5355\u8868\u6279\u91cf\u63d0\u4ea4\u6d41\u7a0b\u8868\u5355", paramDes={"\u66f4\u65b0\u5bf9\u8c61\u96c6\u5408(\u5305\u542b\u6d41\u7a0b\u53c2\u6570)"}, returnDes="\u5de5\u4f5c\u6d41\u8fd4\u56de\u503c")
    public ApiResponse<Object> flowSubmitBatch(List<UpdateEntity> entityList) {
        R result = new R();
        for (UpdateEntity updateEntity : entityList) {
            LinkedHashMap<String, List<String>> errMsg = new LinkedHashMap<String, List<String>>();
            String businessKey = updateEntity.getParam().get(updateEntity.getKeyProperty()).toString();
            try {
                FormSubmitDto dto = new FormSubmitDto().build(updateEntity.getParam().get("flowData"));
                this.bpmExtendService.flowSubmitSingle(updateEntity, dto, errMsg);
            }
            catch (Exception e) {
                errMsg.put("reason", Collections.singletonList(e.getMessage()));
            }
            finally {
                BpmResultUtil.handleBpmResult((R<String>)result, errMsg, businessKey);
            }
        }
        return ApiResponse.success((Object)result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @EngineMethod(des="\u5355\u8868\u6279\u91cf\u9a73\u56de\u6d41\u7a0b\u8868\u5355", paramDes={"\u66f4\u65b0\u5bf9\u8c61\u96c6\u5408(\u5305\u542b\u6d41\u7a0b\u53c2\u6570)"}, returnDes="\u5de5\u4f5c\u6d41\u8fd4\u56de\u503c")
    public ApiResponse<Object> flowRejectBatch(List<UpdateEntity> entityList) {
        R result = new R();
        for (UpdateEntity updateEntity : entityList) {
            LinkedHashMap<String, List<String>> errMsg = new LinkedHashMap<String, List<String>>();
            String businessKey = updateEntity.getParam().get(updateEntity.getKeyProperty()).toString();
            try {
                RejectTaskDto dto = new RejectTaskDto().build(updateEntity.getParam().get("flowData"));
                this.bpmExtendService.freeRejectSingle(updateEntity, dto, errMsg);
            }
            catch (Exception e) {
                errMsg.put("reason", Collections.singletonList(e.getMessage()));
            }
            finally {
                BpmResultUtil.handleBpmResult((R<String>)result, errMsg, businessKey);
            }
        }
        return ApiResponse.success((Object)result);
    }

    @Override
    @EngineMethod(des="\u5355\u8868\u542f\u52a8\u5e76\u63d0\u4ea4\u6d41\u7a0b\u8868\u5355", paramDes={"\u66f4\u65b0\u5bf9\u8c61\u96c6\u5408(\u5305\u542b\u6d41\u7a0b\u53c2\u6570)"}, returnDes="\u5de5\u4f5c\u6d41\u8fd4\u56de\u503c")
    public ApiResponse<Object> flowStartAndSubmitBatch(List<UpdateEntity> entityList) {
        StartAndCompleteBatchDto startAndCompleteBatchDto = new StartAndCompleteBatchDto();
        for (UpdateEntity updateEntity : entityList) {
            this.saveForm(updateEntity);
            this.bpmExtendService.renderStartAndCompleteBatchDto((DmlEntity)updateEntity, startAndCompleteBatchDto);
        }
        return this.executeService.startAndCompleteBatch(startAndCompleteBatchDto);
    }
}

