/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.engine.plugin.bpm.support.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.datasource.manager.api.entity.MetadataColumn;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.support.engine.api.dto.ModelTableMappingDTO;
import com.jxdinfo.hussar.support.engine.api.entity.ModelColumnsRules;
import com.jxdinfo.hussar.support.engine.core.model.dataTitle.MetaSummaryRule;
import com.jxdinfo.hussar.support.engine.core.model.dataTitle.MetaTitleRule;
import com.jxdinfo.hussar.support.engine.core.util.EngineUtil;
import com.jxdinfo.hussar.support.engine.plugin.bpm.model.AddDelAssigneeDto;
import com.jxdinfo.hussar.support.engine.plugin.bpm.model.FreeJumpDto;
import com.jxdinfo.hussar.support.engine.plugin.bpm.model.RejectTaskDto;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.dml.DmlEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.dml.InsertEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.dml.UpdateEntity;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.TaskAssigneeDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.TaskEntrustDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.TaskFreeJumpDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.TaskRejectDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.TaskRevokeDto;
import com.jxdinfo.hussar.workflow.engine.bpm.processinst.dto.StartAndCompleteBatchDto;
import com.jxdinfo.hussar.workflow.engine.bpm.processinst.dto.StartAndCompleteDto;
import com.jxdinfo.hussar.workflow.engine.bpm.processinst.dto.StartProcessDto;
import com.jxdinfo.hussar.workflow.engine.bpm.taskmanage.dto.CompleteTaskDto;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import com.jxdinfo.hussar.workflow.manage.engine.InstanceEngineService;
import com.jxdinfo.hussar.workflow.manage.engine.TaskEngineService;
import com.jxdinfo.hussar.workflow.upgrade.StandardTaskEngineApiService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@HussarDs(value="master")
public class BpmExecuteServiceImpl {
    static final String INITIAL = "initial";
    static final String PREV = "prev";
    static final String ANY = "any";
    static final String ADD = "add";
    static final String DEL = "del";
    static final String SUMMARY_PARAM = "param";
    static final String SUMMARY_COMPONENT = "components";
    @Autowired
    private StandardTaskEngineApiService standardTaskEngineApiService;

    ApiResponse<Object> endProcess(String taskId, String comment) {
        try {
            return this.getApiResponse(InstanceEngineService.endProcess((String)taskId, (String)this.getUserId(), (String)comment));
        }
        catch (Exception e) {
            throw new HussarException(e.getMessage(), (Throwable)e);
        }
    }

    ApiResponse<Object> deleteProcessInstanceByBusinessKey(String id) {
        try {
            return this.getApiResponse(InstanceEngineService.deleteProcessInstanceByBusinessKey((String)id));
        }
        catch (Exception e) {
            throw new HussarException(e.getMessage(), (Throwable)e);
        }
    }

    ApiResponse<Object> startProcessInstanceByKey(StartProcessDto startProcessDto) {
        try {
            startProcessDto.setUserId(HussarUtils.isEmpty((Object)startProcessDto.getUserId()) ? this.getUserId() : startProcessDto.getUserId());
            return this.getApiResponse(InstanceEngineService.startProcessInstanceByKey((StartProcessDto)startProcessDto));
        }
        catch (Exception e) {
            throw new HussarException(e.getMessage(), (Throwable)e);
        }
    }

    ApiResponse<Object> startAndComplete(StartAndCompleteDto startAndCompleteDto) {
        try {
            startAndCompleteDto.setUserId(HussarUtils.isEmpty((Object)startAndCompleteDto.getUserId()) ? this.getUserId() : startAndCompleteDto.getUserId());
            return this.getApiResponse(InstanceEngineService.startAndComplete((StartAndCompleteDto)startAndCompleteDto));
        }
        catch (Exception e) {
            throw new HussarException(e.getMessage(), (Throwable)e);
        }
    }

    public StartProcessDto getColumnRule(DmlEntity entity) {
        MetaTitleRule metaTitleRule;
        List params;
        List detailRule;
        Map param;
        ModelTableMappingDTO model;
        StartProcessDto startProcessDto = new StartProcessDto();
        if (entity instanceof UpdateEntity) {
            model = ((UpdateEntity)entity).getModel();
            param = ((UpdateEntity)entity).getParam();
        } else if (entity instanceof InsertEntity) {
            model = ((InsertEntity)entity).getModel();
            param = ((InsertEntity)entity).getParam();
        } else {
            return startProcessDto;
        }
        List titleRule = Optional.ofNullable(model).map(ModelTableMappingDTO::getAllTitleRule).orElse(null);
        if (HussarUtils.isNotEmpty((Object)titleRule)) {
            String processTitle = MetaTitleRule.parseAndFormat((String)((ModelColumnsRules)titleRule.get(0)).getRuleContent(), (String)model.getTfModelId(), (Map)param, model.getColumns().stream().map(MetadataColumn::getColumnAlias).collect(Collectors.toList()));
            if (processTitle != null && processTitle.length() > 1000) {
                processTitle = processTitle.substring(0, 1000);
            }
            startProcessDto.setProcessTitle(processTitle);
        }
        if (HussarUtils.isNotEmpty((Object)(detailRule = (List)Optional.ofNullable(model).map(ModelTableMappingDTO::getAllDataDetailRule).orElse(null))) && HussarUtils.isNotBlank((CharSequence)((ModelColumnsRules)detailRule.get(0)).getRuleContent()) && HussarUtils.isNotEmpty((Object)(params = (metaTitleRule = (MetaTitleRule)JSON.parseObject((String)((ModelColumnsRules)detailRule.get(0)).getRuleContent(), MetaTitleRule.class)).getParams()))) {
            boolean newData = params.stream().anyMatch(x -> x.getDetails() != null);
            if (newData) {
                List summaryValues = MetaSummaryRule.summaryFormat((String)((ModelColumnsRules)detailRule.get(0)).getRuleContent(), (Map)param);
                if (HussarUtils.isNotEmpty((Object)summaryValues)) {
                    startProcessDto.setDataDetail(JSON.toJSONString((Object)summaryValues));
                }
            } else {
                HashMap map = new HashMap();
                map.put(SUMMARY_PARAM, param);
                map.put(SUMMARY_COMPONENT, metaTitleRule);
                startProcessDto.setDataDetail(JSON.toJSONString(map));
            }
        }
        return startProcessDto;
    }

    public ApiResponse<Object> flowDeleteUnStart(String id) {
        ApiResponse<Object> apiResponse = this.validateDeleteByBusinessKey(id);
        if (apiResponse.isSuccess() && "1".equals(apiResponse.getData())) {
            this.deleteProcessInstanceByBusinessKey(id);
        }
        return apiResponse;
    }

    ApiResponse<Object> validateDeleteByBusinessKey(String id) {
        String result;
        BpmResponseResult responseResult;
        try {
            responseResult = InstanceEngineService.validateDeleteByBusinessKey((String)id);
        }
        catch (Exception e) {
            throw new HussarException(e.getMessage(), (Throwable)e);
        }
        String string = result = responseResult.getResult().get(0) == null ? "" : responseResult.getResult().get(0).toString();
        if ("2".equals(result)) {
            return ApiResponse.fail((String)responseResult.getMsg());
        }
        return ApiResponse.success((Object)result, (String)"");
    }

    ApiResponse<Object> withdrawState(String taskId) {
        try {
            return this.getApiResponse(TaskEngineService.withdrawState((String)taskId));
        }
        catch (Exception e) {
            throw new HussarException(e.getMessage(), (Throwable)e);
        }
    }

    ApiResponse<Object> revokeTask(String taskId, String comment, boolean isSubmit, Map<String, Object> paramMap) {
        try {
            TaskRevokeDto taskRevokeDto = new TaskRevokeDto();
            taskRevokeDto.setHistoricTaskId(taskId);
            taskRevokeDto.setUserId(this.getUserId());
            taskRevokeDto.setComment(comment);
            taskRevokeDto.setIsSubmit(isSubmit);
            taskRevokeDto.setParamMap(paramMap);
            return this.getApiResponse(this.standardTaskEngineApiService.revokeTask(taskRevokeDto));
        }
        catch (Exception e) {
            throw new HussarException(e.getMessage(), (Throwable)e);
        }
    }

    boolean checkProcessInstByBusinessKey(String businessKey) {
        try {
            return "1".equals(InstanceEngineService.checkProcessInstByBusinessKey((String)businessKey).getCode());
        }
        catch (Exception e) {
            throw new HussarException(e.getMessage(), (Throwable)e);
        }
    }

    ApiResponse<Object> completeTask(String taskId, String comment, Map<String, List<String>> appointMap, Map<String, Object> variable, Boolean isExternal, Map<String, Object> paramMap, String userId) {
        try {
            userId = HussarUtils.isEmpty((Object)userId) ? this.getUserId() : userId;
            CompleteTaskDto completeTaskDto = new CompleteTaskDto(taskId, userId, variable, comment, appointMap, true, false, paramMap);
            if (Boolean.TRUE.equals(isExternal)) {
                completeTaskDto.setIsAuditAuthority(false);
                return this.getApiResponse(((StandardTaskEngineApiService)SpringContextUtil.getBean(StandardTaskEngineApiService.class)).completeTask(completeTaskDto));
            }
            return this.getApiResponse(((StandardTaskEngineApiService)SpringContextUtil.getBean(StandardTaskEngineApiService.class)).completeTask(completeTaskDto));
        }
        catch (Exception e) {
            throw new HussarException(e.getMessage(), (Throwable)e);
        }
    }

    ApiResponse<Object> completeLeapTask(String taskId, String comment, Map<String, List<String>> appointMap, Map<String, Object> variable, Boolean isExternal, Map<String, Object> paramMap, String userId) {
        try {
            userId = HussarUtils.isEmpty((Object)userId) ? this.getUserId() : userId;
            CompleteTaskDto completeTaskDto = new CompleteTaskDto(taskId, userId, variable, comment, appointMap, true, true, paramMap);
            if (Boolean.TRUE.equals(isExternal)) {
                completeTaskDto.setIsAuditAuthority(false);
                return this.getApiResponse(((StandardTaskEngineApiService)SpringContextUtil.getBean(StandardTaskEngineApiService.class)).completeTask(completeTaskDto));
            }
            return this.getApiResponse(((StandardTaskEngineApiService)SpringContextUtil.getBean(StandardTaskEngineApiService.class)).completeTask(completeTaskDto));
        }
        catch (Exception e) {
            throw new HussarException(e.getMessage(), (Throwable)e);
        }
    }

    ApiResponse<Object> deleteProcessInstanceByBusinessKeyList(String ids) {
        try {
            return this.getApiResponse(InstanceEngineService.deleteProcessInstanceByBusinessKeyList((String)ids, (boolean)false));
        }
        catch (Exception e) {
            throw new HussarException(e.getMessage(), (Throwable)e);
        }
    }

    ApiResponse<JSONObject> validateEditAuthority(String updateRowId) {
        try {
            return InstanceEngineService.validateEditAuthority((String)updateRowId);
        }
        catch (Exception e) {
            throw new HussarException(e.getMessage(), (Throwable)e);
        }
    }

    ApiResponse<Object> rejectTask(RejectTaskDto arg, String type) {
        try {
            HashMap<String, String> map = null;
            if (arg.getSubmitToRejectNode() != null) {
                map = new HashMap<String, String>();
                map.put("submitToRejectNode", arg.getSubmitToRejectNode());
            }
            TaskRejectDto taskRejectDto = new TaskRejectDto();
            taskRejectDto.setTaskId(arg.getTaskId());
            taskRejectDto.setUserId(this.getUserId());
            taskRejectDto.setComment(arg.getComment());
            taskRejectDto.setAssignees(null);
            taskRejectDto.setIsSubmit(true);
            taskRejectDto.setVariable(map);
            taskRejectDto.setParamMap(arg.getParamMap());
            taskRejectDto.setAuditAuthority(true);
            if (INITIAL.equals(type)) {
                taskRejectDto.setIsSubProcessFirst(true);
                return this.getApiResponse(this.standardTaskEngineApiService.rejectToFirstTask(taskRejectDto));
            }
            if (PREV.equals(type)) {
                taskRejectDto.setCanRejectToMainProcess(false);
                return this.getApiResponse(this.standardTaskEngineApiService.rejectToLastTask(taskRejectDto));
            }
            taskRejectDto.setBackActivityId(arg.getRejectNode());
            return this.getApiResponse(this.standardTaskEngineApiService.rejectToAnyTask(taskRejectDto));
        }
        catch (Exception e) {
            throw new HussarException(e.getMessage(), (Throwable)e);
        }
    }

    ApiResponse<Object> queryNextAssignee(String processDefinitionKey, String taskId, String nodeId) {
        try {
            return this.getApiResponse(TaskEngineService.queryNextAssignee((String)processDefinitionKey, (String)taskId, (String)nodeId, (String)(HussarUtils.isBlank((CharSequence)taskId) ? this.getUserId() : null), null));
        }
        catch (Exception e) {
            throw new HussarException(e.getMessage(), (Throwable)e);
        }
    }

    ApiResponse<Object> taskAddAssignee(String taskId, String consignorSelect) {
        try {
            return this.getApiResponse(TaskEngineService.taskAddAssignee((String)taskId, (String)consignorSelect));
        }
        catch (Exception e) {
            throw new HussarException(e.getMessage(), (Throwable)e);
        }
    }

    ApiResponse<Object> entrustTask(String taskId, String consignorSelect, String comment, Map<String, Object> paramMap) {
        try {
            TaskEntrustDto taskEntrustDto = new TaskEntrustDto();
            taskEntrustDto.setTaskId(taskId);
            taskEntrustDto.setMandatary(consignorSelect);
            taskEntrustDto.setUserId(this.getUserId());
            taskEntrustDto.setComment(comment);
            taskEntrustDto.setParamMap(paramMap);
            return this.getApiResponse(TaskEngineService.entrustTask((TaskEntrustDto)taskEntrustDto));
        }
        catch (Exception e) {
            throw new HussarException(e.getMessage(), (Throwable)e);
        }
    }

    ApiResponse<Object> freeJump(FreeJumpDto freeJumpDto) {
        try {
            TaskFreeJumpDto taskFreeJumpDto = new TaskFreeJumpDto();
            taskFreeJumpDto.setTaskId(freeJumpDto.getTaskId());
            taskFreeJumpDto.setActivityId(freeJumpDto.getActivityId());
            taskFreeJumpDto.setActivityIds(freeJumpDto.getActivityIds());
            taskFreeJumpDto.setParamMap(freeJumpDto.getParamMap());
            taskFreeJumpDto.setAssigneeMap(freeJumpDto.getAssigneeMap());
            taskFreeJumpDto.setUserId(this.getUserId());
            taskFreeJumpDto.setIsSubmit(freeJumpDto.getSubmit().booleanValue());
            taskFreeJumpDto.setComment(freeJumpDto.getComment());
            taskFreeJumpDto.setAssignees(freeJumpDto.getAssignees());
            taskFreeJumpDto.setIsAuditAuthority(!Boolean.TRUE.equals(freeJumpDto.getExternal()));
            taskFreeJumpDto.setIsDefaultAssignee(true);
            return this.getApiResponse(TaskEngineService.freeJump((TaskFreeJumpDto)taskFreeJumpDto));
        }
        catch (Exception e) {
            throw new HussarException(e.getMessage(), (Throwable)e);
        }
    }

    ApiResponse<Object> addOrDelAssignee(AddDelAssigneeDto assigneeDto) {
        try {
            TaskAssigneeDto taskAssigneeDto = new TaskAssigneeDto();
            taskAssigneeDto.setTaskId(assigneeDto.getTaskId());
            taskAssigneeDto.setAssignees(assigneeDto.getAssignees());
            taskAssigneeDto.setUserId(this.getUserId());
            taskAssigneeDto.setComment(assigneeDto.getComment());
            taskAssigneeDto.setParamMap(assigneeDto.getParamMap());
            if (ADD.equals(assigneeDto.getType())) {
                return this.getApiResponse(this.standardTaskEngineApiService.multiInstanceAddAssignee(taskAssigneeDto));
            }
            return this.getApiResponse(this.standardTaskEngineApiService.multiInstanceDelAssignee(taskAssigneeDto));
        }
        catch (HussarException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HussarException(e.getMessage(), (Throwable)e);
        }
    }

    ApiResponse<Object> startAndCompleteBatch(StartAndCompleteBatchDto startAndCompleteBatchDto) {
        try {
            if (HussarUtils.isEmpty((Object)startAndCompleteBatchDto.getUserId())) {
                startAndCompleteBatchDto.setUserId(this.getUserId());
            }
            return this.getApiResponse(InstanceEngineService.startAndCompleteBatch((StartAndCompleteBatchDto)startAndCompleteBatchDto));
        }
        catch (Exception e) {
            throw new HussarException(e.getMessage(), (Throwable)e);
        }
    }

    private ApiResponse<Object> getApiResponse(BpmResponseResult responseResult) {
        HussarException.throwBy((!responseResult.isSuccess() ? 1 : 0) != 0, (String)responseResult.getMsg());
        return ApiResponse.success((Object)responseResult.getResult(), (String)responseResult.getMsg());
    }

    private String getUserId() {
        Long userId = EngineUtil.getUserId();
        return HussarUtils.toStr((Object)userId);
    }
}

