/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.engine.api.support.solidorg.service.impl;

import com.jxdinfo.hussar.platform.core.utils.ClassUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import com.jxdinfo.hussar.support.engine.api.dto.NodeBusinessVo;
import com.jxdinfo.hussar.support.engine.api.model.GhDataDto;
import com.jxdinfo.hussar.support.engine.api.support.solidorg.handler.EngineIntercepts;
import com.jxdinfo.hussar.support.engine.api.support.solidorg.handler.EngineParamHandler;
import com.jxdinfo.hussar.support.engine.api.support.solidorg.service.GainDataGhService;
import com.jxdinfo.hussar.support.engine.core.enums.EngineExceptionEnum;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;

public abstract class AbstractGainDataGhService
implements GainDataGhService {
    private EngineIntercepts engineIntercepts;

    @Override
    public Object startInvoke(NodeBusinessVo nodeBusinessVo, Map<String, Object> params) {
        Method method;
        GhDataDto ghDataDto = this.getGhDataDto(nodeBusinessVo, params);
        HussarException.throwBy((boolean)HussarUtils.isEmpty((Object)ghDataDto), (Integer)EngineExceptionEnum.CODE_FAIL.getExceptionCode(), (String)EngineExceptionEnum.CODE_FAIL.getMessage());
        String beanName = ghDataDto.getClassName();
        HussarException.throwBy((boolean)HussarUtils.isEmpty((Object)beanName), (Integer)EngineExceptionEnum.CLASS_NOT_FOUND_FAIL.getExceptionCode(), (String)EngineExceptionEnum.CLASS_NOT_FOUND_FAIL.getMessage());
        String methodName = ghDataDto.getMethodName();
        HussarException.throwBy((boolean)HussarUtils.isEmpty((Object)methodName), (Integer)EngineExceptionEnum.METHOD_NOT_FOUND_FAIL.getExceptionCode(), (String)EngineExceptionEnum.METHOD_NOT_FOUND_FAIL.getMessage());
        Object ownerBean = SpringContextUtil.getBean((String)beanName);
        HussarException.throwBy((boolean)HussarUtils.isEmpty((Object)ownerBean), (Integer)EngineExceptionEnum.CLASS_NOT_FOUND_FAIL.getExceptionCode(), (String)EngineExceptionEnum.CLASS_NOT_FOUND_FAIL.getMessage());
        Class<?> ownerClass = ownerBean.getClass();
        HussarException.throwBy((boolean)HussarUtils.isEmpty(ownerClass), (Integer)EngineExceptionEnum.METHOD_NOT_FOUND_FAIL.getExceptionCode(), (String)EngineExceptionEnum.METHOD_NOT_FOUND_FAIL.getMessage());
        this.intercept(nodeBusinessVo, params, 1);
        Object[] invokeParams = this.getParam(methodName, ghDataDto.getIns(), new Object[]{params, nodeBusinessVo});
        this.intercept(nodeBusinessVo, invokeParams, 2);
        try {
            method = ClassUtil.getMethod(ownerClass, (String)methodName, null);
        }
        catch (Exception e) {
            throw new HussarException(String.format("%s.%s\u65b9\u6cd5\u672a\u627e\u5230", ownerClass, ownerBean));
        }
        if (HussarUtils.isNotEmpty(nodeBusinessVo.getCallBackMethodName())) {
            HussarException.throwBy((boolean)HussarUtils.isEmpty((Object[])invokeParams), (Integer)EngineExceptionEnum.IN_PARAMS_ERROR.getExceptionCode(), (String)EngineExceptionEnum.IN_PARAMS_ERROR.getMessage());
            int length = invokeParams.length;
            invokeParams = Arrays.copyOf(invokeParams, length + 1);
            invokeParams[length] = nodeBusinessVo.getCallBackMethodName();
        }
        try {
            Object result = method.invoke(ownerBean, invokeParams);
            this.intercept(nodeBusinessVo, result, 3);
            return result;
        }
        catch (HussarException e) {
            throw e;
        }
        catch (InvocationTargetException e) {
            Throwable exception = e.getTargetException();
            throw new HussarException(exception.getMessage(), exception);
        }
        catch (Exception e) {
            throw new HussarException(e.getMessage(), (Throwable)e);
        }
    }

    private void intercept(NodeBusinessVo nodeBusinessVo, Object result, int type) {
        try {
            if (this.engineIntercepts != null && HussarUtils.isNotEmpty(this.engineIntercepts.getParamHandlers())) {
                for (EngineParamHandler handler : this.engineIntercepts.getParamHandlers()) {
                    if (!handler.isApply(nodeBusinessVo)) continue;
                    if (type == 1) {
                        handler.pmHandling((Map)result, nodeBusinessVo);
                        continue;
                    }
                    if (type == 2) {
                        handler.ghPmHandling((Object[])result, nodeBusinessVo);
                        continue;
                    }
                    if (type != 3) continue;
                    handler.resultHandling(result, nodeBusinessVo);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void setHandler(EngineIntercepts engineIntercepts) {
        this.engineIntercepts = engineIntercepts;
    }
}

