/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.choreo.api.model;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.datasource.manager.api.entity.MetadataColumn;
import com.jxdinfo.hussar.platform.core.sequence.builder.SeqBuilder;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import com.jxdinfo.hussar.support.choreo.api.dto.ApiNamingDto;
import com.jxdinfo.hussar.support.choreo.api.dto.SingleTableDto;
import com.jxdinfo.hussar.support.engine.api.model.DataserviceDto;
import com.jxdinfo.hussar.support.engine.api.model.NodeBusiness;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class PushBackCtx {
    private String modelName;
    private Map<String, MetadataColumn> columnMap;
    private Long modelId;
    public boolean isMs;
    private List<ApiNamingDto> apiNamingList;
    private List<NodeBusiness> businessList;
    private ApiNamingDto currentApiNameDto;
    private NodeBusiness firstNodeBusinessDto;

    public void build() {
        this.apiNamingList = new ArrayList<ApiNamingDto>();
        this.businessList = new ArrayList<NodeBusiness>();
    }

    public void setModelName(String modelName) {
        this.modelName = modelName;
    }

    private Long getId() {
        return this.getSqlBuilder().build().nextValue();
    }

    private SeqBuilder getSqlBuilder() {
        return (SeqBuilder)SpringContextUtil.getBean(SeqBuilder.class);
    }

    public void initApi(SingleTableDto dto, String nodeType, String uniqueCodeStart, Map<String, DataserviceDto> dataServiceDtoMap) {
        HussarException.throwByNull((Object)this.modelId, (String)"\u6a21\u578bid\u4e0d\u80fd\u4e3a\u7a7a");
        HussarException.throwByNull((Object)dto.getMethodName(), (String)"\u65b9\u6cd5\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        String uniqueCode = uniqueCodeStart + dto.getMethodName();
        HussarException.throwByNull((Object)((Object)dataServiceDtoMap.get(uniqueCode)), (String)(uniqueCode + "\u65b9\u6cd5\u672a\u627e\u5230"));
        Long nodeId = this.getId();
        String nodeName = this.getNodeName(dto.getBusinessId());
        this.addApiNaming(dto, nodeName);
        this.addNode(dto, nodeType, uniqueCodeStart, nodeId, nodeName);
    }

    private String getNodeName(String businessId) {
        return businessId.replace(" ", "").replace("/", ".").replace(":", "").replace("-", ".");
    }

    private void addNode(SingleTableDto dto, String nodeType, String uniqueCodeStart, Long nodeId, String nodeName) {
        NodeBusiness nodeBusiness = new NodeBusiness();
        nodeBusiness.setNodeId(nodeId);
        this.firstNodeBusinessDto = nodeBusiness;
        this.businessList.add(nodeBusiness);
        nodeBusiness.setModelId(this.modelId);
        nodeBusiness.setNodeClass(this.modelName);
        HussarException.throwBy((boolean)HussarUtils.isEmpty((Object)dto.getBusinessId()), (String)"URL\u4e0d\u80fd\u4e3a\u7a7a");
        String methodName = dto.getMethodName();
        HussarException.throwBy((boolean)HussarUtils.isEmpty((Object)methodName), (String)"\u65b9\u6cd5\u672a\u627e\u5230");
        String uniqueCode = uniqueCodeStart + methodName;
        nodeBusiness.setNodeName(nodeName);
        nodeBusiness.setNodeType(nodeType);
        nodeBusiness.setNodeDec(dto.getMethodDesc());
        nodeBusiness.setBusinessCode(dto.getBusinessCode());
        nodeBusiness.setDataServiceCode(uniqueCode);
        nodeBusiness.setActionName(methodName);
        nodeBusiness.setJsonParams(JSONObject.toJSONString((Object)dto));
    }

    private void addApiNaming(SingleTableDto dto, String nodeName) {
        ApiNamingDto apiNamingDto = new ApiNamingDto();
        apiNamingDto.setBusinessId(dto.getBusinessId());
        apiNamingDto.setBusinessType("HTTP");
        apiNamingDto.setBusinessName(dto.getMethodDesc());
        apiNamingDto.setServiceName(nodeName);
        this.apiNamingList.add(apiNamingDto);
        this.currentApiNameDto = apiNamingDto;
    }

    public void setModelId(Long modelId) {
        this.modelId = modelId;
    }

    public Map<String, MetadataColumn> getColumnMap() {
        return this.columnMap;
    }

    public void setColumnMap(Map<String, MetadataColumn> columnMap) {
        this.columnMap = columnMap;
    }

    public List<ApiNamingDto> getApiNamingList() {
        return this.apiNamingList;
    }

    public List<NodeBusiness> getBusinessList() {
        return this.businessList;
    }

    public void addApiNaming(ApiNamingDto apiNamingDto) {
        if (HussarUtils.isEmpty(this.apiNamingList)) {
            this.apiNamingList = new ArrayList<ApiNamingDto>();
        }
        this.apiNamingList.add(apiNamingDto);
    }

    public void addNodeBusiness(NodeBusiness nodeBusiness) {
        if (HussarUtils.isEmpty(this.businessList)) {
            this.businessList = new ArrayList<NodeBusiness>();
        }
        this.businessList.add(nodeBusiness);
    }

    public ApiNamingDto getCurrentApiNameDto() {
        return this.currentApiNameDto;
    }

    public NodeBusiness getFirstNodeBusinessDto() {
        return this.firstNodeBusinessDto;
    }
}

