/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.datasource.manager.plugin.ddl.util;

import com.jxdinfo.hussar.datasource.manager.plugin.ddl.handler.EngineParamTokenHandler;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.cache.Cache;
import com.jxdinfo.hussar.platform.core.utils.cache.CacheUtil;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.ognl.ASTChain;
import org.apache.ibatis.ognl.ASTProperty;
import org.apache.ibatis.ognl.Node;
import org.apache.ibatis.ognl.Ognl;
import org.apache.ibatis.ognl.OgnlException;
import org.apache.ibatis.parsing.GenericTokenParser;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.apache.ibatis.scripting.xmltags.ChooseSqlNode;
import org.apache.ibatis.scripting.xmltags.ForEachSqlNode;
import org.apache.ibatis.scripting.xmltags.IfSqlNode;
import org.apache.ibatis.scripting.xmltags.MixedSqlNode;
import org.apache.ibatis.scripting.xmltags.SqlNode;
import org.apache.ibatis.scripting.xmltags.StaticTextSqlNode;
import org.apache.ibatis.scripting.xmltags.TextSqlNode;
import org.apache.ibatis.scripting.xmltags.TrimSqlNode;
import org.apache.ibatis.scripting.xmltags.VarDeclSqlNode;
import org.apache.ibatis.scripting.xmltags.WhereSqlNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlNodeHandlerHelper {
    private static Logger LOGGER = LoggerFactory.getLogger(SqlNodeHandlerHelper.class);
    private static final Cache<String, Object> expressionCache = CacheUtil.newLFUCache((int)200);
    private static final String OBJ_NAME = Object.class.getName();
    private static Map<Class<? extends SqlNode>, SqlNodeHandler> sqlNodeMap = new HashMap<Class<? extends SqlNode>, SqlNodeHandler>();

    public static void apply(SqlNode sqlNode, Map<String, String> param, GenericTokenParser parser) {
        sqlNodeMap.get(sqlNode.getClass()).apply(sqlNode, param, parser);
    }

    private static void putIfAbsent(Map<String, String> param, String property, String name) {
        String value = param.get(property);
        if (value == null || OBJ_NAME.equals(value)) {
            param.put(property, name);
        }
    }

    private static <T> T getContents(SqlNode sqlNode, String key) {
        return (T)SqlNodeHandlerHelper.getMetaObject(sqlNode).getValue(key);
    }

    private static MetaObject getMetaObject(Object object) {
        return SystemMetaObject.forObject((Object)object);
    }

    private static List<String> getProperty(String expression) {
        Object node = expressionCache.get((Object)expression);
        if (node == null) {
            try {
                node = Ognl.parseExpression((String)expression);
            }
            catch (OgnlException e) {
                LOGGER.error(e.getMessage());
                throw new HussarException(e.getMessage());
            }
            expressionCache.put((Object)expression, node);
        }
        ArrayList<String> list = new ArrayList<String>();
        SqlNodeHandlerHelper.getPropertyByNode((Node)node, list);
        return list;
    }

    private static void getPropertyByNode(Node node, List<String> list) {
        if (node == null) {
            return;
        }
        if (node instanceof ASTProperty || node instanceof ASTChain) {
            list.add(node.toString());
            return;
        }
        int numChildren = node.jjtGetNumChildren();
        if (numChildren > 0) {
            for (int i = 0; i < numChildren; ++i) {
                SqlNodeHandlerHelper.getPropertyByNode(node.jjtGetChild(i), list);
            }
        }
    }

    static {
        sqlNodeMap.put(ChooseSqlNode.class, new ChooseSqlNodeHandler());
        sqlNodeMap.put(ForEachSqlNode.class, new ForEachSqlNodeHandler());
        sqlNodeMap.put(IfSqlNode.class, new IfSqlNodeHandler());
        sqlNodeMap.put(MixedSqlNode.class, new MixedSqlNodeHandler());
        sqlNodeMap.put(TextSqlNode.class, new TextSqlNodeHandler());
        sqlNodeMap.put(StaticTextSqlNode.class, new TextSqlNodeHandler());
        sqlNodeMap.put(TrimSqlNode.class, new TrimSqlNodeHandler());
        sqlNodeMap.put(VarDeclSqlNode.class, new VarDeclSqlNodeHandler());
        sqlNodeMap.put(WhereSqlNode.class, new TrimSqlNodeHandler());
    }

    public static class VarDeclSqlNodeHandler
    implements SqlNodeHandler {
        @Override
        public void apply(SqlNode sqlNode, Map<String, String> param, GenericTokenParser parser) {
            String name = (String)SqlNodeHandlerHelper.getContents(sqlNode, "name");
            String expression = (String)SqlNodeHandlerHelper.getContents(sqlNode, "expression");
            SqlNodeHandlerHelper.getProperty(expression).forEach(property -> SqlNodeHandlerHelper.putIfAbsent(param, property, OBJ_NAME));
            this.addBindName(name, parser);
            param.remove(name);
        }

        private void addBindName(String name, GenericTokenParser parser) {
            ((EngineParamTokenHandler)((Object)SqlNodeHandlerHelper.getMetaObject(parser).getValue("handler"))).addBindValue(name);
        }
    }

    public static class TrimSqlNodeHandler
    implements SqlNodeHandler {
        @Override
        public void apply(SqlNode sqlNode, Map<String, String> param, GenericTokenParser parser) {
            SqlNode contents = (SqlNode)SqlNodeHandlerHelper.getContents(sqlNode, "contents");
            SqlNodeHandlerHelper.apply(contents, param, parser);
        }
    }

    public static class TextSqlNodeHandler
    implements SqlNodeHandler {
        @Override
        public void apply(SqlNode sqlNode, Map<String, String> param, GenericTokenParser parser) {
            String text = (String)SqlNodeHandlerHelper.getContents(sqlNode, "text");
            parser.parse(text);
        }
    }

    public static class MixedSqlNodeHandler
    implements SqlNodeHandler {
        @Override
        public void apply(SqlNode sqlNode, Map<String, String> param, GenericTokenParser parser) {
            List contents = (List)SqlNodeHandlerHelper.getContents(sqlNode, "contents");
            contents.forEach(content -> SqlNodeHandlerHelper.apply(content, param, parser));
        }
    }

    public static class IfSqlNodeHandler
    implements SqlNodeHandler {
        @Override
        public void apply(SqlNode sqlNode, Map<String, String> param, GenericTokenParser parser) {
            SqlNode contents = (SqlNode)SqlNodeHandlerHelper.getContents(sqlNode, "contents");
            String test = (String)SqlNodeHandlerHelper.getContents(sqlNode, "test");
            SqlNodeHandlerHelper.getProperty(test).forEach(property -> SqlNodeHandlerHelper.putIfAbsent(param, property, OBJ_NAME));
            SqlNodeHandlerHelper.apply(contents, param, parser);
        }
    }

    public static class ForEachSqlNodeHandler
    implements SqlNodeHandler {
        @Override
        public void apply(SqlNode sqlNode, Map<String, String> param, GenericTokenParser parser) {
            SqlNode contents = (SqlNode)SqlNodeHandlerHelper.getContents(sqlNode, "contents");
            SqlNodeHandlerHelper.apply(contents, param, parser);
            String expression = (String)SqlNodeHandlerHelper.getContents(sqlNode, "collectionExpression");
            SqlNodeHandlerHelper.getProperty(expression).forEach(property -> SqlNodeHandlerHelper.putIfAbsent(param, property, List.class.getName()));
            String item = (String)SqlNodeHandlerHelper.getContents(sqlNode, "item");
            String index = (String)SqlNodeHandlerHelper.getContents(sqlNode, "index");
            if (HussarUtils.isNotEmpty((Object)item)) {
                param.remove(item);
            }
            if (HussarUtils.isNotEmpty((Object)index)) {
                param.remove(index);
            }
        }
    }

    public static class ChooseSqlNodeHandler
    implements SqlNodeHandler {
        @Override
        public void apply(SqlNode sqlNode, Map<String, String> param, GenericTokenParser parser) {
            SqlNode defaultSqlNode = (SqlNode)SqlNodeHandlerHelper.getContents(sqlNode, "defaultSqlNode");
            SqlNodeHandlerHelper.apply(defaultSqlNode, param, parser);
            List ifSqlNodes = (List)SqlNodeHandlerHelper.getContents(sqlNode, "ifSqlNodes");
            ifSqlNodes.forEach(content -> SqlNodeHandlerHelper.apply(content, param, parser));
        }
    }

    public static interface SqlNodeHandler {
        public void apply(SqlNode var1, Map<String, String> var2, GenericTokenParser var3);
    }
}

