/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.datasource.manager.plugin.ddl.adaptation;

import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.extension.toolkit.SqlParserUtils;
import com.jxdinfo.hussar.datasource.manager.api.entity.MetadataColumn;
import com.jxdinfo.hussar.datasource.manager.api.model.ColumnInfoDto;
import com.jxdinfo.hussar.datasource.manager.api.model.CustomSqlDto;
import com.jxdinfo.hussar.datasource.manager.api.model.CustomSqlEntity;
import com.jxdinfo.hussar.datasource.manager.plugin.ddl.action.BasicAction;
import com.jxdinfo.hussar.datasource.manager.plugin.ddl.action.factory.ActionFactory;
import com.jxdinfo.hussar.datasource.manager.plugin.ddl.adaptation.mysql.dao.MysqlDdlMapper;
import com.jxdinfo.hussar.datasource.manager.plugin.ddl.handler.EngineParamTokenHandler;
import com.jxdinfo.hussar.datasource.manager.plugin.ddl.util.EngineDdlSqlUtil;
import com.jxdinfo.hussar.datasource.manager.plugin.ddl.util.SqlNodeHandlerHelper;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.engine.core.model.EngineResultEntity;
import com.jxdinfo.hussar.support.engine.core.util.EngineUtil;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.Alias;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.select.Distinct;
import net.sf.jsqlparser.statement.select.GroupByElement;
import net.sf.jsqlparser.statement.select.Limit;
import net.sf.jsqlparser.statement.select.OrderByElement;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectBody;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import net.sf.jsqlparser.statement.select.SelectItem;
import net.sf.jsqlparser.statement.select.SetOperationList;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.mapping.ResultMapping;
import org.apache.ibatis.parsing.GenericTokenParser;
import org.apache.ibatis.scripting.xmltags.SqlNode;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CustomSqlAction
extends BasicAction {
    private static Logger LOGGER = LoggerFactory.getLogger(CustomSqlAction.class);
    protected static final List<SelectItem> COUNT_SELECT_ITEM = Collections.singletonList(CustomSqlAction.defaultCountSelectItem());
    @Resource
    private MysqlDdlMapper ddlMapper;
    @Autowired
    private SqlSessionFactory sqlSessionFactory;

    public CustomSqlAction() {
        ActionFactory.addAction(DbType.MYSQL.getDb(), this, CustomSqlAction.class);
    }

    @Override
    public void dealColumn(ColumnInfoDto column) {
    }

    public Object doCustomSql(CustomSqlDto tableInfoDto, String scriptSql) {
        try {
            List<Map<String, Object>> result;
            CustomSqlEntity select = new CustomSqlEntity();
            String textSql = this.getDynamicSqlSource(scriptSql, tableInfoDto);
            CheckSql checkSql = this.checkSql(textSql);
            select.setSql(textSql);
            select.setParseSql(tableInfoDto.isParseSql());
            select.setResultMap(this.buildResultMap(tableInfoDto));
            HashMap<String, List<Map<String, Object>>> map = new HashMap<String, List<Map<String, Object>>>();
            if (select.isParseSql()) {
                List<Map<String, Object>> param = this.getParam(scriptSql, tableInfoDto.getParams());
                map.put("param", param);
            }
            if (tableInfoDto.getPage() != null) {
                if (checkSql.isSetOperationList) {
                    String unionSql = String.format("SELECT * FROM (%s) uinTemp", textSql);
                    result = this.ddlMapper.customSql((IPage<?>)tableInfoDto.getPage(), unionSql, select, tableInfoDto.getParams());
                } else {
                    result = this.ddlMapper.customSql((IPage<?>)tableInfoDto.getPage(), textSql, select, tableInfoDto.getParams());
                }
            } else {
                result = this.ddlMapper.customSql(textSql, select, tableInfoDto.getParams());
            }
            if (select.isParseSql()) {
                if (select.getMetaData() == null) {
                    this.ddlMapper.customSql(textSql, select, tableInfoDto.getParams());
                }
                List columnList = select.getMetaData();
                map.put("columnList", columnList);
                map.put("data", result);
                return map;
            }
            return result;
        }
        catch (ClassNotFoundException e) {
            throw new HussarException((Throwable)e);
        }
    }

    public Object selectCount(CustomSqlDto tableInfoDto, String scriptSql) {
        String textSql = this.getDynamicSqlSource(scriptSql, tableInfoDto);
        this.checkSql(textSql);
        String countSql = this.autoCountSql(textSql);
        return this.ddlMapper.selectCount(countSql, tableInfoDto.getParams());
    }

    private CheckSql checkSql(String textSql) {
        try {
            CheckSql checkSql = new CheckSql();
            Statement statement = CCJSqlParserUtil.parse((String)EngineDdlSqlUtil.getGenericTokenParser(content -> "?").parse(textSql));
            if (statement instanceof Select) {
                checkSql.isSelect = true;
                if (((Select)statement).getSelectBody() instanceof SetOperationList) {
                    checkSql.isSetOperationList = true;
                }
                return checkSql;
            }
        }
        catch (JSQLParserException e) {
            throw new HussarException((Throwable)e);
        }
        throw new HussarException("SQL\u5f02\u5e38\u6216\u975e\u67e5\u8be2SQL\uff01");
    }

    private List<Map<String, Object>> getParam(String script, Map<String, Object> params) {
        script = String.format("<script>%s</script>", script);
        SqlNode sqlNode = EngineDdlSqlUtil.getSqlNode(script, this.getConfiguration());
        LinkedHashMap<String, String> columnMap = new LinkedHashMap<String, String>();
        GenericTokenParser parser = EngineDdlSqlUtil.getGenericTokenParser(new EngineParamTokenHandler(this.getConfiguration(), columnMap));
        SqlNodeHandlerHelper.apply(sqlNode, columnMap, parser);
        this.removeProperty(columnMap);
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        columnMap.forEach((k, v) -> {
            HashMap<String, String> column = new HashMap<String, String>();
            column.put("name", (String)k);
            column.put("javaType", (String)v);
            result.add(column);
        });
        return result;
    }

    private void removeProperty(Map<String, String> columnMap) {
        ArrayList<String> removeFiled = new ArrayList<String>();
        List<String> keys = Arrays.asList(".size", ".isEmpty", ".size()", ".isEmpty()");
        for (String c : columnMap.keySet()) {
            if (c != null && !keys.stream().anyMatch(key -> c.endsWith((String)key) && columnMap.containsKey(c.substring(0, c.length() - key.length())))) continue;
            removeFiled.add(c);
        }
        if (!removeFiled.isEmpty()) {
            for (String key2 : removeFiled) {
                columnMap.remove(key2);
            }
        }
    }

    private String getDynamicSqlSource(String script, CustomSqlDto customSqlDto) {
        CustomSqlDto sqlSource = EngineDdlSqlUtil.getDynamicSqlSource(script, customSqlDto.getParams(), "param");
        customSqlDto.setParams(sqlSource.getParams());
        customSqlDto.setSql(sqlSource.getSql());
        return sqlSource.getSql();
    }

    private String autoCountSql(String sql) {
        try {
            Select select = (Select)CCJSqlParserUtil.parse((String)sql);
            SelectBody selectBody = select.getSelectBody();
            if (selectBody instanceof SetOperationList) {
                return SqlParserUtils.getOriginalCountSql((String)sql);
            }
            PlainSelect plainSelect = (PlainSelect)select.getSelectBody();
            Distinct distinct = plainSelect.getDistinct();
            GroupByElement groupBy = plainSelect.getGroupBy();
            List orderBy = plainSelect.getOrderByElements();
            if (CollectionUtils.isNotEmpty((Collection)orderBy)) {
                boolean canClean = true;
                if (groupBy != null) {
                    canClean = false;
                }
                if (canClean) {
                    for (OrderByElement order : orderBy) {
                        Expression expression = order.getExpression();
                        if (expression instanceof Column || !expression.toString().contains("?")) continue;
                        canClean = false;
                        break;
                    }
                }
                if (canClean) {
                    plainSelect.setOrderByElements((List)null);
                }
            }
            for (SelectItem item : plainSelect.getSelectItems()) {
                if (!item.toString().contains("?")) continue;
                return SqlParserUtils.getOriginalCountSql((String)select.toString());
            }
            Limit limit = plainSelect.getLimit();
            if (distinct == null && null == groupBy && limit == null) {
                plainSelect.setSelectItems(COUNT_SELECT_ITEM);
                return select.toString();
            }
            return SqlParserUtils.getOriginalCountSql((String)select.toString());
        }
        catch (JSQLParserException jsqlParserException) {
            LOGGER.warn("optimize this sql to a count sql has exception, sql:\"" + sql + "\", exception:\n" + jsqlParserException.getCause());
        }
        catch (Exception exception) {
            LOGGER.warn("optimize this sql to a count sql has error, sql:\"" + sql + "\", exception:\n" + exception);
        }
        return SqlParserUtils.getOriginalCountSql((String)sql);
    }

    private static SelectItem defaultCountSelectItem() {
        Function function = new Function();
        function.setName("COUNT");
        function.setAllColumns(true);
        return new SelectExpressionItem((Expression)function).withAlias(new Alias("total"));
    }

    private Configuration getConfiguration() {
        return this.sqlSessionFactory.getConfiguration();
    }

    private ResultMap buildResultMap(CustomSqlDto tableInfoDto) throws ClassNotFoundException {
        String resultMapId = "custom." + EngineUtil.getId();
        Configuration configuration = this.getConfiguration();
        if (HussarUtils.isEmpty((Object)tableInfoDto.getColumnList())) {
            return new ResultMap.Builder(configuration, resultMapId, Map.class, new ArrayList()).build();
        }
        ArrayList<ResultMapping> resultMappings = new ArrayList<ResultMapping>();
        for (MetadataColumn column : tableInfoDto.getColumnList()) {
            resultMappings.add(new ResultMapping.Builder(this.getConfiguration(), column.getColumnAlias(), column.getColumnAlias(), Class.forName(column.getJavaType())).flags(new ArrayList()).build());
        }
        return new ResultMap.Builder(configuration, resultMapId, EngineResultEntity.class, resultMappings).build();
    }

    private static class CheckSql {
        boolean isSelect;
        boolean isSetOperationList;

        private CheckSql() {
        }
    }
}

