/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.datasource.manager.plugin.ddl.service.impl;

import com.baomidou.dynamic.datasource.ds.ItemDataSource;
import com.jxdinfo.hussar.datasource.manager.api.entity.MetadataTable;
import com.jxdinfo.hussar.datasource.manager.api.model.ColumnInfoDto;
import com.jxdinfo.hussar.datasource.manager.api.model.CustomSqlDto;
import com.jxdinfo.hussar.datasource.manager.api.model.MetadataParam;
import com.jxdinfo.hussar.datasource.manager.api.service.HussarDdlService;
import com.jxdinfo.hussar.datasource.manager.plugin.ddl.action.SelectTableAction;
import com.jxdinfo.hussar.datasource.manager.plugin.ddl.action.factory.ActionFactory;
import com.jxdinfo.hussar.datasource.manager.plugin.ddl.service.DsDdlService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.support.datasource.support.service.DynamicDatasourceService;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Service;

@Service
public class HussarDdlServiceImpl
implements HussarDdlService {
    @Autowired
    private DynamicDatasourceService datasourceService;
    @Autowired
    private DsDdlService dsDdlService;
    private ConcurrentHashMap<String, String> lockMap = new ConcurrentHashMap();

    public void createTable(@NonNull MetadataParam paramData) {
        HussarException.throwByNull((Object)paramData, (String)"\u53c2\u6570\u5f02\u5e38");
        String poolName = this.getPoolName(paramData);
        this.dsDdlService.createTable(paramData, poolName);
    }

    public void editTable(@NonNull MetadataParam paramData, @NonNull List<ColumnInfoDto> oldColumnInfo, String oldTableName) {
        HussarException.throwByNull((Object)paramData, (String)"\u53c2\u6570\u5f02\u5e38");
        HussarException.throwBy((boolean)HussarUtils.isEmpty(oldColumnInfo), (String)"\u53c2\u6570\u5f02\u5e38");
        String poolName = this.getPoolName(paramData);
        this.dsDdlService.editTable(paramData, oldColumnInfo, oldTableName, poolName);
    }

    public String getDdlSql(@NonNull MetadataParam paramData, List<ColumnInfoDto> oldColumnInfo, String oldTableName) throws IOException {
        HussarException.throwByNull((Object)paramData, (String)"\u53c2\u6570\u5f02\u5e38");
        String poolName = this.getPoolName(paramData);
        return this.dsDdlService.getDdlSql(paramData, oldColumnInfo, oldTableName, poolName);
    }

    private String getPoolName(@NonNull MetadataParam paramData) {
        return Optional.ofNullable(paramData.getTableInfo()).map(MetadataTable::getPollName).orElse("");
    }

    @HussarDs(value="#connName")
    public List<MetadataTable> selectTablesByTableNames(@NonNull List<String> tableNames, String connName) {
        HussarException.throwBy((boolean)HussarUtils.isEmpty(tableNames), (String)"\u53c2\u6570\u5f02\u5e38");
        return ((SelectTableAction)ActionFactory.getAction(this.getCurrentDatasource().getDbType().getDb(), SelectTableAction.class)).selectTablesByTableNames(tableNames);
    }

    public Object customSql(CustomSqlDto customSqlDto) {
        return this.dsDdlService.customSql(customSqlDto, customSqlDto.getSql(), customSqlDto.getPollName());
    }

    public Object selectCount(CustomSqlDto customSqlDto) {
        return this.dsDdlService.selectCount(customSqlDto, customSqlDto.getSql(), customSqlDto.getPollName());
    }

    private ItemDataSource getCurrentDatasource() {
        return this.datasourceService.getCurrentDatasource();
    }
}

