/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.datasource.manager.plugin.ddl.service.impl;

import com.baomidou.dynamic.datasource.ds.ItemDataSource;
import com.baomidou.mybatisplus.annotation.DbType;
import com.jxdinfo.hussar.datasource.manager.api.entity.MetadataTable;
import com.jxdinfo.hussar.datasource.manager.api.model.ColumnInfoDto;
import com.jxdinfo.hussar.datasource.manager.api.model.CustomSqlDto;
import com.jxdinfo.hussar.datasource.manager.api.model.MetadataParam;
import com.jxdinfo.hussar.datasource.manager.plugin.ddl.action.CreateTableAction;
import com.jxdinfo.hussar.datasource.manager.plugin.ddl.action.EditTableAction;
import com.jxdinfo.hussar.datasource.manager.plugin.ddl.action.EditTableSqlAction;
import com.jxdinfo.hussar.datasource.manager.plugin.ddl.action.factory.ActionFactory;
import com.jxdinfo.hussar.datasource.manager.plugin.ddl.adaptation.CustomSqlAction;
import com.jxdinfo.hussar.datasource.manager.plugin.ddl.service.DsDdlService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.support.datasource.support.service.DynamicDatasourceService;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DsDdlServiceImpl
implements DsDdlService {
    @Autowired
    private DynamicDatasourceService datasourceService;

    @Override
    @HussarDs(value="#connName")
    public void createTable(MetadataParam paramData, String connName) {
        ItemDataSource currentDatasource = this.getCurrentDatasource();
        paramData.setSchemaName(currentDatasource.getSchemaName());
        ((CreateTableAction)ActionFactory.getAction(currentDatasource.getDbType().getDb(), CreateTableAction.class)).doCreateTable(paramData);
    }

    @Override
    @HussarDs(value="#connName")
    public void editTable(MetadataParam paramData, List<ColumnInfoDto> oldColumnInfo, String oldTableName, String connName) {
        if (HussarUtils.isEmpty((Object)oldTableName)) {
            oldTableName = Optional.ofNullable(paramData.getTableInfo()).map(MetadataTable::getTableName).orElseThrow(() -> new HussarException("\u8868\u540d\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        ItemDataSource currentDatasource = this.getCurrentDatasource();
        paramData.setSchemaName(currentDatasource.getSchemaName());
        ((EditTableAction)ActionFactory.getAction(currentDatasource.getDbType().getDb(), EditTableAction.class)).doEditTable(paramData, oldColumnInfo, oldTableName);
    }

    @Override
    @HussarDs(value="#connName")
    public String getDdlSql(MetadataParam paramData, List<ColumnInfoDto> oldColumnInfo, String oldTableName, String connName) throws IOException {
        ItemDataSource currentDatasource = this.getCurrentDatasource();
        paramData.setSchemaName(currentDatasource.getSchemaName());
        return ((EditTableSqlAction)ActionFactory.getAction(currentDatasource.getDbType().getDb(), EditTableSqlAction.class)).doEditTableSql(paramData, oldColumnInfo, oldTableName);
    }

    @Override
    @HussarDs(value="#connName")
    public Object customSql(CustomSqlDto tableInfoDto, String sql, String connName) {
        return ((CustomSqlAction)ActionFactory.getAction(DbType.MYSQL.getDb(), CustomSqlAction.class)).doCustomSql(tableInfoDto, sql);
    }

    @Override
    @HussarDs(value="#connName")
    public Object selectCount(CustomSqlDto tableInfoDto, String sql, String connName) {
        return ((CustomSqlAction)ActionFactory.getAction(DbType.MYSQL.getDb(), CustomSqlAction.class)).selectCount(tableInfoDto, sql);
    }

    private ItemDataSource getCurrentDatasource() {
        return this.datasourceService.getCurrentDatasource();
    }
}

