/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.datasource.manager.plugin.ddl.util;

import com.jxdinfo.hussar.datasource.manager.api.model.CustomSqlDto;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import com.jxdinfo.hussar.platform.core.utils.cache.Cache;
import com.jxdinfo.hussar.platform.core.utils.cache.CacheUtil;
import java.util.HashMap;
import java.util.Map;
import org.apache.ibatis.builder.xml.XMLMapperEntityResolver;
import org.apache.ibatis.parsing.GenericTokenParser;
import org.apache.ibatis.parsing.TokenHandler;
import org.apache.ibatis.parsing.XNode;
import org.apache.ibatis.parsing.XPathParser;
import org.apache.ibatis.scripting.xmltags.DynamicContext;
import org.apache.ibatis.scripting.xmltags.DynamicSqlSource;
import org.apache.ibatis.scripting.xmltags.SqlNode;
import org.apache.ibatis.scripting.xmltags.XMLScriptBuilder;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSessionFactory;
import org.xml.sax.EntityResolver;

public class EngineDdlSqlUtil {
    private static final SqlSessionFactory sqlSessionFactory = (SqlSessionFactory)SpringContextUtil.getBean(SqlSessionFactory.class);
    private static final Cache<String, SqlNode> cache = CacheUtil.newLFUCache((int)30, (long)300000L);

    public static CustomSqlDto getDynamicSqlSource(String script, Map<String, Object> params, String prefix) {
        script = String.format("<script>%s</script>", script);
        Configuration configuration = sqlSessionFactory.getConfiguration();
        SqlNode sqlNode = EngineDdlSqlUtil.getSqlNode(script, configuration);
        DynamicContext context = new DynamicContext(configuration, params);
        sqlNode.apply(context);
        if (params == null) {
            params = new HashMap<String, Object>();
        }
        context.getBindings().forEach(params::put);
        CustomSqlDto customSqlDto = new CustomSqlDto();
        customSqlDto.setParams(params);
        if (HussarUtils.isNotEmpty((Object)prefix)) {
            GenericTokenParser parser = EngineDdlSqlUtil.getGenericTokenParser(content -> "#{" + prefix + "." + content + "}");
            customSqlDto.setSql(parser.parse(context.getSql()));
        } else {
            customSqlDto.setSql(context.getSql());
        }
        return customSqlDto;
    }

    public static GenericTokenParser getGenericTokenParser(TokenHandler handler) {
        return new GenericTokenParser("#{", "}", handler);
    }

    public static SqlNode getSqlNode(String script) {
        return EngineDdlSqlUtil.getSqlNode(script, sqlSessionFactory.getConfiguration());
    }

    public static SqlNode getSqlNode(String script, Configuration configuration) {
        SqlNode sqlNode = (SqlNode)cache.get((Object)script);
        if (sqlNode == null) {
            XPathParser parser = new XPathParser(script, false, configuration.getVariables(), (EntityResolver)new XMLMapperEntityResolver());
            XNode xNode = parser.evalNode("/script");
            XMLScriptBuilder builder = new XMLScriptBuilder(configuration, xNode, null);
            configuration.newMetaObject((Object)builder).setValue("isDynamic", (Object)true);
            DynamicSqlSource sqlSource = (DynamicSqlSource)builder.parseScriptNode();
            sqlNode = (SqlNode)configuration.newMetaObject((Object)sqlSource).getValue("rootSqlNode");
            cache.put((Object)script, (Object)sqlNode);
        }
        return sqlNode;
    }
}

