<#import './ddl_common_sql' as c>
<#if oldTableName?? && oldTableName != tableName>
    ALTER TABLE "${oldTableName}" RENAME TO "${tableName}";
</#if>
<#if tableComment??>COMMENT ON TABLE  "${tableName}" IS '${tableComment}';</#if>
<#-- 新增列-->
<#if addCols?? && addCols?size gt 0>
    ALTER TABLE "${tableName}" <#list addCols! as column>ADD "${column.columnName!}" ${column.dataType!} <#if column.defaultValue??>DEFAULT '${column.defaultValue!}'</#if> <#if column.required?? && column.required == '1'>NOT NULL</#if><#sep>,</#list>;
<#-- 字段描述-->
    <@c.cComment tableName=tableName columns=addCols/>
</#if>
<#-- 删除主键-->
<#if dropPk && havePk>ALTER TABLE "${tableName}" DROP CONSTRAINT ${otherParams.primaryKey};</#if>
<#-- 修改列-->
<#if editCols?? && editCols?size gt 0>
    <#list editCols! as column>
        <#if column.oldColumnName?? && column.columnName?lower_case != column.oldColumnName?lower_case>
            ALTER TABLE "${tableName}" RENAME COLUMN "${column.oldColumnName}" TO "${column.columnName}";
        </#if>
    </#list>

    <#list editCols! as column>ALTER TABLE "${tableName}" ALTER COLUMN "${column.columnName}" type ${column.dataType} using "${column.columnName}"::${column.dataType} <#if column.needChangeIsRequired?? && column.needChangeIsRequired><#if column.required?? && column.required == '1'>,ALTER COLUMN "${column.columnName}" SET NOT NULL<#else>,ALTER COLUMN "${column.columnName}" DROP NOT NULL</#if></#if> <#if column.defaultValue??>,ALTER COLUMN "${column.columnName}" SET DEFAULT '${column.defaultValue}'</#if><#sep>;</#list>;
<#-- 字段描述-->
    <@c.cComment tableName=tableName columns=editCols/>
</#if>
<#-- 修改主键-->
<#if dropPk && needSetPk>ALTER TABLE "${tableName}" ADD PRIMARY KEY (<#list pkColumnName! as colName>"${colName}"<#sep>,</#list>);</#if>
<#-- 删除列-->
<#if delCols?? && delCols?size gt 0>
    ALTER TABLE "${tableName}"
    <#list delCols! as column>DROP COLUMN "${column.columnName}"<#sep>,</#list>;
</#if>