<#--修改表名-->
<#if oldTableName?? && oldTableName != tableName>
exec sp_rename '${oldTableName}' ,${tableName} ,'OBJECT'
go
</#if>
<#-- 修改表注释-->
<#if tableComment??>
DECLARE @NAME SYSNAME
SET @NAME = user
if exists(select *
from sys.tables t
left join sys.extended_properties p on t.object_id = p.major_id and p.minor_id = 0
where t.schema_id = schema_id() and t.name = '${tableName}' and p.value is not null)
exec sp_updateextendedproperty 'MS_Description', '${tableComment!}', 'SCHEMA', @NAME, 'TABLE', '${tableName}'
else
exec sp_addextendedproperty 'MS_Description', '${tableComment}', 'SCHEMA', @NAME, 'TABLE', '${tableName}'
go
</#if>
<#-- 新增列-->
<#if addCols?? && addCols?size gt 0>
ALTER TABLE "${tableName}" ADD <#list addCols! as column>"${column.columnName!}" ${column.dataType!} <#if column.defaultValue??>DEFAULT '${column.defaultValue!}'</#if> <#if column.required?? && column.required == '1'>NOT NULL</#if><#sep>,</#list>
go
</#if>
<#-- 修改主键-->
<#if dropPk && havePk>
DECLARE @NAME SYSNAME
SELECT TOP 1 @NAME=NAME
FROM SYS.OBJECTS WITH (NOLOCK)
WHERE TYPE_DESC = 'PRIMARY_KEY_CONSTRAINT'
AND PARENT_OBJECT_ID = (
SELECT OBJECT_ID
FROM SYS.OBJECTS WITH (NOLOCK)
WHERE NAME = '${tableName}' and schema_id = schema_id())
DECLARE
@ALTERSQL NVARCHAR(MAX)
SET @ALTERSQL = 'ALTER TABLE "${tableName}"
DROP CONSTRAINT ' + @NAME + ''
EXEC SP_EXECUTESQL @ALTERSQL
go
</#if>
<#-- 修改列-->
<#if editCols?? && editCols?size gt 0>
<#list editCols! as column>
<#if column.oldColumnName?? && column.columnName?lower_case != column.oldColumnName?lower_case>
exec sp_rename '${tableName}.${column.oldColumnName}', ${column.columnName}, 'COLUMN'
go
</#if>
ALTER TABLE "${tableName}" ALTER COLUMN "${column.columnName}" ${column.dataType} <#if column.required?? && column.required == '1'>NOT NULL</#if> <#if column.defaultValue??>DEFAULT '${column.defaultValue!}'</#if>
go
</#list>
</#if>
<#if dropPk && needSetPk>
ALTER TABLE "${tableName}" ADD PRIMARY KEY (<#list pkColumnName! as colName>"${colName}"<#sep>,</#list>)
go
</#if>
<#if (addCols?? && addCols?size gt 0) || (editCols?? && editCols?size gt 0)>
DECLARE @NAME SYSNAME
SET @NAME=schema_name()
<#if addCols?? && addCols?size gt 0>
<#-- 字段描述-->
<#list addCols! as column>
<#if column?? && column.columnComment??>
exec sp_addextendedproperty 'MS_Description', '${column.columnComment}', 'SCHEMA', @NAME, 'TABLE', '${tableName}', 'COLUMN', '${column.columnName}'
</#if>
</#list>
</#if>
<#if editCols?? && editCols?size gt 0>
<#list editCols! as column>
<#-- 字段描述-->
<#if column?? && column.columnComment??>
if exists(select * from sys.tables t
left join sys.columns c on t.object_id = c.object_id
left join sys.extended_properties p on t.object_id = p.major_id and c.column_id = p.minor_id
where t.schema_id = schema_id() and t.name = '${tableName}' and c.name = '${column.columnName}' and p.value is not null)
exec sp_updateextendedproperty 'MS_Description', '${column.columnComment}', 'SCHEMA', @NAME, 'TABLE', '${tableName}', 'COLUMN', '${column.columnName}'
else
exec sp_addextendedproperty 'MS_Description', '${column.columnComment}', 'SCHEMA', @NAME, 'TABLE', '${tableName}', 'COLUMN', '${column.columnName}'
</#if>
</#list>
</#if>
go
</#if>
<#-- 删除列-->
<#if delCols?? && delCols?size gt 0>
ALTER TABLE "${tableName}" DROP COLUMN
<#list delCols! as column>"${column.columnName}"<#sep>,</#list>
go
</#if>

