/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.datasource.manager.plugin.ddl.adaptation.sqlserver;

import com.baomidou.mybatisplus.annotation.DbType;
import com.jxdinfo.hussar.datasource.manager.api.model.ColumnInfoDto;
import com.jxdinfo.hussar.datasource.manager.api.model.UpdateTableDto;
import com.jxdinfo.hussar.datasource.manager.plugin.ddl.action.EditTableAction;
import com.jxdinfo.hussar.datasource.manager.plugin.ddl.action.factory.ActionFactory;
import com.jxdinfo.hussar.datasource.manager.plugin.ddl.adaptation.sqlserver.dao.SqlServerDdlMapper;
import com.jxdinfo.hussar.datasource.manager.plugin.ddl.mapper.DdlMapper;
import com.jxdinfo.hussar.datasource.manager.plugin.ddl.util.ColumnUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SqlServerEditTableAction
extends EditTableAction {
    private static Logger LOGGER = LoggerFactory.getLogger(SqlServerEditTableAction.class);
    @Resource
    private SqlServerDdlMapper ddlMapper;

    public SqlServerEditTableAction() {
        ActionFactory.addAction(DbType.SQL_SERVER.getDb(), this, EditTableAction.class);
        ActionFactory.addAction(DbType.SQL_SERVER2005.getDb(), this, EditTableAction.class);
    }

    @Override
    public DdlMapper getMapper() {
        return this.ddlMapper;
    }

    @Override
    public void edit(UpdateTableDto updateTableDto, String newTableName) {
        if (HussarUtils.isNotEmpty((Object)updateTableDto.getEditCols())) {
            for (ColumnInfoDto editColumn : updateTableDto.getEditCols()) {
                if (HussarUtils.isNotEmpty((Object)editColumn.getOldColumnName()) && !editColumn.getColumnName().equalsIgnoreCase(editColumn.getOldColumnName())) {
                    this.ddlMapper.renameColumnName(newTableName, editColumn.getOldColumnName(), editColumn.getColumnName());
                }
                this.ddlMapper.editTableCol(newTableName, editColumn);
                if (!HussarUtils.isNotEmpty((Object)editColumn.getColumnComment())) continue;
                this.ddlMapper.updateColumnComment2(newTableName, editColumn.getColumnName(), editColumn.getColumnComment());
            }
        }
    }

    @Override
    public void rename(UpdateTableDto updateTableDto, String oldTableName, String newTableName) {
        if (!oldTableName.equalsIgnoreCase(newTableName)) {
            this.ddlMapper.changeTableName(oldTableName, newTableName);
        }
        if (HussarUtils.isNotEmpty((Object)updateTableDto.getTableComment())) {
            this.ddlMapper.updateTableComment2(newTableName, updateTableDto.getTableComment());
        }
    }

    @Override
    public void dealColumn(ColumnInfoDto column) {
        ColumnUtil.dealSqlServerColumn(column);
    }
}

