/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.datasource.manager.plugin.ddl.action.factory;

import com.jxdinfo.hussar.datasource.manager.plugin.ddl.action.BasicAction;
import com.jxdinfo.hussar.datasource.manager.plugin.ddl.action.CreateTableAction;
import com.jxdinfo.hussar.datasource.manager.plugin.ddl.action.EditTableAction;
import com.jxdinfo.hussar.datasource.manager.plugin.ddl.action.EditTableSqlAction;
import com.jxdinfo.hussar.datasource.manager.plugin.ddl.action.SelectTableAction;
import com.jxdinfo.hussar.datasource.manager.plugin.ddl.action.ViewOptionAction;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class ActionFactory {
    private static Map<Class<?>, HashMap<String, Object>> ACTIONS = new HashMap();

    private ActionFactory() {
    }

    public static void addAction(String dbType, BasicAction action, Class<?> clazz) {
        ACTIONS.computeIfAbsent(clazz, k -> new HashMap());
        ACTIONS.get(clazz).put(dbType, action);
    }

    public static <T> T getAction(String dbType, Class<?> clazz) {
        T value = Optional.ofNullable(ACTIONS.get(clazz)).map(m -> m.get(dbType)).orElse(null);
        if (value == null) {
            throw new IllegalStateException(String.format("\u8fd8\u672a\u652f\u6301%s:%s", dbType, clazz.getSimpleName()));
        }
        return value;
    }

    static {
        ACTIONS.put(CreateTableAction.class, new HashMap());
        ACTIONS.put(EditTableAction.class, new HashMap());
        ACTIONS.put(EditTableSqlAction.class, new HashMap());
        ACTIONS.put(SelectTableAction.class, new HashMap());
        ACTIONS.put(ViewOptionAction.class, new HashMap());
    }
}

