/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.datasource.manager.plugin.ddl.service.impl;

import com.baomidou.dynamic.datasource.ds.ItemDataSource;
import com.jxdinfo.hussar.datasource.manager.api.entity.MetadataTable;
import com.jxdinfo.hussar.datasource.manager.api.model.ColumnInfoDto;
import com.jxdinfo.hussar.datasource.manager.api.model.MetadataParam;
import com.jxdinfo.hussar.datasource.manager.plugin.ddl.action.CreateTableAction;
import com.jxdinfo.hussar.datasource.manager.plugin.ddl.action.EditTableAction;
import com.jxdinfo.hussar.datasource.manager.plugin.ddl.action.EditTableSqlAction;
import com.jxdinfo.hussar.datasource.manager.plugin.ddl.action.ViewOptionAction;
import com.jxdinfo.hussar.datasource.manager.plugin.ddl.action.factory.ActionFactory;
import com.jxdinfo.hussar.datasource.manager.plugin.ddl.service.DsDdlService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.support.datasource.support.service.DynamicDatasourceService;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DsDdlServiceImpl
implements DsDdlService {
    @Autowired
    private DynamicDatasourceService datasourceService;

    @Override
    @HussarDs(value="#connName")
    public void createTable(MetadataParam paramData, String connName) {
        ((CreateTableAction)ActionFactory.getAction(this.getCurrentDatasource().getDbType().getDb(), CreateTableAction.class)).doCreateTable(paramData);
    }

    @Override
    @HussarDs(value="#connName")
    public void editTable(MetadataParam paramData, List<ColumnInfoDto> oldColumnInfo, String oldTableName, String connName) {
        if (HussarUtils.isEmpty((Object)oldTableName)) {
            oldTableName = Optional.ofNullable(paramData.getTableInfo()).map(MetadataTable::getTableName).orElseThrow(() -> new HussarException("\u8868\u540d\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        ((EditTableAction)ActionFactory.getAction(this.getCurrentDatasource().getDbType().getDb(), EditTableAction.class)).doEditTable(paramData, oldColumnInfo, oldTableName);
    }

    @Override
    @HussarDs(value="#connName")
    public String getDdlSql(MetadataParam paramData, List<ColumnInfoDto> oldColumnInfo, String oldTableName, String connName) throws IOException {
        return ((EditTableSqlAction)ActionFactory.getAction(this.getCurrentDatasource().getDbType().getDb(), EditTableSqlAction.class)).doEditTableSql(paramData, oldColumnInfo, oldTableName);
    }

    @Override
    @HussarDs(value="#connName")
    public boolean createView(String viewName, String viewSql, String connName) {
        return ((ViewOptionAction)ActionFactory.getAction(this.getCurrentDatasource().getDbType().getDb(), ViewOptionAction.class)).createView(viewName, viewSql);
    }

    @Override
    @HussarDs(value="#connName")
    public boolean editView(String viewName, String viewSql, String connName) {
        return ((ViewOptionAction)ActionFactory.getAction(this.getCurrentDatasource().getDbType().getDb(), ViewOptionAction.class)).alertView(viewName, viewSql);
    }

    @Override
    @HussarDs(value="#connName")
    public boolean dropView(String viewName, String connName) {
        return ((ViewOptionAction)ActionFactory.getAction(this.getCurrentDatasource().getDbType().getDb(), ViewOptionAction.class)).dropView(viewName);
    }

    @Override
    @HussarDs(value="#connName")
    public String getViewSql(String viewName, String connName) {
        return ((ViewOptionAction)ActionFactory.getAction(this.getCurrentDatasource().getDbType().getDb(), ViewOptionAction.class)).getViewSql(viewName);
    }

    @Override
    @HussarDs(value="#connName")
    public void checkSql(String sql, String connName) {
        ((ViewOptionAction)ActionFactory.getAction(this.getCurrentDatasource().getDbType().getDb(), ViewOptionAction.class)).checkSql(sql);
    }

    private ItemDataSource getCurrentDatasource() {
        return this.datasourceService.getCurrentDatasource();
    }
}

