/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.datasource.manager.plugin.ddl.adaptation.pg;

import com.baomidou.mybatisplus.annotation.DbType;
import com.jxdinfo.hussar.datasource.manager.plugin.ddl.action.ViewOptionAction;
import com.jxdinfo.hussar.datasource.manager.plugin.ddl.action.factory.ActionFactory;
import com.jxdinfo.hussar.datasource.manager.plugin.ddl.adaptation.pg.dao.PgDdlMapper;
import com.jxdinfo.hussar.datasource.manager.plugin.ddl.mapper.DdlMapper;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component
public class PgViewOptionAction
extends ViewOptionAction {
    @Resource
    private PgDdlMapper ddlMapper;

    public PgViewOptionAction() {
        ActionFactory.addAction(DbType.POSTGRE_SQL.getDb(), this, ViewOptionAction.class);
    }

    @Override
    public boolean alertView(String viewName, String viewSql) {
        try {
            this.getMapper().dropView(viewName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return super.alertView(viewName, viewSql);
    }

    @Override
    public String getViewSql(String viewName) {
        Map<String, Object> map = this.getMapper().getViewSql(viewName.toLowerCase());
        String viewSql = (String)map.get("sqltext");
        return viewSql.substring(0, viewSql.length() - 1);
    }

    @Override
    public void checkSql(String sql) {
        Long sysTime = System.currentTimeMillis() / 1000L;
        String viewName = "TEMP_VIEW_CHECKSQL_" + sysTime;
        try {
            String sqlCode = this.getViewSql(viewName);
            if (HussarUtils.isNotBlank((CharSequence)sqlCode)) {
                this.getMapper().dropView(viewName);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.getMapper().checkSql(viewName, sql);
        this.getMapper().dropView(viewName);
    }

    @Override
    public DdlMapper getMapper() {
        return this.ddlMapper;
    }
}

