/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.datasource.manager.plugin.ddl.adaptation.dm;

import com.baomidou.mybatisplus.annotation.DbType;
import com.jxdinfo.hussar.datasource.manager.api.model.ColumnInfoDto;
import com.jxdinfo.hussar.datasource.manager.api.model.UpdateTableDto;
import com.jxdinfo.hussar.datasource.manager.plugin.ddl.action.EditTableAction;
import com.jxdinfo.hussar.datasource.manager.plugin.ddl.action.factory.ActionFactory;
import com.jxdinfo.hussar.datasource.manager.plugin.ddl.adaptation.dm.dao.DmDdlMapper;
import com.jxdinfo.hussar.datasource.manager.plugin.ddl.mapper.DdlMapper;
import com.jxdinfo.hussar.datasource.manager.plugin.ddl.util.ColumnUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DmEditTableAction
extends EditTableAction {
    private static Logger LOGGER = LoggerFactory.getLogger(DmEditTableAction.class);
    @Resource
    private DmDdlMapper ddlMapper;

    public DmEditTableAction() {
        ActionFactory.addAction(DbType.DM.getDb(), this, EditTableAction.class);
    }

    @Override
    public DdlMapper getMapper() {
        return this.ddlMapper;
    }

    @Override
    public void dropPk(UpdateTableDto updateTableDto) {
        if (updateTableDto.isDropPk() && updateTableDto.isHavePk()) {
            String keyName = this.ddlMapper.getPrimaryKey(updateTableDto.getTableName());
            this.ddlMapper.dropPrimaryKey2(updateTableDto.getTableName(), keyName);
        }
    }

    @Override
    public void del(UpdateTableDto updateTableDto, String newTableName) {
        if (HussarUtils.isNotEmpty((Object)updateTableDto.getDelCols())) {
            for (ColumnInfoDto delCol : updateTableDto.getDelCols()) {
                this.ddlMapper.delTableCol(newTableName, delCol.getColumnName());
            }
        }
    }

    @Override
    public void dealColumn(ColumnInfoDto column) {
        ColumnUtil.dealDmColumn(column);
    }
}

