/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.datasource.manager.plugin.ddl.adaptation.oscar;

import com.baomidou.mybatisplus.annotation.DbType;
import com.jxdinfo.hussar.datasource.manager.api.model.ColumnInfoDto;
import com.jxdinfo.hussar.datasource.manager.api.model.UpdateTableDto;
import com.jxdinfo.hussar.datasource.manager.plugin.ddl.action.EditTableAction;
import com.jxdinfo.hussar.datasource.manager.plugin.ddl.action.factory.ActionFactory;
import com.jxdinfo.hussar.datasource.manager.plugin.ddl.adaptation.oscar.dao.OscarDdlMapper;
import com.jxdinfo.hussar.datasource.manager.plugin.ddl.mapper.DdlMapper;
import com.jxdinfo.hussar.datasource.manager.plugin.ddl.util.ColumnUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.Collections;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class OscarEditTableAction
extends EditTableAction {
    private static Logger LOGGER = LoggerFactory.getLogger(OscarEditTableAction.class);
    @Resource
    private OscarDdlMapper ddlMapper;

    public OscarEditTableAction() {
        ActionFactory.addAction(DbType.OSCAR.getDb(), this, EditTableAction.class);
    }

    @Override
    public DdlMapper getMapper() {
        return this.ddlMapper;
    }

    @Override
    public void edit(UpdateTableDto updateTableDto, String newTableName) {
        if (HussarUtils.isNotEmpty((Object)updateTableDto.getEditCols())) {
            for (ColumnInfoDto editColumn : updateTableDto.getEditCols()) {
                if (HussarUtils.isNotEmpty((Object)editColumn.getOldColumnName()) && !editColumn.getColumnName().equalsIgnoreCase(editColumn.getOldColumnName())) {
                    this.ddlMapper.renameColumnName(newTableName, editColumn.getOldColumnName(), editColumn.getColumnName());
                }
                this.ddlMapper.editTableCols(newTableName, Collections.singletonList(editColumn));
                if (editColumn.isNeedChangeIsRequired()) {
                    this.ddlMapper.setNotNull(newTableName, editColumn);
                }
                if (!HussarUtils.isNotEmpty((Object)editColumn.getColumnComment())) continue;
                this.ddlMapper.updateColumnComment(newTableName, editColumn.getColumnName(), editColumn.getColumnComment());
            }
        }
    }

    @Override
    public void del(UpdateTableDto updateTableDto, String newTableName) {
        if (HussarUtils.isNotEmpty((Object)updateTableDto.getDelCols())) {
            for (ColumnInfoDto delCol : updateTableDto.getDelCols()) {
                this.ddlMapper.delTableCol(newTableName, delCol.getColumnName());
            }
        }
    }

    @Override
    public void dealColumn(ColumnInfoDto column) {
        ColumnUtil.dealOscarColumn(column);
    }
}

