/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.datasource.manager.plugin.ddl.adaptation.sqlserver;

import com.baomidou.mybatisplus.annotation.DbType;
import com.jxdinfo.hussar.datasource.manager.plugin.ddl.action.ViewOptionAction;
import com.jxdinfo.hussar.datasource.manager.plugin.ddl.action.factory.ActionFactory;
import com.jxdinfo.hussar.datasource.manager.plugin.ddl.adaptation.sqlserver.dao.SqlServerDdlMapper;
import com.jxdinfo.hussar.datasource.manager.plugin.ddl.mapper.DdlMapper;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component
public class SqlServerViewOptionAction
extends ViewOptionAction {
    @Resource
    private SqlServerDdlMapper ddlMapper;

    public SqlServerViewOptionAction() {
        ActionFactory.addAction(DbType.SQL_SERVER.getDb(), this, ViewOptionAction.class);
        ActionFactory.addAction(DbType.SQL_SERVER2005.getDb(), this, ViewOptionAction.class);
    }

    @Override
    public DdlMapper getMapper() {
        return this.ddlMapper;
    }

    @Override
    public String getViewSql(String viewName) {
        String[] sqlServerSql = new String[2];
        Map<String, Object> map = this.getMapper().getViewSql(viewName.toLowerCase());
        String viewSql = (String)map.get("SQLTEXT");
        if (viewSql.contains("AS\n")) {
            sqlServerSql = viewSql.split("AS\n", 2);
        } else if (viewSql.contains("AS")) {
            sqlServerSql = viewSql.split("AS", 2);
        }
        if (sqlServerSql.length > 1) {
            return sqlServerSql[1];
        }
        return "";
    }

    @Override
    public void checkSql(String sql) {
        Long sysTime = System.currentTimeMillis() / 1000L;
        String viewName = "TEMP_VIEW_CHECKSQL_" + sysTime;
        try {
            String sqlCode = this.getViewSql(viewName);
            if (HussarUtils.isNotBlank((CharSequence)sqlCode)) {
                this.getMapper().dropView(viewName);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.getMapper().checkSql(viewName, sql);
        this.getMapper().dropView(viewName);
    }
}

