/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.datasource.manager.plugin.ddl.adaptation.oscar;

import com.baomidou.mybatisplus.annotation.DbType;
import com.jxdinfo.hussar.datasource.manager.plugin.ddl.action.ViewOptionAction;
import com.jxdinfo.hussar.datasource.manager.plugin.ddl.action.factory.ActionFactory;
import com.jxdinfo.hussar.datasource.manager.plugin.ddl.adaptation.oscar.dao.OscarDdlMapper;
import com.jxdinfo.hussar.datasource.manager.plugin.ddl.mapper.DdlMapper;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component
public class OscarViewOptionAction
extends ViewOptionAction {
    @Resource
    private OscarDdlMapper ddlMapper;

    public OscarViewOptionAction() {
        ActionFactory.addAction(DbType.OSCAR.getDb(), this, ViewOptionAction.class);
    }

    @Override
    public DdlMapper getMapper() {
        return this.ddlMapper;
    }

    @Override
    public String getViewSql(String viewName) {
        Map<String, Object> map = this.getMapper().getViewSql(viewName);
        String viewSql = (String)map.get("DEFINITION");
        return viewSql;
    }

    @Override
    public void checkSql(String sql) {
        Long sysTime = System.currentTimeMillis() / 1000L;
        String viewName = "TEMP_VIEW_CHECKSQL_" + sysTime;
        try {
            String sqlCode = this.getViewSql(viewName);
            if (HussarUtils.isNotBlank((CharSequence)sqlCode)) {
                this.getMapper().dropView(viewName);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.getMapper().checkSql(viewName, sql);
        this.getMapper().dropView(viewName);
    }
}

