/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.datasource.manager.plugin.ddl.adaptation.mysql;

import com.baomidou.mybatisplus.annotation.DbType;
import com.jxdinfo.hussar.datasource.manager.api.model.ColumnInfoDto;
import com.jxdinfo.hussar.datasource.manager.api.model.UpdateTableDto;
import com.jxdinfo.hussar.datasource.manager.plugin.ddl.action.EditTableAction;
import com.jxdinfo.hussar.datasource.manager.plugin.ddl.action.factory.ActionFactory;
import com.jxdinfo.hussar.datasource.manager.plugin.ddl.adaptation.mysql.dao.MysqlDdlMapper;
import com.jxdinfo.hussar.datasource.manager.plugin.ddl.mapper.DdlMapper;
import com.jxdinfo.hussar.datasource.manager.plugin.ddl.util.ColumnUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class MysqlEditTableAction
extends EditTableAction {
    private static Logger LOGGER = LoggerFactory.getLogger(MysqlEditTableAction.class);
    @Resource
    private MysqlDdlMapper ddlMapper;

    public MysqlEditTableAction() {
        ActionFactory.addAction(DbType.MYSQL.getDb(), this, EditTableAction.class);
    }

    @Override
    public DdlMapper getMapper() {
        return this.ddlMapper;
    }

    @Override
    public void add(UpdateTableDto updateTableDto, String newTableName) {
        if (HussarUtils.isNotEmpty((Object)updateTableDto.getAddCols())) {
            this.ddlMapper.addTableCols(newTableName, updateTableDto.getAddCols());
        }
    }

    @Override
    public void edit(UpdateTableDto updateTableDto, String newTableName) {
        if (HussarUtils.isNotEmpty((Object)updateTableDto.getEditCols())) {
            this.ddlMapper.editTableCols(newTableName, updateTableDto.getEditCols());
        }
    }

    @Override
    public void editPk(UpdateTableDto updateTableDto) {
        boolean needSetPk;
        boolean isHavePk = updateTableDto.isDropPk() && updateTableDto.isHavePk();
        boolean bl = needSetPk = updateTableDto.isDropPk() && updateTableDto.isNeedSetPk();
        if (isHavePk || needSetPk) {
            this.ddlMapper.setPk(updateTableDto.getTableName(), isHavePk, needSetPk, updateTableDto.getPkColumnName());
        }
    }

    @Override
    public void dealColumn(ColumnInfoDto column) {
        ColumnUtil.dealMysqlColumn(column);
    }
}

