/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.datasource.manager.plugin.ddl.action;

import com.jxdinfo.hussar.datasource.manager.api.entity.MetadataColumn;
import com.jxdinfo.hussar.datasource.manager.api.model.ColumnInfoDto;
import com.jxdinfo.hussar.datasource.manager.api.model.MetadataParam;
import com.jxdinfo.hussar.datasource.manager.api.model.TableInfoDto;
import com.jxdinfo.hussar.datasource.manager.api.model.UpdateTableDto;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

public abstract class BasicAction {
    void init(MetadataParam paramData) {
        TableInfoDto baseInfo = paramData.getTableInfo();
        if (HussarUtils.isEmpty((Object)baseInfo.getTableAlias())) {
            baseInfo.setTableAlias(baseInfo.getTableName());
        }
        for (ColumnInfoDto column : paramData.getColumnInfo()) {
            if (column.getPk().equals("1")) {
                paramData.getSetPkColumnNames().add(column.getColumnName());
            }
            if (HussarUtils.isEmpty((Object)column.getColumnComment())) {
                column.setColumnComment(column.getColumnName());
            }
            this.dealColumn(column);
        }
    }

    UpdateTableDto getUpdateTableDto(MetadataParam paramData, String oldTableName, List<ColumnInfoDto> oldColumnInfo) {
        Map oldColumnInfoMap = oldColumnInfo.stream().collect(Collectors.toMap(MetadataColumn::getColumnName, Function.identity(), (k1, k2) -> k1));
        UpdateTableDto updateTableDto = new UpdateTableDto();
        updateTableDto.setTableName(paramData.getTableInfo().getTableName());
        updateTableDto.setTableComment(paramData.getTableInfo().getTableDec());
        updateTableDto.setOldTableName(oldTableName);
        updateTableDto.setAddCols(new ArrayList());
        updateTableDto.setEditCols(new ArrayList());
        updateTableDto.setPkColumnName(new ArrayList());
        for (ColumnInfoDto columnInfoDto : paramData.getColumnInfo()) {
            if ("add".equals(columnInfoDto.getOperation())) {
                if ("1".equals(columnInfoDto.getPk())) {
                    updateTableDto.setNeedSetPk(true);
                    updateTableDto.setDropPk(true);
                    updateTableDto.getPkColumnName().add(columnInfoDto.getColumnName());
                }
                updateTableDto.getAddCols().add(columnInfoDto);
                continue;
            }
            if (!"edit".equals(columnInfoDto.getOperation())) continue;
            ColumnInfoDto oldColumn = (ColumnInfoDto)oldColumnInfoMap.get(columnInfoDto.getOldColumnName());
            if (oldColumn != null) {
                if (oldColumn.getRequired() != null) {
                    columnInfoDto.setNeedChangeIsRequired(!oldColumn.getRequired().equals(columnInfoDto.getRequired()));
                }
                if (!HussarUtils.equals((Object)columnInfoDto.getPk(), (Object)oldColumn.getPk()) && "0".equals(columnInfoDto.getPk())) {
                    updateTableDto.setHavePk(true);
                    oldColumn.setPk("0");
                }
                if (!(!"1".equals(columnInfoDto.getPk()) || columnInfoDto.getColumnName().equalsIgnoreCase(columnInfoDto.getOldColumnName()) && HussarUtils.equals((Object)columnInfoDto.getPk(), (Object)oldColumn.getPk()))) {
                    updateTableDto.setHavePk(true);
                    updateTableDto.setDropPk(true);
                    updateTableDto.setNeedSetPk(true);
                    updateTableDto.getPkColumnName().add(columnInfoDto.getColumnName());
                    oldColumn.setPk("0");
                }
            }
            if (columnInfoDto.getOldColumnName() == null) {
                columnInfoDto.setOldColumnName(columnInfoDto.getColumnName());
            }
            updateTableDto.getEditCols().add(columnInfoDto);
        }
        for (ColumnInfoDto columnInfoDto : oldColumnInfo) {
            if (!"1".equals(columnInfoDto.getPk())) continue;
            List pkColumnName = updateTableDto.getPkColumnName();
            if (!pkColumnName.contains(columnInfoDto.getColumnName()) && !this.isDel(columnInfoDto.getColumnName(), paramData.getDeletedCols())) {
                updateTableDto.setNeedSetPk(true);
                pkColumnName.add(columnInfoDto.getColumnName());
            }
            updateTableDto.setHavePk(true);
        }
        List delCols = paramData.getDeletedCols();
        if (delCols != null) {
            for (ColumnInfoDto delCol : delCols) {
                if (!"1".equals(delCol.getPk())) continue;
                updateTableDto.setDropPk(true);
            }
        }
        updateTableDto.setDelCols((List)Optional.ofNullable(delCols).orElse(new ArrayList()));
        return updateTableDto;
    }

    private boolean isDel(String columnName, List<ColumnInfoDto> deletedCols) {
        if (HussarUtils.isNotEmpty(deletedCols) && HussarUtils.isNotEmpty((Object)columnName)) {
            for (ColumnInfoDto deletedCol : deletedCols) {
                if (!columnName.equalsIgnoreCase(deletedCol.getColumnName())) continue;
                return true;
            }
        }
        return false;
    }

    public abstract void dealColumn(ColumnInfoDto var1);
}

