/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.datascope.plugin.mybatis.interceptor;

import com.baomidou.mybatisplus.core.toolkit.PluginUtils;
import com.jxdinfo.hussar.platform.core.support.service.GetLoginUserService;
import com.jxdinfo.hussar.platform.core.utils.ClassUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.support.datascope.core.annotation.DataAuth;
import com.jxdinfo.hussar.support.datascope.core.support.handler.DataScopeHandler;
import com.jxdinfo.hussar.support.datascope.core.support.model.DataScopeModel;
import com.jxdinfo.hussar.support.datascope.core.support.properties.DataScopeProperties;
import com.jxdinfo.hussar.support.mp.intercept.QueryInterceptor;
import java.lang.invoke.LambdaMetafactory;
import java.lang.reflect.Method;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Predicate;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.mapping.StatementType;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Repository;

public class DataScopeInterceptor
implements QueryInterceptor {
    private final ConcurrentMap<String, DataAuth> dataAuthMap = new ConcurrentHashMap<String, DataAuth>(8);
    private final DataScopeHandler dataScopeHandler;
    private final DataScopeProperties dataScopeProperties;
    private final GetLoginUserService getLoginUserService;

    public DataScopeInterceptor(DataScopeHandler dataScopeHandler, DataScopeProperties dataScopeProperties, GetLoginUserService getLoginUserService) {
        this.dataScopeHandler = dataScopeHandler;
        this.dataScopeProperties = dataScopeProperties;
        this.getLoginUserService = getLoginUserService;
    }

    /*
     * Unable to fully structure code
     */
    public void intercept(Executor executor, MappedStatement ms, Object parameter, RowBounds rowBounds, ResultHandler resultHandler, BoundSql boundSql) {
        if (!this.dataScopeProperties.getEnable().booleanValue()) {
            return;
        }
        userDetails = this.getLoginUserService.getCurrentUserDetail();
        if (userDetails == null) {
            return;
        }
        if (SqlCommandType.SELECT != ms.getSqlCommandType() || StatementType.CALLABLE == ms.getStatementType()) {
            return;
        }
        originalSql = boundSql.getSql();
        mapperId = ms.getId();
        className = mapperId.substring(0, mapperId.lastIndexOf("."));
        mapperName = ClassUtil.getShortName((String)className);
        methodName = mapperId.substring(mapperId.lastIndexOf(".") + 1);
        if (this.dataScopeProperties.getMapperKey().stream().noneMatch((Predicate<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$intercept$0(java.lang.String java.lang.String ), (Ljava/lang/String;)Z)((String)methodName))) ** GOTO lbl-1000
        if (this.dataScopeProperties.getMapperExclude().stream().anyMatch((Predicate<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, equals(java.lang.Object ), (Ljava/lang/String;)Z)((String)mapperName))) lbl-1000:
        // 2 sources

        {
            v0 = true;
        } else {
            v0 = false;
        }
        mapperSkip = v0;
        dataAuth = this.findDataAuthAnnotation(ms);
        if (dataAuth == null && mapperSkip) {
            return;
        }
        dataScope = null;
        if (dataAuth != null) {
            dataScope = new DataScopeModel(Boolean.TRUE);
            dataScope.setScopeColumn(dataAuth.column());
            dataScope.setScopeType(Integer.valueOf(dataAuth.type().getType()));
        }
        if (!StringUtil.isBlank((CharSequence)(sqlCondition = this.dataScopeHandler.sqlCondition(executor, parameter, mapperId, dataScope, userDetails, originalSql)))) {
            mpBoundSql = PluginUtils.mpBoundSql((BoundSql)boundSql);
            mpBoundSql.sql(sqlCondition);
        }
    }

    private DataAuth findDataAuthAnnotation(MappedStatement mappedStatement) {
        String id = mappedStatement.getId();
        return this.dataAuthMap.computeIfAbsent(id, key -> {
            String className = key.substring(0, key.lastIndexOf("."));
            try {
                Class[] interfaces;
                String name;
                Class mapperClass = ClassUtil.loadClass((String)className, (boolean)false);
                Repository repository = (Repository)AnnotationUtils.findAnnotation((Class)mapperClass, Repository.class);
                String mapperBean = HussarUtils.isNotEmpty((Object)repository) ? (HussarUtils.isNotEmpty((Object)(name = repository.value())) ? name : StringUtil.firstCharToLower((String)ClassUtil.getShortName((String)className))) : StringUtil.firstCharToLower((String)ClassUtil.getShortName((String)className));
                Object mapper = SpringContextUtil.getBean((String)mapperBean);
                String methodName = key.substring(key.lastIndexOf(".") + 1);
                for (Class mapperInterface : interfaces = ClassUtil.getAllInterfaces((Object)mapper)) {
                    for (Method method : mapperInterface.getDeclaredMethods()) {
                        if (!methodName.equals(method.getName()) || !method.isAnnotationPresent(DataAuth.class)) continue;
                        return method.getAnnotation(DataAuth.class);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        });
    }

    private static /* synthetic */ boolean lambda$intercept$0(String methodName, String mapperKey) {
        return methodName.toLowerCase().contains(mapperKey.toLowerCase());
    }
}

