/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.audit.interceptor;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.IpUtils;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.support.audit.core.auditlog.entity.AuditLogEntity;
import com.jxdinfo.hussar.support.audit.core.config.AuditLogProperties;
import com.jxdinfo.hussar.support.audit.core.util.AuditIpUtils;
import io.swagger.annotations.Api;
import java.time.LocalDateTime;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.web.method.HandlerMethod;

public abstract class AbstractAuditLogHandlerInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractAuditLogHandlerInterceptor.class);

    public abstract void doBeforeHandle(HttpServletRequest var1, HttpServletResponse var2, Object var3);

    public abstract void doAfterHandle();

    public abstract void doAfterThrowingHandle(Throwable var1);

    public AuditLogEntity handleRequestInfo(HttpServletRequest request, Object handler) {
        String name;
        String moduleName;
        if (!(handler instanceof HandlerMethod)) {
            return null;
        }
        HandlerMethod handlerMethod = (HandlerMethod)handler;
        Class beanType = handlerMethod.getBeanType();
        String className = beanType.getSimpleName();
        String packageName = beanType.getPackage().getName();
        String methodName = handlerMethod.getMethod().getName();
        LOGGER.debug("\u5ba1\u8ba1\u65e5\u5fd7\u62e6\u622a\uff1a\u7c7b[{}].[{}] :\u65b9\u6cd5[{}],\u62e6\u622a\u65b9\u5f0f\uff1a{}", new Object[]{packageName, className, methodName});
        Api annotationClass = (Api)AnnotationUtils.findAnnotation((Class)handlerMethod.getBeanType(), Api.class);
        if (HussarUtils.isEmpty((Object)annotationClass)) {
            moduleName = "";
            name = className + "." + methodName + "\u5ba1\u8ba1\u65e5\u5fd7";
        } else if (HussarUtils.isNotEmpty((Object)annotationClass.value())) {
            moduleName = annotationClass.value();
            name = "[" + moduleName + "]" + className + "." + methodName + "\u5ba1\u8ba1\u65e5\u5fd7";
        } else if (HussarUtils.isNotEmpty((Object[])annotationClass.tags())) {
            Object[] tags = annotationClass.tags();
            moduleName = StringUtil.join((Object[])tags, (String)",");
            name = "[" + moduleName + "]" + className + "." + methodName + "\u5ba1\u8ba1\u65e5\u5fd7";
        } else {
            moduleName = "";
            name = className + "." + methodName + "\u5ba1\u8ba1\u65e5\u5fd7";
        }
        AuditLogProperties auditLogProperties = (AuditLogProperties)SpringContextUtil.getBean(AuditLogProperties.class);
        AuditLogEntity auditLogEntity = new AuditLogEntity();
        auditLogEntity.setServerName(auditLogProperties.getServerName());
        auditLogEntity.setVersion(auditLogProperties.getVersion());
        auditLogEntity.setModuleName(moduleName);
        auditLogEntity.setName(name);
        auditLogEntity.setPackageName(packageName).setClassName(className).setMethodName(methodName);
        String path = request.getRequestURL().toString();
        String url = request.getRequestURI();
        String ip = IpUtils.getIp((HttpServletRequest)request);
        String requestMethod = request.getMethod();
        auditLogEntity.setPath(path).setUrl(url).setClientAddr(ip).setServerHost(AuditIpUtils.CURRENT_LOCAL_HOSTNAME).setServerPort(Integer.valueOf(request.getLocalPort())).setServerAddr(AuditIpUtils.CURRENT_LOCAL_IP).setClientHost(request.getRemoteHost()).setClientPort(Integer.valueOf(request.getRemotePort())).setAccessTime(LocalDateTime.now()).setRequestMethod(requestMethod).setThreadName(Thread.currentThread().getName());
        return auditLogEntity;
    }
}

