/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.audit.aspect;

import com.jxdinfo.hussar.platform.core.support.service.GetLoginUserService;
import com.jxdinfo.hussar.platform.core.support.service.dto.UserDetails;
import com.jxdinfo.hussar.platform.core.utils.Exceptions;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.JsonUtil;
import com.jxdinfo.hussar.support.audit.aspect.AbstractAuditLogAspect;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.auditlog.entity.AuditLogEntity;
import com.jxdinfo.hussar.support.audit.core.config.AuditLogProperties;
import com.jxdinfo.hussar.support.audit.core.enums.AuditSeverityLevel;
import com.jxdinfo.hussar.support.audit.core.enums.RequestResult;
import com.jxdinfo.hussar.support.audit.core.support.cache.AuditLogThreadLocalCache;
import com.jxdinfo.hussar.support.audit.core.support.event.AuditLogEvent;
import com.jxdinfo.hussar.support.audit.core.support.event.AuditLogResultEvent;
import com.jxdinfo.hussar.support.audit.core.util.AuditUtils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.web.multipart.MultipartFile;

public class AuditLogAnnotationInterceptor
extends AbstractAuditLogAspect
implements MethodInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuditLogAnnotationInterceptor.class);
    private AuditLogProperties auditLogProperties;
    private ApplicationEventPublisher applicationEventPublisher;
    private GetLoginUserService getLoginUserService;

    public AuditLogAnnotationInterceptor(AuditLogProperties auditLogProperties, ApplicationEventPublisher applicationEventPublisher, GetLoginUserService getLoginUserService) {
        this.auditLogProperties = auditLogProperties;
        this.applicationEventPublisher = applicationEventPublisher;
        this.getLoginUserService = getLoginUserService;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        return this.aroundExecute(invocation, this.auditLogProperties);
    }

    @Override
    public void doBeforeHandle(HttpServletRequest request, MethodInvocation invocation) {
        AuditLogEntity auditLogEntity = this.handleRequestInfo(request, invocation);
        if (HussarUtils.isEmpty((Object)auditLogEntity)) {
            return;
        }
        auditLogEntity.setCommitId(AuditUtils.getUuid());
        AuditLogThreadLocalCache.set((AuditLogEntity)auditLogEntity);
        AuditLogEvent auditLogEvent = new AuditLogEvent((Object)this, auditLogEntity);
        this.applicationEventPublisher.publishEvent((ApplicationEvent)auditLogEvent);
    }

    @Override
    public void doAfterHandle() {
        AuditLogEntity auditLogEntity = AuditLogThreadLocalCache.get();
        if (HussarUtils.isEmpty((Object)auditLogEntity)) {
            return;
        }
        auditLogEntity.setRequesetResult(RequestResult.success.getCode());
        AuditLogResultEvent auditLogResultEvent = new AuditLogResultEvent((Object)this, auditLogEntity);
        this.applicationEventPublisher.publishEvent((ApplicationEvent)auditLogResultEvent);
        AuditLogThreadLocalCache.remove();
    }

    @Override
    public void doAfterThrowingHandle(Throwable exception) {
        AuditLogEntity auditLogEntity = AuditLogThreadLocalCache.get();
        if (HussarUtils.isEmpty((Object)auditLogEntity)) {
            return;
        }
        auditLogEntity.setRequesetResult(RequestResult.failed.getCode());
        auditLogEntity.setExecptionInfo(Exceptions.getStackTraceAsString((Throwable)exception));
        AuditLogResultEvent auditLogResultEvent = new AuditLogResultEvent((Object)this, auditLogEntity);
        this.applicationEventPublisher.publishEvent((ApplicationEvent)auditLogResultEvent);
        AuditLogThreadLocalCache.remove();
    }

    @Override
    public AuditLogEntity handleRequestInfo(HttpServletRequest request, MethodInvocation invocation) {
        String clientId;
        String classModuleName;
        AuditLog annotationClass;
        Method method = invocation.getMethod();
        Class<?> beanType = method.getDeclaringClass();
        String className = beanType.getSimpleName();
        String packageName = beanType.getPackage().getName();
        String methodName = method.getName();
        LOGGER.debug("\u5ba1\u8ba1\u65e5\u5fd7\u62e6\u622a\uff1a\u7c7b[{}].[{}] :\u65b9\u6cd5[{}],\u62e6\u622a\u65b9\u5f0f\uff1a{}", new Object[]{packageName, className, methodName});
        AuditLog methodAnno = (AuditLog)AnnotationUtils.findAnnotation((Method)method, AuditLog.class);
        if (HussarUtils.isEmpty((Object)methodAnno)) {
            return null;
        }
        boolean b = this.vaildIsRecordAuditEventType(this.auditLogProperties, methodAnno);
        if (!b) {
            return null;
        }
        String moduleName = methodAnno.moduleName();
        if (HussarUtils.isEmpty((Object)moduleName) && HussarUtils.isNotEmpty((Object)(annotationClass = (AuditLog)AnnotationUtils.findAnnotation(beanType, AuditLog.class))) && HussarUtils.isNotEmpty((Object)(classModuleName = annotationClass.moduleName()))) {
            moduleName = classModuleName;
        }
        String eventDesc = methodAnno.eventDesc();
        Integer eventGrade = methodAnno.eventGrade().getType();
        Integer eventType = methodAnno.evnetType().getCode();
        String requestParams = null;
        Object[] arguments = invocation.getArguments();
        ArrayList<Object> paramsList = new ArrayList<Object>();
        for (Object o : arguments) {
            if (o instanceof ServletRequest || o instanceof ServletResponse || o instanceof MultipartFile) continue;
            paramsList.add(o);
        }
        if (HussarUtils.isNotEmpty(paramsList)) {
            requestParams = JsonUtil.toJson(paramsList);
        }
        AuditLogEntity auditLogEntity = new AuditLogEntity();
        auditLogEntity.setModuleName(moduleName);
        auditLogEntity.setPackageName(packageName).setClassName(className).setMethodName(methodName);
        auditLogEntity.setEventDesc(eventDesc).setEventGrade(eventGrade).setEventType(eventType).setSeverityLevel(Integer.valueOf(AuditSeverityLevel.NORMAL.getCode())).setRequestParams(requestParams).setRequesetResult(RequestResult.progressing.getCode());
        UserDetails userDetail = this.getLoginUserService.getCurrentUserDetail();
        if (userDetail == null && HussarUtils.isNotEmpty((Object)(clientId = request.getHeader("client-id")))) {
            userDetail = new UserDetails();
            userDetail.setUserName(clientId);
        }
        return AuditUtils.getAuditLogEntity((AuditLogEntity)auditLogEntity, (UserDetails)userDetail);
    }

    private boolean vaildIsRecordAuditEventType(AuditLogProperties auditLogProperties, AuditLog methodAnno) {
        if (HussarUtils.isEmpty((Object)auditLogProperties) || HussarUtils.isEmpty((Object)auditLogProperties.getExcludeAuditEventTypes())) {
            return true;
        }
        ArrayList eventTypes = auditLogProperties.getExcludeAuditEventTypes();
        int code = methodAnno.evnetType().getCode();
        if (HussarUtils.isEmpty((Object)code)) {
            return true;
        }
        return !eventTypes.contains(code);
    }
}

