/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.audit.plugin.mybatis.utils;

import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfoHelper;
import com.baomidou.mybatisplus.core.toolkit.PluginUtils;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.support.audit.core.config.AuditLogProperties;
import com.jxdinfo.hussar.support.audit.core.config.ExcludeTableInfo;
import com.jxdinfo.hussar.support.audit.core.util.ReflectionUtil;
import com.jxdinfo.hussar.support.audit.plugin.mybatis.support.dto.ColumnDto;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.JdbcParameter;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.expression.operators.relational.ItemsList;
import net.sf.jsqlparser.expression.operators.relational.MultiExpressionList;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.statement.update.UpdateSet;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.mapping.ResultMapping;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MybatisUtils
extends PluginUtils {
    private static final Logger log = LoggerFactory.getLogger(MybatisUtils.class);
    public static final String CUSTOMQUERY = "_CUSTOMQUERY";
    private static final List<ResultMapping> EMPTY_RESULTMAPPING = new ArrayList<ResultMapping>(0);
    public static final String MYBATIS_TARGET_NAME = "h";
    public static final String MYBATIS_SQL = "sql";
    public static final String MYBATIS_PARAMETERMAPPINGS = "parameterMappings";

    public static MappedStatement newHashMapMappedStatement(MappedStatement ms) {
        MappedStatement.Builder builder = new MappedStatement.Builder(ms.getConfiguration(), ms.getId() + CUSTOMQUERY, ms.getSqlSource(), ms.getSqlCommandType());
        builder.resource(ms.getResource());
        builder.fetchSize(ms.getFetchSize());
        builder.statementType(ms.getStatementType());
        builder.keyGenerator(ms.getKeyGenerator());
        if (ms.getKeyProperties() != null && ms.getKeyProperties().length != 0) {
            StringBuilder keyProperties = new StringBuilder();
            for (String keyProperty : ms.getKeyProperties()) {
                keyProperties.append(keyProperty).append(",");
            }
            keyProperties.delete(keyProperties.length() - 1, keyProperties.length());
            builder.keyProperty(keyProperties.toString());
        }
        builder.timeout(ms.getTimeout());
        builder.parameterMap(ms.getParameterMap());
        ArrayList<ResultMap> resultMaps = new ArrayList<ResultMap>();
        ResultMap resultMap = new ResultMap.Builder(ms.getConfiguration(), ms.getId(), HashMap.class, EMPTY_RESULTMAPPING).build();
        resultMaps.add(resultMap);
        builder.resultMaps(resultMaps);
        builder.resultSetType(ms.getResultSetType());
        builder.cache(ms.getCache());
        builder.flushCacheRequired(ms.isFlushCacheRequired());
        builder.useCache(ms.isUseCache());
        return builder.build();
    }

    public static <T extends Annotation> T getAnnotation(MappedStatement mappedStatement, Class<T> annotationClass, ClassLoader classLoader) {
        Method method = MybatisUtils.getMethod(mappedStatement, classLoader);
        if (method == null) {
            return null;
        }
        return method.getAnnotation(annotationClass);
    }

    public static <T extends Annotation> T getAnnotation(MappedStatement mappedStatement, Class<T> annotationClass) {
        Method method = MybatisUtils.getMethod(mappedStatement);
        if (method == null) {
            return null;
        }
        return method.getAnnotation(annotationClass);
    }

    public static Method getMethod(MappedStatement mappedStatement, ClassLoader classLoader) {
        try {
            String id = mappedStatement.getId();
            String className = id.substring(0, id.lastIndexOf("."));
            String methodName = id.substring(id.lastIndexOf(".") + 1);
            Method[] method = null;
            method = HussarUtils.isEmpty((Object)classLoader) ? Class.forName(className).getMethods() : Class.forName(className, true, classLoader).getMethods();
            for (Method me : method) {
                if (!me.getName().equals(methodName)) continue;
                return me;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public static Method getMethod(MappedStatement mappedStatement) {
        try {
            Method[] method;
            String id = mappedStatement.getId();
            String className = id.substring(0, id.lastIndexOf("."));
            String methodName = id.substring(id.lastIndexOf(".") + 1);
            for (Method me : method = Class.forName(className).getMethods()) {
                if (!me.getName().equals(methodName)) continue;
                return me;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public static <T> T realTarget(Object target) {
        if (Proxy.isProxyClass(target.getClass())) {
            MetaObject metaObject = SystemMetaObject.forObject((Object)target);
            return MybatisUtils.realTarget(metaObject.getValue(MYBATIS_TARGET_NAME));
        }
        return (T)target;
    }

    public static List<Column> getColumnsByUpdateSet(List<UpdateSet> updateSets) {
        if (HussarUtils.isEmpty(updateSets)) {
            return null;
        }
        ArrayList<ColumnDto> columnDtoList = new ArrayList<ColumnDto>();
        for (UpdateSet us : updateSets) {
            ColumnDto columnDto = new ColumnDto();
            columnDto.setColumn((Column)us.getColumns().get(0));
            columnDto.setEnableParameter(MybatisUtils.isParameterColumn((Expression)us.getExpressions().get(0)));
            columnDtoList.add(columnDto);
        }
        return MybatisUtils.getParameterColumns(columnDtoList);
    }

    private static List<Column> getParameterColumns(List<ColumnDto> columnDtos) {
        if (HussarUtils.isEmpty(columnDtos)) {
            return new ArrayList<Column>();
        }
        return columnDtos.stream().filter(ColumnDto::isEnableParameter).map(ColumnDto::getColumn).collect(Collectors.toList());
    }

    public static List<Column> getColumnsByInsert(List<Column> columns, ItemsList itemsList) {
        if (HussarUtils.isEmpty(columns) || HussarUtils.isEmpty((Object)itemsList)) {
            return null;
        }
        ArrayList<ColumnDto> columnDtos = new ArrayList<ColumnDto>();
        List expressions = new ArrayList();
        if (itemsList instanceof ExpressionList) {
            ExpressionList expressionList = (ExpressionList)itemsList;
            expressions = expressionList.getExpressions();
        }
        if (itemsList instanceof MultiExpressionList) {
            MultiExpressionList multiExpressionList = (MultiExpressionList)itemsList;
            expressions = ((ExpressionList)multiExpressionList.getExpressionLists().get(0)).getExpressions();
        }
        for (int i = 0; i < columns.size(); ++i) {
            ColumnDto columnDto = new ColumnDto();
            columnDto.setColumn(columns.get(i));
            if (i < expressions.size()) {
                columnDto.setEnableParameter(MybatisUtils.isParameterColumn((Expression)expressions.get(i)));
            }
            columnDtos.add(columnDto);
        }
        return MybatisUtils.getParameterColumns(columnDtos);
    }

    private static boolean isParameterColumn(Expression expression) {
        boolean enableParameter = expression instanceof JdbcParameter;
        return enableParameter;
    }

    public static boolean isRecordAuditLogByTableName(String tableName) {
        AuditLogProperties auditLogProperties = (AuditLogProperties)SpringContextUtil.getBean(AuditLogProperties.class);
        if (HussarUtils.isEmpty((Object)auditLogProperties) || HussarUtils.isEmpty((Object)auditLogProperties.getExcludeMappersPattern())) {
            return true;
        }
        List excludeTableInfoSet = auditLogProperties.getExcludeTables();
        if (HussarUtils.isEmpty((Object)excludeTableInfoSet)) {
            return true;
        }
        List tables = excludeTableInfoSet.stream().filter(excludeTableInfo -> HussarUtils.isEmpty((Object)excludeTableInfo.getColumns()) && excludeTableInfo.getTableName().equalsIgnoreCase(tableName)).collect(Collectors.toList());
        return HussarUtils.isEmpty(tables);
    }

    public static boolean isRecordAuditLogByColumnName(String tableName, String columnName) {
        List collect;
        AuditLogProperties auditLogProperties = (AuditLogProperties)SpringContextUtil.getBean(AuditLogProperties.class);
        Set commonColumns = auditLogProperties.getExcludeCommonColumns();
        if (HussarUtils.isNotEmpty((Object)commonColumns) && HussarUtils.isNotEmpty(collect = commonColumns.stream().filter(e -> e.equalsIgnoreCase(columnName)).collect(Collectors.toList()))) {
            return false;
        }
        List excludeTableInfoSet = auditLogProperties.getExcludeTables();
        if (HussarUtils.isEmpty((Object)excludeTableInfoSet)) {
            return true;
        }
        List tables = excludeTableInfoSet.stream().filter(excludeTableInfo -> excludeTableInfo.getTableName().equalsIgnoreCase(tableName)).collect(Collectors.toList());
        if (HussarUtils.isEmpty(tables)) {
            return true;
        }
        ExcludeTableInfo excludeTableInfo2 = (ExcludeTableInfo)tables.get(0);
        List columns = excludeTableInfo2.getColumns();
        if (HussarUtils.isEmpty((Object)columns)) {
            return false;
        }
        List columsRes = columns.stream().filter(e -> e.equalsIgnoreCase(columnName)).collect(Collectors.toList());
        return !HussarUtils.isNotEmpty(columsRes);
    }

    public static String formatSql(String sql) {
        if (HussarUtils.isEmpty((Object)sql)) {
            return null;
        }
        sql = StringUtil.replace((String)sql, (String)"\n", (String)"");
        return sql;
    }

    public static void setQuerySql(BoundSql queryBoundSql, String selectSqlString) {
        Field field = ReflectionUtil.findField(BoundSql.class, (String)MYBATIS_SQL);
        ReflectionUtil.setField((Field)field, (Object)queryBoundSql, (Object)selectSqlString);
    }

    public static void setParameterMappings(BoundSql queryBoundSql, List<ParameterMapping> mappings) {
        Field field = ReflectionUtil.findField(BoundSql.class, (String)MYBATIS_PARAMETERMAPPINGS);
        ReflectionUtil.setField((Field)field, (Object)queryBoundSql, mappings);
    }

    public static Field getPkField(TableInfo tableInfo) {
        if (HussarUtils.isEmpty((Object)tableInfo)) {
            return null;
        }
        List allFields = TableInfoHelper.getAllFields((Class)tableInfo.getEntityType());
        if (HussarUtils.isEmpty((Object)allFields)) {
            return null;
        }
        String keyProperty = tableInfo.getKeyProperty();
        Optional<Field> keyFiled = allFields.stream().filter(field -> field.getName().equals(keyProperty)).findFirst();
        return keyFiled.orElse(null);
    }
}

