/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.audit.plugin.mybatis.listener;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.audit.core.auditlog.entity.AuditLogEntity;
import com.jxdinfo.hussar.support.audit.core.support.cache.AuditLogThreadLocalCache;
import com.jxdinfo.hussar.support.audit.core.support.dto.ChangeRowData;
import com.jxdinfo.hussar.support.audit.core.support.event.AuditLogChangeDataEvent;
import com.jxdinfo.hussar.support.audit.core.support.listener.AuditLogChangeEventListener;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;

public class MybatisAuditLogEventListener
implements AuditLogChangeEventListener {
    private static final Logger log = LoggerFactory.getLogger(MybatisAuditLogEventListener.class);
    private final ApplicationEventPublisher applicationEventPublisher;

    public MybatisAuditLogEventListener(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    public void onDelete(List<ChangeRowData> changeRows) {
        if (HussarUtils.isNotEmpty(changeRows)) {
            AuditLogEntity auditLog = AuditLogThreadLocalCache.get();
            log.debug("\u5ba1\u8ba1\u65e5\u5fd7\u53d1\u5e03\u4e8b\u4ef6\uff0conDelete-->{}", changeRows);
            this.applicationEventPublisher.publishEvent((ApplicationEvent)new AuditLogChangeDataEvent((Object)this, changeRows, auditLog));
        }
    }

    public void onInsert(List<ChangeRowData> changeRows) {
        if (HussarUtils.isNotEmpty(changeRows)) {
            AuditLogEntity auditLog = AuditLogThreadLocalCache.get();
            log.debug("\u5ba1\u8ba1\u65e5\u5fd7\u53d1\u5e03\u4e8b\u4ef6\uff0conInsert-->{}", changeRows);
            this.applicationEventPublisher.publishEvent((ApplicationEvent)new AuditLogChangeDataEvent((Object)this, changeRows, auditLog));
        }
    }

    public void onUpdate(List<ChangeRowData> changeRows) {
        if (HussarUtils.isNotEmpty(changeRows)) {
            AuditLogEntity auditLog = AuditLogThreadLocalCache.get();
            log.debug("\u5ba1\u8ba1\u65e5\u5fd7\u53d1\u5e03\u4e8b\u4ef6\uff0conUpdate-->{}", changeRows);
            this.applicationEventPublisher.publishEvent((ApplicationEvent)new AuditLogChangeDataEvent((Object)this, changeRows, auditLog));
        }
    }
}

