/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.audit.plugin.mongodb.runner;

import com.jxdinfo.hussar.support.audit.core.auditlog.entity.AuditLogEntity;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.bson.Document;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.index.CompoundIndexDefinition;
import org.springframework.data.mongodb.core.index.IndexDefinition;
import org.springframework.data.mongodb.core.index.IndexInfo;

public class AutoCreateIndexRunner
implements ApplicationRunner {
    @Autowired(required=false)
    private MongoTemplate mongoTemplate;

    public void run(ApplicationArguments args) throws Exception {
        if (this.mongoTemplate == null) {
            return;
        }
        List indexInfoList = this.mongoTemplate.indexOps(AuditLogEntity.class).getIndexInfo();
        Set indexNameSet = indexInfoList.stream().map(IndexInfo::getName).collect(Collectors.toSet());
        Document keys = new Document();
        keys.put("createTime", (Object)-1);
        keys.put("tenantId", (Object)1);
        String indexName = "idx_createTime_tenantId";
        CompoundIndexDefinition compoundIndexDefinition = new CompoundIndexDefinition(keys);
        compoundIndexDefinition.background().named(indexName);
        if (!indexNameSet.contains(indexName)) {
            this.mongoTemplate.indexOps(AuditLogEntity.class).ensureIndex((IndexDefinition)compoundIndexDefinition);
        }
        keys = new Document();
        keys.put("createTime", (Object)1);
        keys.put("tenantId", (Object)1);
        keys.put("eventType", (Object)1);
        indexName = "idx_createTime_tenantId_eventType";
        compoundIndexDefinition = new CompoundIndexDefinition(keys);
        compoundIndexDefinition.background().named(indexName);
        if (!indexNameSet.contains(indexName)) {
            this.mongoTemplate.indexOps(AuditLogEntity.class).ensureIndex((IndexDefinition)compoundIndexDefinition);
        }
        keys = new Document();
        keys.put("createTime", (Object)1);
        keys.put("tenantId", (Object)1);
        keys.put("eventGrade", (Object)1);
        indexName = "idx_createTime_tenantId_eventGrade";
        compoundIndexDefinition = new CompoundIndexDefinition(keys);
        compoundIndexDefinition.background().named(indexName);
        if (!indexNameSet.contains(indexName)) {
            this.mongoTemplate.indexOps(AuditLogEntity.class).ensureIndex((IndexDefinition)compoundIndexDefinition);
        }
    }
}

