/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.audit.plugin.mongodb.support.query.rule.query;

import com.jxdinfo.hussar.platform.core.utils.DateTimeUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.audit.plugin.mongodb.support.query.entity.FieldMappingDto;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.List;
import org.springframework.data.mongodb.core.query.Criteria;

public interface QueryStrategy {
    default public FieldMappingDto transFieldValue(FieldMappingDto fieldMappingDto) {
        Object fieldValue = fieldMappingDto.getFieldValue();
        if (HussarUtils.isEmpty((Object)fieldValue)) {
            return fieldMappingDto;
        }
        String value = fieldValue.toString();
        switch (fieldMappingDto.getFieldClassType().toString()) {
            case "class java.lang.Integer": {
                fieldMappingDto.setFieldValue(Integer.parseInt(value));
                break;
            }
            case "class java.lang.Short": {
                Short parseShort = Short.parseShort(value);
                fieldMappingDto.setFieldValue(parseShort);
                break;
            }
            case "class java.lang.Long": {
                Long parseLong = Long.parseLong(value);
                fieldMappingDto.setFieldValue(parseLong);
                break;
            }
            case "class java.lang.Float": {
                Float parseFloat = Float.valueOf(Float.parseFloat(value));
                fieldMappingDto.setFieldValue(parseFloat);
                break;
            }
            case "class java.lang.Double": {
                Double parseDouble = Double.parseDouble(value);
                fieldMappingDto.setFieldValue(parseDouble);
                break;
            }
            case "class java.math.BigDecimal": {
                BigDecimal bigDecimal = new BigDecimal(value);
                fieldMappingDto.setFieldValue(bigDecimal);
                break;
            }
            case "class java.time.LocalDate": {
                LocalDate localDate = DateTimeUtil.parseDate((String)value);
                fieldMappingDto.setFieldValue(localDate);
                break;
            }
            case "class java.time.LocalDateTime": {
                LocalDateTime localDateTime = DateTimeUtil.parseDateTime((String)value);
                fieldMappingDto.setFieldValue(localDateTime);
                break;
            }
            case "class java.time.LocalTime": {
                LocalTime localTime = DateTimeUtil.parseTime((String)value);
                fieldMappingDto.setFieldValue(localTime);
                break;
            }
            case "class java.lang.Boolean": {
                Boolean booleanValue = Boolean.valueOf(value);
                fieldMappingDto.setFieldValue(booleanValue);
            }
            default: {
                fieldMappingDto.setFieldValue(value);
            }
        }
        return fieldMappingDto;
    }

    public void joinQueryWrapper(List<Criteria> var1, FieldMappingDto var2);
}

