/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.audit.plugin.mongodb.support.query;

import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.ConvertUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.ObjectUtil;
import com.jxdinfo.hussar.support.audit.core.util.QueryAuditUtils;
import com.jxdinfo.hussar.support.audit.plugin.mongodb.support.query.QueryGenerator;
import com.jxdinfo.hussar.support.audit.plugin.mongodb.support.query.entity.FieldMappingDto;
import com.jxdinfo.hussar.support.audit.plugin.mongodb.support.query.exception.MongoRuntimeException;
import com.jxdinfo.hussar.support.audit.plugin.mongodb.support.query.rule.query.QueryRuleEnum;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.beanutils.PropertyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.GroupOperation;
import org.springframework.data.mongodb.core.aggregation.MatchOperation;
import org.springframework.data.mongodb.core.aggregation.ProjectionOperation;
import org.springframework.data.mongodb.core.query.Criteria;

public class DefaultQueryGenerator
extends QueryGenerator {
    private static final Logger log = LoggerFactory.getLogger(DefaultQueryGenerator.class);

    @Override
    protected List<AggregationOperation> createAggregationOperation(Object searchObj, Map<String, String[]> parameterMap) {
        ProjectionOperation showFields;
        if (HussarUtils.isEmpty(parameterMap)) {
            throw new MongoRuntimeException("\u6570\u636e\u4e3a\u7a7a\u65e0\u6cd5\u8fdb\u884c\u5206\u7ec4");
        }
        PropertyDescriptor[] propertyDescriptors = BeanUtil.getPropertyDescriptors(searchObj.getClass());
        ArrayList<AggregationOperation> aggregationOperationsList = new ArrayList<AggregationOperation>();
        Optional<String[]> first = parameterMap.entrySet().stream().filter(e -> HussarUtils.equals(e.getKey(), (Object)"field_groupby")).map(e -> (String[])e.getValue()).findFirst();
        if (!first.isPresent()) {
            throw new MongoRuntimeException("\u65e0\u5206\u7ec4\u5b57\u6bb5");
        }
        String[] groupKeys = first.get();
        List groupList = Arrays.stream(groupKeys).filter(e -> QueryAuditUtils.validateFieldExist((String)e, (PropertyDescriptor[])propertyDescriptors)).collect(Collectors.toList());
        if (HussarUtils.isEmpty(groupList)) {
            throw new MongoRuntimeException("\u65e0\u5206\u7ec4\u5b57\u6bb5");
        }
        MatchOperation matchOperation = null;
        List<Criteria> criteriaList = this.createQueryWrapper(searchObj, parameterMap);
        if (ObjectUtil.isNotEmpty(criteriaList)) {
            Criteria[] criteria = (Criteria[])ConvertUtil.convert(criteriaList, Criteria[].class);
            matchOperation = Aggregation.match((Criteria)new Criteria().andOperator(criteria));
            aggregationOperationsList.add((AggregationOperation)matchOperation);
        }
        GroupOperation groupOperation = Aggregation.group((String[])((String[])ConvertUtil.convert(groupList, String[].class))).count().as("totalCount");
        aggregationOperationsList.add((AggregationOperation)groupOperation);
        if (groupList.size() == 1) {
            showFields = Aggregation.project((String[])new String[]{"totalCount"}).and("_id").as((String)groupList.get(0)).andExclude(new String[]{"_id"});
        } else {
            showFields = Aggregation.project((String[])new String[]{"totalCount"});
            for (String key : groupList) {
                showFields = showFields.and(key).as(key);
            }
        }
        aggregationOperationsList.add((AggregationOperation)showFields);
        return aggregationOperationsList;
    }

    @Override
    public List<Criteria> createQueryWrapper(Object searchObj, Map<String, String[]> parameterMap) {
        Class<?> objectClass = searchObj.getClass();
        PropertyDescriptor[] origDescriptors = HussarUtils.getPropertyDescriptors(objectClass);
        ArrayList<Criteria> criteriaList = new ArrayList<Criteria>();
        for (PropertyDescriptor origDescriptor : origDescriptors) {
            String name = origDescriptor.getName();
            Class<?> type = origDescriptor.getPropertyType();
            try {
                if (this.judgedIsUselessField(name) || !PropertyUtils.isReadable((Object)searchObj, (String)name)) continue;
                Object value = PropertyUtils.getSimpleProperty((Object)searchObj, (String)name);
                String column = this.getMongoDocumentFieldName(searchObj.getClass(), name);
                if (HussarUtils.isBlank((CharSequence)column)) continue;
                FieldMappingDto fieldMappingDto = new FieldMappingDto(name, column, type);
                this.doCreateQuery(criteriaList, parameterMap, fieldMappingDto, value);
            }
            catch (Exception e) {
                log.error("\u5b57\u6bb5:{} \u62fc\u63a5\u67e5\u8be2\u6784\u9020\u5668\u5f02\u5e38\uff1a{}", (Object)name, (Object)e.getMessage());
                throw new MongoRuntimeException(e);
            }
        }
        return criteriaList;
    }

    @Override
    public void doCreateQuery(List<Criteria> criteriaList, Map<String, String[]> parameterMap, FieldMappingDto fieldMappingDto, Object value) {
        if (HussarUtils.isNotEmpty((Object)value)) {
            fieldMappingDto.setFieldValue(value);
            fieldMappingDto.setRule(QueryRuleEnum.EQ);
            fieldMappingDto = QueryRuleEnum.EQ.getQueryStrategy().transFieldValue(fieldMappingDto);
            QueryRuleEnum.EQ.getQueryStrategy().joinQueryWrapper(criteriaList, fieldMappingDto);
            return;
        }
        if (HussarUtils.isNotEmpty(parameterMap)) {
            for (QueryRuleEnum queryRuleEnum : QueryRuleEnum.values()) {
                String paramKey = fieldMappingDto.getFieldName().concat(queryRuleEnum.getValue());
                if (!parameterMap.containsKey(paramKey)) continue;
                String paramValue = parameterMap.get(paramKey)[0].trim();
                fieldMappingDto.setFieldValue(paramValue);
                fieldMappingDto.setRule(queryRuleEnum);
                fieldMappingDto = queryRuleEnum.getQueryStrategy().transFieldValue(fieldMappingDto);
                queryRuleEnum.getQueryStrategy().joinQueryWrapper(criteriaList, fieldMappingDto);
            }
        }
    }

    @Override
    public Sort doMultiFieldOrder(Object searchObj, Map<String, String[]> parameterMap) {
        String orderRule = null;
        if (HussarUtils.isNotEmpty(parameterMap) && parameterMap.containsKey("orderRule")) {
            orderRule = parameterMap.get("orderRule")[0];
        }
        if (HussarUtils.isEmpty(orderRule)) {
            return null;
        }
        List sortOrderList = Arrays.stream(orderRule.split(";")).map(s -> {
            String[] split = s.split(",");
            String column = this.getMongoDocumentFieldName(searchObj.getClass(), split[0]);
            Sort.Order sdirectionOrder = split.length > 1 && "ASC".equalsIgnoreCase(split[1]) ? Sort.Order.asc((String)column) : Sort.Order.desc((String)column);
            return sdirectionOrder;
        }).collect(Collectors.toList());
        if (HussarUtils.isEmpty(sortOrderList)) {
            return null;
        }
        Sort by = Sort.by(sortOrderList);
        return by;
    }
}

