/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.audit.plugin.mongodb.config;

import com.jxdinfo.hussar.support.audit.core.auditlog.service.AuditColumnCURDService;
import com.jxdinfo.hussar.support.audit.core.auditlog.service.AuditLogCURDService;
import com.jxdinfo.hussar.support.audit.core.auditlog.service.AuditLogService;
import com.jxdinfo.hussar.support.audit.core.auditlog.service.AuditTableCURDService;
import com.jxdinfo.hussar.support.audit.plugin.mongodb.support.service.AuditColumnMongoCURDServiceImpl;
import com.jxdinfo.hussar.support.audit.plugin.mongodb.support.service.AuditLogMongoCURDServiceImpl;
import com.jxdinfo.hussar.support.audit.plugin.mongodb.support.service.AuditMongoServiceImpl;
import com.jxdinfo.hussar.support.audit.plugin.mongodb.support.service.AuditTableMongoCURDServiceImpl;
import java.util.List;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.mongodb.MongoDatabaseFactory;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationOptions;
import org.springframework.data.mongodb.core.aggregation.AggregationResults;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.repository.config.EnableMongoRepositories;

@Configuration
@ComponentScan(value={"com.jxdinfo.hussar.support.audit.plugin.mongodb"})
@EnableMongoRepositories(basePackages={"com.jxdinfo.hussar.support.audit.plugin.mongodb.repository"})
@ConditionalOnProperty(prefix="hussar.audit", name={"storage-type"}, havingValue="mongo")
public class AuditLogMongoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public AuditLogService auditLogService() {
        return new AuditMongoServiceImpl();
    }

    @Bean
    @ConditionalOnMissingBean
    public AuditLogCURDService auditLogCURDService() {
        return new AuditLogMongoCURDServiceImpl();
    }

    @Bean
    @ConditionalOnMissingBean
    public AuditTableCURDService auditTableCURDService() {
        return new AuditTableMongoCURDServiceImpl();
    }

    @Bean
    @ConditionalOnMissingBean
    public AuditColumnCURDService auditColumnCURDService() {
        return new AuditColumnMongoCURDServiceImpl();
    }

    @Bean
    @ConditionalOnMissingBean(value={MongoOperations.class})
    @ConditionalOnProperty(prefix="spring.data.mongodb", name={"allow-disk-use"}, havingValue="true", matchIfMissing=true)
    public MongoTemplate mongoTemplate(MongoDatabaseFactory factory, MongoConverter converter) {
        return new MongoTemplate(factory, converter){

            public <T> List<T> find(Query query, Class<T> entityClass, String collectionName) {
                query.allowDiskUse(true);
                return super.find(query, entityClass, collectionName);
            }

            public <T> AggregationResults<T> aggregate(Aggregation aggregation, String collectionName, Class<T> outputType) {
                AggregationOptions options = AggregationOptions.builder().allowDiskUse(true).build();
                return super.aggregate(aggregation.withOptions(options), collectionName, outputType);
            }
        };
    }
}

