/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.audit.plugin.dynamictable.service.impl;

import com.jxdinfo.hussar.platform.core.utils.date.format.DatePattern;
import com.jxdinfo.hussar.support.audit.plugin.dynamictable.service.ShardingRule;
import java.time.LocalDateTime;
import java.util.Date;
import org.apache.commons.lang3.ObjectUtils;

public class MonthShardingRule
implements ShardingRule {
    private final String MONTH_REGEX = "^\\d{4}(0[1-9]|1[0-2])$";

    @Override
    public boolean checkRule(String suffix) {
        return ObjectUtils.isNotEmpty((Object)suffix) && suffix.matches("^\\d{4}(0[1-9]|1[0-2])$");
    }

    @Override
    public String getDefaultSuffix() {
        return LocalDateTime.now().format(DatePattern.SIMPLE_MONTH_FORMATTER);
    }

    @Override
    public String getByObject(Object obj) {
        if (ObjectUtils.isEmpty((Object)obj)) {
            return null;
        }
        if (obj instanceof Long) {
            obj = new Date((Long)obj);
        }
        if (obj instanceof LocalDateTime) {
            return DatePattern.SIMPLE_MONTH_FORMATTER.format((LocalDateTime)obj);
        }
        if (obj instanceof Date) {
            return DatePattern.SIMPLE_MONTH_FORMAT.format((Date)obj);
        }
        return null;
    }
}

