/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.audit.plugin.dynamictable.mybatis.factory.impl;

import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.jxdinfo.hussar.datasource.manager.api.model.ColumnInfoDto;
import com.jxdinfo.hussar.datasource.manager.api.model.MetadataParam;
import com.jxdinfo.hussar.platform.core.utils.collection.Pair;
import com.jxdinfo.hussar.support.audit.plugin.dynamictable.mybatis.factory.BaseBuildTableService;
import java.sql.JDBCType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuildMysqlTableServiceImpl
extends BaseBuildTableService {
    private final Logger log = LoggerFactory.getLogger(BuildMysqlTableServiceImpl.class);
    private Map<String, Consumer<ColumnInfoDto>> JDBC_TYPE_2_METHOD;

    private void init() {
        if (ObjectUtils.isEmpty(this.JDBC_TYPE_2_METHOD)) {
            HashMap<String, Consumer<ColumnInfoDto>> jdbcType2Method = new HashMap<String, Consumer<ColumnInfoDto>>();
            jdbcType2Method.put(JDBCType.CHAR.name(), columnInfoDto -> columnInfoDto.setDataType("char"));
            jdbcType2Method.put(JDBCType.VARCHAR.name(), columnInfoDto -> columnInfoDto.setDataType("varchar"));
            jdbcType2Method.put(JDBCType.TIMESTAMP.name(), columnInfoDto -> columnInfoDto.setDataType("datetime"));
            jdbcType2Method.put(JDBCType.CLOB.name(), columnInfoDto -> columnInfoDto.setDataType("text"));
            jdbcType2Method.put(JDBCType.INTEGER.name(), this::buildIntColumn);
            jdbcType2Method.put(JDBCType.BIGINT.name(), this::buildBigIntColumn);
            this.JDBC_TYPE_2_METHOD = jdbcType2Method;
        }
    }

    @Override
    public List<ColumnInfoDto> changeDataTypeByJDBCType(List<ColumnInfoDto> param) {
        this.init();
        return param.stream().peek(action -> {
            String jdbcType = action.getJdbcType();
            Consumer<ColumnInfoDto> columnInfoDtoConsumer = this.JDBC_TYPE_2_METHOD.get(jdbcType);
            if (ObjectUtils.isNull((Object[])new Object[]{columnInfoDtoConsumer})) {
                throw new IllegalStateException(String.format("\u6682\u4e0d\u652f\u6301\u7c7b\u578b%s", jdbcType));
            }
            columnInfoDtoConsumer.accept((ColumnInfoDto)action);
        }).collect(Collectors.toList());
    }

    @Override
    public boolean buildNewTableByOldTable(String newTableName, Pair<String, String> oldTableName, Supplier<MetadataParam> supplier) {
        String createSql = String.format("CREATE TABLE %s LIKE %s", newTableName, oldTableName.getValue());
        return this.quicklyBuildSql(createSql) || super.buildNewTableByOldTable(newTableName, oldTableName, supplier);
    }

    private void buildIntColumn(ColumnInfoDto columnInfoDto) {
        columnInfoDto.setDataType("INT");
        columnInfoDto.setDataDot(Optional.ofNullable(columnInfoDto.getDataDot()).orElse(0));
    }

    private void buildBigIntColumn(ColumnInfoDto columnInfoDto) {
        columnInfoDto.setDataType("BIGINT");
        columnInfoDto.setDataDot(Optional.ofNullable(columnInfoDto.getDataDot()).orElse(0));
    }
}

