/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.audit.plugin.dynamictable.aop;

import com.baomidou.mybatisplus.annotation.TableName;
import com.jxdinfo.hussar.support.audit.core.annotations.DynamicTable;
import com.jxdinfo.hussar.support.audit.core.annotations.DynamicTables;
import com.jxdinfo.hussar.support.audit.core.support.cache.AuditLogThreadLocalCache;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

public class DynamicTableMethodInterceptor
implements MethodInterceptor {
    private final Logger log = LoggerFactory.getLogger(DynamicTableMethodInterceptor.class);
    private static final ExpressionParser parser = new SpelExpressionParser();
    private final Pattern pattern = Pattern.compile(".*\\(\"([^\"]+)\"\\)\\}");
    private final Map<String, String> NAME_2_TABLE_NAME = new HashMap<String, String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        ArrayList<DynamicTable> list = new ArrayList<DynamicTable>();
        try {
            DynamicTable dynamicTable;
            Method method = methodInvocation.getMethod();
            DynamicTables dynamicTables = (DynamicTables)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, DynamicTables.class);
            if (!ObjectUtils.isEmpty((Object)dynamicTables)) {
                list.addAll(Arrays.asList(dynamicTables.value()));
            }
            if (!ObjectUtils.isEmpty((Object)(dynamicTable = (DynamicTable)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, DynamicTable.class)))) {
                list.add(dynamicTable);
            }
            if (ObjectUtils.isEmpty(list)) {
                return methodInvocation.proceed();
            }
            this.preProcess(list, methodInvocation);
        }
        catch (Exception e) {
            this.log.error("\u52a8\u6001\u8868\u660e\u62e6\u622a\u5668\u524d\u7f6e\u5904\u7406\u5f02\u5e38", (Throwable)e);
        }
        try {
            Object object = methodInvocation.proceed();
            return object;
        }
        finally {
            this.postProcess(list, methodInvocation);
        }
    }

    private void preProcess(List<DynamicTable> dynamicTables, MethodInvocation methodInvocation) {
        try {
            StandardEvaluationContext context = new StandardEvaluationContext();
            Method method = methodInvocation.getMethod();
            Parameter[] parameters = method.getParameters();
            Object[] arguments = methodInvocation.getArguments();
            for (int i = 0; i < parameters.length; ++i) {
                context.setVariable(parameters[i].getName(), arguments[i]);
                context.setVariable("arg" + i, arguments[i]);
            }
            for (DynamicTable dynamicTable : dynamicTables) {
                try {
                    Object value = parser.parseExpression(dynamicTable.key()).getValue((EvaluationContext)context);
                    this.getNameByType(dynamicTable.type()).forEach(key -> AuditLogThreadLocalCache.setDynamicTableSuffix((String)key, (Object)value));
                }
                catch (Exception e) {
                    this.log.debug("\u89e3\u6790SpEL\u8868\u8fbe\u5f0f\u5f02\u5e38");
                }
            }
        }
        catch (Exception e) {
            this.log.error("\u52a8\u6001\u8868\u660e\u62e6\u622a\u5668\u524d\u7f6e\u5904\u7406\u5f02\u5e38", (Throwable)e);
        }
    }

    private void postProcess(List<DynamicTable> dynamicTables, MethodInvocation methodInvocation) {
        try {
            dynamicTables.stream().map(action -> this.getNameByType(action.type())).flatMap(Collection::stream).forEach(AuditLogThreadLocalCache::removeDynamicTableSuffix);
        }
        catch (Exception e) {
            this.log.error("\u52a8\u6001\u8868\u660e\u62e6\u622a\u5668\u540e\u7f6e\u5904\u7406\u5f02\u5e38", (Throwable)e);
        }
    }

    private List<String> getNameByType(Class<?> type) {
        Document document;
        TableName tableName = type.getAnnotation(TableName.class);
        ArrayList<String> result = new ArrayList<String>();
        if (ObjectUtils.isNotEmpty((Object)tableName)) {
            result.add(tableName.value());
        }
        if (ObjectUtils.isNotEmpty((Object)(document = type.getAnnotation(Document.class)))) {
            String collection = document.collection();
            String documentName = this.NAME_2_TABLE_NAME.get(collection);
            if (ObjectUtils.isNotEmpty((Object)documentName)) {
                result.add(documentName);
            } else {
                Matcher matcher = this.pattern.matcher(collection);
                if (matcher.find()) {
                    documentName = matcher.group(1);
                    result.add(documentName);
                    this.NAME_2_TABLE_NAME.put(collection, documentName);
                }
            }
        }
        if (ObjectUtils.isEmpty(result)) {
            result.add(type.toString());
        }
        return result;
    }
}

