/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.audit.plugin.dynamictable.controller;

import com.jxdinfo.hussar.support.audit.core.support.dynamictable.DynamicTableHandler;
import com.jxdinfo.hussar.support.audit.plugin.dynamictable.factory.DynamicTableProcessorFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.scheduling.annotation.Scheduled;

public class AutoCreateTables
implements ApplicationRunner {
    Logger log = LoggerFactory.getLogger(AutoCreateTables.class);
    @Autowired(required=false)
    private DynamicTableHandler dynamicTableHandler;

    public void run(ApplicationArguments args) throws Exception {
        this.createTableByTime(System.currentTimeMillis());
    }

    @Scheduled(cron="0 0 22 * * ?")
    public void scheduledCreateTables() {
        long targetTime = System.currentTimeMillis() + TimeUnit.DAYS.toMillis(1L);
        this.createTableByTime(targetTime);
    }

    private void createTableByTime(long time) {
        if (ObjectUtils.isNotEmpty((Object)this.dynamicTableHandler)) {
            DynamicTableProcessorFactory.getAll().forEach((k, processor) -> {
                processor.addSuffix(time);
                this.dynamicTableHandler.dynamicTableName(k);
            });
        }
    }
}

