/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.audit.plugin.dao.handler;

import com.baomidou.dynamic.datasource.ds.ItemDataSource;
import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.extension.plugins.handler.TableNameHandler;
import com.jxdinfo.hussar.datasource.manager.api.service.HussarDdlService;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import com.jxdinfo.hussar.support.audit.core.support.cache.AuditLogThreadLocalCache;
import com.jxdinfo.hussar.support.audit.core.util.DataSourceUtil;
import com.jxdinfo.hussar.support.audit.plugin.dao.action.DDLSqlBuildAction;
import com.jxdinfo.hussar.support.audit.plugin.dao.enums.CreateTableBuildEnum;
import com.jxdinfo.hussar.support.audit.plugin.dao.factory.BaseBuildTableService;
import com.jxdinfo.hussar.support.audit.plugin.dao.factory.BuildTableFactory;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.sql.DataSource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Order(value=100)
public class AuditLogTableNameHandler
implements TableNameHandler {
    private static final Logger log = LoggerFactory.getLogger(AuditLogTableNameHandler.class);
    public static final Set<String> TABLE_NAME_SET = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
    @Autowired(required=false)
    private DataSource dataSource;
    @Autowired(required=false)
    private HussarDdlService hussarDdlService;

    public String dynamicTableName(String sql, String schemaTableName) {
        DDLSqlBuildAction ddlSqlBuildAction;
        String[] split = schemaTableName.split("\\.");
        String schema = "";
        String tableName = split[split.length - 1];
        if (schemaTableName.length() > tableName.length()) {
            schema = schemaTableName.substring(0, schemaTableName.length() - tableName.length());
        }
        if (ObjectUtils.isEmpty((Object)(ddlSqlBuildAction = CreateTableBuildEnum.getByTableName(tableName)))) {
            return schemaTableName;
        }
        String suffix = AuditLogThreadLocalCache.getDynamicTableName();
        String newTableName = ddlSqlBuildAction.getNewTableName(tableName, suffix);
        if (!TABLE_NAME_SET.contains(newTableName)) {
            ((AuditLogTableNameHandler)SpringContextUtil.getBean(this.getClass())).checkAndCreateNewTable(newTableName, tableName);
        }
        return schema + newTableName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(propagation=Propagation.NOT_SUPPORTED)
    public void checkAndCreateNewTable(String newTableName, String oldTableName) {
        try {
            if (TABLE_NAME_SET.contains(newTableName)) {
                return;
            }
            if (ObjectUtils.isEmpty((Object)this.hussarDdlService) || ObjectUtils.isEmpty((Object)this.dataSource)) {
                log.error("\u6570\u636e\u5e93\u6216ddlService\u4e3a\u7a7a\uff1a{},{}", (Object)this.hussarDdlService, (Object)this.dataSource);
                return;
            }
            List newTableMetaData = this.hussarDdlService.selectTablesByTableNames(Collections.singletonList(newTableName), "master");
            if (CollectionUtils.isNotEmpty((Collection)newTableMetaData)) {
                TABLE_NAME_SET.add(newTableName);
                return;
            }
            ItemDataSource itemDataSource = DataSourceUtil.getCurrentItemSource((DataSource)this.dataSource);
            if (itemDataSource == null) {
                log.error("\u83b7\u53d6\u6570\u636e\u5e93\u94fe\u63a5\u5f02\u5e38");
                return;
            }
            DbType dbType = itemDataSource.getDbType();
            BaseBuildTableService action = BuildTableFactory.getAction(dbType);
            String string = newTableName.intern();
            synchronized (string) {
                boolean flag;
                if (!TABLE_NAME_SET.contains(newTableName) && (flag = action.buildNewTableByOldTable(newTableName, oldTableName))) {
                    TABLE_NAME_SET.add(newTableName);
                }
            }
        }
        catch (Exception e) {
            log.error("\u68c0\u6d4b\u6216\u521b\u5efa\u8868\u5f02\u5e38", (Throwable)e);
        }
    }
}

